/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.VideoHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.HrdParameters;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractVuiParamters;
import nl.digitalekabeltelevisie.util.BitSource;

public class VuiParameters
extends AbstractVuiParamters
implements TreeNode {
    private final int timing_info_present_flag;
    private int num_units_in_tick;
    private int time_scale;
    private int fixed_frame_rate_flag;
    private final int nal_hrd_parameters_present_flag;
    private HrdParameters nal_hrd_parameters;
    private final int vcl_hrd_parameters_present_flag;
    private HrdParameters vcl_hrd_parameters;
    private int low_delay_hrd_flag;
    private final int pic_struct_present_flag;
    private final int bitstream_restriction_flag;
    private int motion_vectors_over_pic_boundaries_flag;
    private int max_bytes_per_pic_denom;
    private int max_bits_per_mb_denom;
    private int log2_max_mv_length_horizontal;
    private int log2_max_mv_length_vertical;
    private int num_reorder_frames;
    private int max_dec_frame_buffering;

    public VuiParameters(BitSource bitSource) {
        super(bitSource);
        this.timing_info_present_flag = bitSource.u(1);
        if (this.timing_info_present_flag != 0) {
            this.num_units_in_tick = bitSource.u(32);
            this.time_scale = bitSource.u(32);
            this.fixed_frame_rate_flag = bitSource.u(1);
        }
        this.nal_hrd_parameters_present_flag = bitSource.u(1);
        if (this.nal_hrd_parameters_present_flag != 0) {
            this.nal_hrd_parameters = new HrdParameters(bitSource);
        }
        this.vcl_hrd_parameters_present_flag = bitSource.u(1);
        if (this.vcl_hrd_parameters_present_flag != 0) {
            this.vcl_hrd_parameters = new HrdParameters(bitSource);
        }
        if (this.nal_hrd_parameters_present_flag != 0 || this.vcl_hrd_parameters_present_flag != 0) {
            this.low_delay_hrd_flag = bitSource.u(1);
        }
        this.pic_struct_present_flag = bitSource.u(1);
        this.bitstream_restriction_flag = bitSource.u(1);
        if (this.bitstream_restriction_flag != 0) {
            this.motion_vectors_over_pic_boundaries_flag = bitSource.u(1);
            this.max_bytes_per_pic_denom = bitSource.ue();
            this.max_bits_per_mb_denom = bitSource.ue();
            this.log2_max_mv_length_horizontal = bitSource.ue();
            this.log2_max_mv_length_vertical = bitSource.ue();
            this.num_reorder_frames = bitSource.ue();
            this.max_dec_frame_buffering = bitSource.ue();
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("vui_parameters"));
        this.addCommonFields(t);
        t.add(new DefaultMutableTreeNode(new KVP("timing_info_present_flag", this.timing_info_present_flag, null)));
        if (this.timing_info_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("num_units_in_tick", this.num_units_in_tick, null)));
            t.add(new DefaultMutableTreeNode(new KVP("time_scale", this.time_scale, VideoHandler.getClockTickString(this.num_units_in_tick, this.time_scale))));
            t.add(new DefaultMutableTreeNode(new KVP("fixed_frame_rate_flag", this.fixed_frame_rate_flag, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("nal_hrd_parameters_present_flag", this.nal_hrd_parameters_present_flag, null)));
        if (this.nal_hrd_parameters_present_flag != 0) {
            t.add(this.nal_hrd_parameters.getJTreeNode(modus));
        }
        t.add(new DefaultMutableTreeNode(new KVP("vcl_hrd_parameters_present_flag", this.vcl_hrd_parameters_present_flag, null)));
        if (this.vcl_hrd_parameters_present_flag != 0) {
            t.add(this.vcl_hrd_parameters.getJTreeNode(modus));
        }
        if (this.nal_hrd_parameters_present_flag != 0 || this.vcl_hrd_parameters_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("low_delay_hrd_flag", this.low_delay_hrd_flag, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("pic_struct_present_flag", this.pic_struct_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bitstream_restriction_flag", this.bitstream_restriction_flag, null)));
        if (this.bitstream_restriction_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("motion_vectors_over_pic_boundaries_flag", this.motion_vectors_over_pic_boundaries_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("max_bytes_per_pic_denom", this.max_bytes_per_pic_denom, null)));
            t.add(new DefaultMutableTreeNode(new KVP("max_bits_per_mb_denom", this.max_bits_per_mb_denom, null)));
            t.add(new DefaultMutableTreeNode(new KVP("log2_max_mv_length_horizontal", this.log2_max_mv_length_horizontal, null)));
            t.add(new DefaultMutableTreeNode(new KVP("log2_max_mv_length_vertical", this.log2_max_mv_length_vertical, null)));
            t.add(new DefaultMutableTreeNode(new KVP("num_reorder_frames", this.num_reorder_frames, null)));
            t.add(new DefaultMutableTreeNode(new KVP("max_dec_frame_buffering", this.max_dec_frame_buffering, null)));
        }
        return t;
    }

    public int getTiming_info_present_flag() {
        return this.timing_info_present_flag;
    }

    public int getNum_units_in_tick() {
        return this.num_units_in_tick;
    }

    public int getTime_scale() {
        return this.time_scale;
    }

    public int getFixed_frame_rate_flag() {
        return this.fixed_frame_rate_flag;
    }

    public int getNal_hrd_parameters_present_flag() {
        return this.nal_hrd_parameters_present_flag;
    }

    public int getVcl_hrd_parameters_present_flag() {
        return this.vcl_hrd_parameters_present_flag;
    }

    public int getLow_delay_hrd_flag() {
        return this.low_delay_hrd_flag;
    }

    public int getPic_struct_present_flag() {
        return this.pic_struct_present_flag;
    }

    public int getBitstream_restriction_flag() {
        return this.bitstream_restriction_flag;
    }

    public int getMotion_vectors_over_pic_boundaries_flag() {
        return this.motion_vectors_over_pic_boundaries_flag;
    }

    public int getMax_bytes_per_pic_denom() {
        return this.max_bytes_per_pic_denom;
    }

    public int getMax_bits_per_mb_denom() {
        return this.max_bits_per_mb_denom;
    }

    public int getLog2_max_mv_length_horizontal() {
        return this.log2_max_mv_length_horizontal;
    }

    public int getLog2_max_mv_length_vertical() {
        return this.log2_max_mv_length_vertical;
    }

    public int getNum_reorder_frames() {
        return this.num_reorder_frames;
    }

    public int getMax_dec_frame_buffering() {
        return this.max_dec_frame_buffering;
    }
}

