/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.SubLayerHRDParameters;
import nl.digitalekabeltelevisie.util.BitSource;

public class H265HrdParameters
implements TreeNode {
    private final int commonInfPresentFlag;
    private final int maxNumSubLayersMinus1;
    private int nal_hrd_parameters_present_flag;
    private int vcl_hrd_parameters_present_flag;
    private int sub_pic_hrd_params_present_flag;
    private int tick_divisor_minus2;
    private int du_cpb_removal_delay_increment_length_minus1;
    private int sub_pic_cpb_params_in_pic_timing_sei_flag;
    private int dpb_output_delay_du_length_minus1;
    private int bit_rate_scale;
    private int cpb_size_scale;
    private int cpb_size_du_scale;
    private int initial_cpb_removal_delay_length_minus1;
    private int au_cpb_removal_delay_length_minus1;
    private int dpb_output_delay_length_minus1;
    private final int[] fixed_pic_rate_general_flag;
    private final int[] fixed_pic_rate_within_cvs_flag;
    private final int[] elemental_duration_in_tc_minus1;
    private final int[] low_delay_hrd_flag;
    private final int[] cpb_cnt_minus1;
    private final SubLayerHRDParameters[] sub_layer_hrd_parameters_nal;
    private final SubLayerHRDParameters[] sub_layer_hrd_parameters_vcl;

    public H265HrdParameters(int commonInfPresentFlag, int maxNumSubLayersMinus1, BitSource bitSource) {
        this.commonInfPresentFlag = commonInfPresentFlag;
        this.maxNumSubLayersMinus1 = maxNumSubLayersMinus1;
        if (commonInfPresentFlag == 1) {
            this.nal_hrd_parameters_present_flag = bitSource.u(1);
            this.vcl_hrd_parameters_present_flag = bitSource.u(1);
            if (this.nal_hrd_parameters_present_flag == 1 || this.vcl_hrd_parameters_present_flag == 1) {
                this.sub_pic_hrd_params_present_flag = bitSource.u(1);
                if (this.sub_pic_hrd_params_present_flag == 1) {
                    this.tick_divisor_minus2 = bitSource.u(8);
                    this.du_cpb_removal_delay_increment_length_minus1 = bitSource.u(5);
                    this.sub_pic_cpb_params_in_pic_timing_sei_flag = bitSource.u(1);
                    this.dpb_output_delay_du_length_minus1 = bitSource.u(5);
                }
                this.bit_rate_scale = bitSource.u(4);
                this.cpb_size_scale = bitSource.u(4);
                if (this.sub_pic_hrd_params_present_flag == 1) {
                    this.cpb_size_du_scale = bitSource.u(4);
                }
                this.initial_cpb_removal_delay_length_minus1 = bitSource.u(5);
                this.au_cpb_removal_delay_length_minus1 = bitSource.u(5);
                this.dpb_output_delay_length_minus1 = bitSource.u(5);
            }
        }
        this.fixed_pic_rate_general_flag = new int[maxNumSubLayersMinus1 + 1];
        this.fixed_pic_rate_within_cvs_flag = new int[maxNumSubLayersMinus1 + 1];
        this.elemental_duration_in_tc_minus1 = new int[maxNumSubLayersMinus1 + 1];
        this.low_delay_hrd_flag = new int[maxNumSubLayersMinus1 + 1];
        this.cpb_cnt_minus1 = new int[maxNumSubLayersMinus1 + 1];
        this.sub_layer_hrd_parameters_nal = new SubLayerHRDParameters[maxNumSubLayersMinus1 + 1];
        this.sub_layer_hrd_parameters_vcl = new SubLayerHRDParameters[maxNumSubLayersMinus1 + 1];
        for (int i = 0; i <= maxNumSubLayersMinus1; ++i) {
            this.fixed_pic_rate_general_flag[i] = bitSource.u(1);
            this.fixed_pic_rate_within_cvs_flag[i] = this.fixed_pic_rate_general_flag[i] == 0 ? bitSource.u(1) : 1;
            if (this.fixed_pic_rate_within_cvs_flag[i] != 0) {
                this.elemental_duration_in_tc_minus1[i] = bitSource.ue();
            } else {
                this.low_delay_hrd_flag[i] = bitSource.u(1);
            }
            if (this.low_delay_hrd_flag[i] == 0) {
                this.cpb_cnt_minus1[i] = bitSource.ue();
            }
            if (this.nal_hrd_parameters_present_flag != 0) {
                this.sub_layer_hrd_parameters_nal[i] = new SubLayerHRDParameters(i, this.cpb_cnt_minus1[i], this.sub_pic_hrd_params_present_flag, bitSource);
            }
            if (this.vcl_hrd_parameters_present_flag == 0) continue;
            this.sub_layer_hrd_parameters_vcl[i] = new SubLayerHRDParameters(i, this.cpb_cnt_minus1[i], this.sub_pic_hrd_params_present_flag, bitSource);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("hrd_parameters(commonInfPresentFlag=" + this.commonInfPresentFlag + ", maxNumSubLayersMinus1=" + this.maxNumSubLayersMinus1 + ")"));
        t.add(new DefaultMutableTreeNode(new KVP("nal_hrd_parameters_present_flag", this.nal_hrd_parameters_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vcl_hrd_parameters_present_flag", this.vcl_hrd_parameters_present_flag, null)));
        if (this.nal_hrd_parameters_present_flag == 1 || this.vcl_hrd_parameters_present_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("sub_pic_hrd_params_present_flag", this.sub_pic_hrd_params_present_flag, null)));
            if (this.sub_pic_hrd_params_present_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("tick_divisor_minus2", this.tick_divisor_minus2, null)));
                t.add(new DefaultMutableTreeNode(new KVP("du_cpb_removal_delay_increment_length_minus1", this.du_cpb_removal_delay_increment_length_minus1, null)));
                t.add(new DefaultMutableTreeNode(new KVP("sub_pic_cpb_params_in_pic_timing_sei_flag", this.sub_pic_cpb_params_in_pic_timing_sei_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("dpb_output_delay_du_length_minus1", this.dpb_output_delay_du_length_minus1, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("bit_rate_scale", this.bit_rate_scale, null)));
            t.add(new DefaultMutableTreeNode(new KVP("cpb_size_scale", this.cpb_size_scale, null)));
            if (this.sub_pic_hrd_params_present_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("cpb_size_du_scale", this.cpb_size_du_scale, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("initial_cpb_removal_delay_length_minus1", this.initial_cpb_removal_delay_length_minus1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("au_cpb_removal_delay_length_minus1", this.au_cpb_removal_delay_length_minus1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("dpb_output_delay_length_minus1", this.dpb_output_delay_length_minus1, null)));
        }
        for (int i = 0; i <= this.maxNumSubLayersMinus1; ++i) {
            t.add(new DefaultMutableTreeNode(new KVP("fixed_pic_rate_general_flag[" + i + "]", this.fixed_pic_rate_general_flag[i], this.fixed_pic_rate_general_flag[i] == 1 ? "the value of fixed_pic_rate_within_cvs_flag[i] is inferred to be equal to 1" : "fixed_pic_rate_within_cvs_flag[i] specified next")));
            if (this.fixed_pic_rate_general_flag[i] == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("fixed_pic_rate_within_cvs_flag[" + i + "]", this.fixed_pic_rate_within_cvs_flag[i], null)));
            }
            if (this.fixed_pic_rate_within_cvs_flag[i] != 0) {
                t.add(new DefaultMutableTreeNode(new KVP("elemental_duration_in_tc_minus1[" + i + "]", this.elemental_duration_in_tc_minus1[i], null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("low_delay_hrd_flag[" + i + "]", this.low_delay_hrd_flag[i], null)));
            }
            if (this.low_delay_hrd_flag[i] == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("cpb_cnt_minus1[" + i + "]", this.cpb_cnt_minus1[i], null)));
            }
            if (this.nal_hrd_parameters_present_flag != 0) {
                t.add(this.sub_layer_hrd_parameters_nal[i].getJTreeNode(modus));
            }
            if (this.vcl_hrd_parameters_present_flag == 0) continue;
            t.add(this.sub_layer_hrd_parameters_vcl[i].getJTreeNode(modus));
        }
        return t;
    }
}

