/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.VideoHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.H265HrdParameters;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractVuiParamters;
import nl.digitalekabeltelevisie.util.BitSource;

public class H265VuiParameters
extends AbstractVuiParamters
implements TreeNode {
    private final int sps_max_sub_layers_minus1;
    private final int neutral_chroma_indication_flag;
    private final int field_seq_flag;
    private final int frame_field_info_present_flag;
    private final int default_display_window_flag;
    private int def_disp_win_left_offset;
    private int def_disp_win_right_offset;
    private int def_disp_win_top_offset;
    private int def_disp_win_bottom_offset;
    private final int vui_timing_info_present_flag;
    private long vui_num_units_in_tick;
    private long vui_time_scale;
    private int vui_poc_proportional_to_timing_flag;
    private int vui_num_ticks_poc_diff_one_minus1;
    private int vui_hrd_parameters_present_flag;
    private H265HrdParameters hrd_parameters;
    private final int bitstream_restriction_flag;
    private int tiles_fixed_structure_flag;
    private int motion_vectors_over_pic_boundaries_flag;
    private int restricted_ref_pic_lists_flag;
    private int min_spatial_segmentation_idc;
    private int max_bytes_per_pic_denom;
    private int max_bits_per_min_cu_denom;
    private int log2_max_mv_length_horizontal;
    private int log2_max_mv_length_vertical;

    public H265VuiParameters(int sps_max_sub_layers_minus1, BitSource bitSource) {
        super(bitSource);
        this.sps_max_sub_layers_minus1 = sps_max_sub_layers_minus1;
        this.neutral_chroma_indication_flag = bitSource.u(1);
        this.field_seq_flag = bitSource.u(1);
        this.frame_field_info_present_flag = bitSource.u(1);
        this.default_display_window_flag = bitSource.u(1);
        if (this.default_display_window_flag == 1) {
            this.def_disp_win_left_offset = bitSource.ue();
            this.def_disp_win_right_offset = bitSource.ue();
            this.def_disp_win_top_offset = bitSource.ue();
            this.def_disp_win_bottom_offset = bitSource.ue();
        }
        this.vui_timing_info_present_flag = bitSource.u(1);
        if (this.vui_timing_info_present_flag == 1) {
            this.vui_num_units_in_tick = bitSource.readBitsLong(32);
            this.vui_time_scale = bitSource.readBitsLong(32);
            this.vui_poc_proportional_to_timing_flag = bitSource.u(1);
            if (this.vui_poc_proportional_to_timing_flag == 1) {
                this.vui_num_ticks_poc_diff_one_minus1 = bitSource.ue();
            }
            this.vui_hrd_parameters_present_flag = bitSource.u(1);
            if (this.vui_hrd_parameters_present_flag == 1) {
                this.hrd_parameters = new H265HrdParameters(1, sps_max_sub_layers_minus1, bitSource);
            }
        }
        this.bitstream_restriction_flag = bitSource.u(1);
        if (this.bitstream_restriction_flag != 0) {
            this.tiles_fixed_structure_flag = bitSource.u(1);
            this.motion_vectors_over_pic_boundaries_flag = bitSource.u(1);
            this.restricted_ref_pic_lists_flag = bitSource.u(1);
            this.min_spatial_segmentation_idc = bitSource.ue();
            this.max_bytes_per_pic_denom = bitSource.ue();
            this.max_bits_per_min_cu_denom = bitSource.ue();
            this.log2_max_mv_length_horizontal = bitSource.ue();
            this.log2_max_mv_length_vertical = bitSource.ue();
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("vui_parameters"));
        this.addCommonFields(t);
        t.add(new DefaultMutableTreeNode(new KVP("neutral_chroma_indication_flag", this.neutral_chroma_indication_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("field_seq_flag", this.field_seq_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_field_info_present_flag", this.frame_field_info_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("default_display_window_flag", this.default_display_window_flag, null)));
        if (this.default_display_window_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("def_disp_win_left_offset", this.def_disp_win_left_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("def_disp_win_right_offset", this.def_disp_win_right_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("def_disp_win_top_offset", this.def_disp_win_top_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("def_disp_win_bottom_offset", this.def_disp_win_bottom_offset, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("vui_timing_info_present_flag", this.vui_timing_info_present_flag, null)));
        if (this.vui_timing_info_present_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("vui_num_units_in_tick", this.vui_num_units_in_tick, null)));
            t.add(new DefaultMutableTreeNode(new KVP("vui_time_scale", this.vui_time_scale, VideoHandler.getClockTickString(this.vui_num_units_in_tick, this.vui_time_scale))));
            t.add(new DefaultMutableTreeNode(new KVP("vui_poc_proportional_to_timing_flag", this.vui_poc_proportional_to_timing_flag, null)));
            if (this.vui_poc_proportional_to_timing_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("vui_num_ticks_poc_diff_one_minus1", this.vui_num_ticks_poc_diff_one_minus1, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("vui_hrd_parameters_present_flag", this.vui_hrd_parameters_present_flag, null)));
            if (this.vui_hrd_parameters_present_flag == 1) {
                t.add(this.hrd_parameters.getJTreeNode(modus));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("bitstream_restriction_flag", this.bitstream_restriction_flag, null)));
        if (this.bitstream_restriction_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("tiles_fixed_structure_flag", this.tiles_fixed_structure_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("motion_vectors_over_pic_boundaries_flag", this.motion_vectors_over_pic_boundaries_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("restricted_ref_pic_lists_flag", this.restricted_ref_pic_lists_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("min_spatial_segmentation_idc", this.min_spatial_segmentation_idc, null)));
            t.add(new DefaultMutableTreeNode(new KVP("max_bytes_per_pic_denom", this.max_bytes_per_pic_denom, null)));
            t.add(new DefaultMutableTreeNode(new KVP("max_bits_per_min_cu_denom", this.max_bits_per_min_cu_denom, null)));
            t.add(new DefaultMutableTreeNode(new KVP("log2_max_mv_length_horizontal", this.log2_max_mv_length_horizontal, null)));
            t.add(new DefaultMutableTreeNode(new KVP("log2_max_mv_length_vertical", this.log2_max_mv_length_vertical, null)));
        }
        return t;
    }
}

