/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;

public class StRefPicSet
implements TreeNode {
    private static final Logger logger = Logger.getLogger(StRefPicSet.class.getName());
    private int stRpsIdx;
    private int inter_ref_pic_set_prediction_flag;
    private int delta_idx_minus1;
    private int delta_rps_sign;
    private int abs_delta_rps_minus1;
    private int[] used_by_curr_pic_flag;
    private int num_negative_pics;
    private int num_positive_pics;
    private int[] delta_poc_s0_minus1;
    private int[] used_by_curr_pic_s0_flag;
    private int[] delta_poc_s1_minus1;
    private int[] used_by_curr_pic_s1_flag;
    boolean notImplemented = false;

    public StRefPicSet(int stRpsIdx, int num_short_term_ref_pic_sets, BitSource bitSource) {
        this.stRpsIdx = stRpsIdx;
        if (stRpsIdx != 0) {
            this.inter_ref_pic_set_prediction_flag = bitSource.u(1);
        }
        if (this.inter_ref_pic_set_prediction_flag != 0) {
            this.notImplemented = true;
            logger.warning("if( inter_ref_pic_set_prediction_flag ) not implemented");
        } else {
            int i;
            this.num_negative_pics = bitSource.ue();
            this.num_positive_pics = bitSource.ue();
            this.delta_poc_s0_minus1 = new int[this.num_negative_pics];
            this.used_by_curr_pic_s0_flag = new int[this.num_negative_pics];
            for (i = 0; i < this.num_negative_pics; ++i) {
                this.delta_poc_s0_minus1[i] = bitSource.ue();
                this.used_by_curr_pic_s0_flag[i] = bitSource.u(1);
            }
            this.delta_poc_s1_minus1 = new int[this.num_positive_pics];
            this.used_by_curr_pic_s1_flag = new int[this.num_positive_pics];
            for (i = 0; i < this.num_positive_pics; ++i) {
                this.delta_poc_s1_minus1[i] = bitSource.ue();
                this.used_by_curr_pic_s1_flag[i] = bitSource.u(1);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Short-term reference picture set st_ref_pic_set(" + this.stRpsIdx + ")"));
        if (this.stRpsIdx != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("inter_ref_pic_set_prediction_flag", this.inter_ref_pic_set_prediction_flag, null)));
        }
        if (this.notImplemented) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("if( inter_ref_pic_set_prediction_flag ) {")));
            return t;
        }
        if (this.inter_ref_pic_set_prediction_flag == 0) {
            int i;
            t.add(new DefaultMutableTreeNode(new KVP("num_negative_pics", this.num_negative_pics, null)));
            t.add(new DefaultMutableTreeNode(new KVP("num_positive_pics", this.num_positive_pics, null)));
            this.delta_poc_s0_minus1 = new int[this.num_negative_pics];
            this.used_by_curr_pic_s0_flag = new int[this.num_negative_pics];
            for (i = 0; i < this.num_negative_pics; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("delta_poc_s0_minus1[" + i + "]", this.delta_poc_s0_minus1[i], null)));
                t.add(new DefaultMutableTreeNode(new KVP("used_by_curr_pic_s0_flag[" + i + "]", this.used_by_curr_pic_s0_flag[i], null)));
            }
            this.delta_poc_s1_minus1 = new int[this.num_positive_pics];
            this.used_by_curr_pic_s1_flag = new int[this.num_positive_pics];
            for (i = 0; i < this.num_positive_pics; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("delta_poc_s1_minus1[" + i + "]", this.delta_poc_s1_minus1[i], null)));
                t.add(new DefaultMutableTreeNode(new KVP("used_by_curr_pic_s1_flag[" + i + "]", this.used_by_curr_pic_s1_flag[i], null)));
            }
        }
        return t;
    }
}

