/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;

public class SubLayerHRDParameters
implements TreeNode {
    private final int subLayerId;
    private final int[] bit_rate_value_minus1;
    private final int[] cpb_size_value_minus1;
    private final int[] cpb_size_du_value_minus1;
    private final int[] bit_rate_du_value_minus1;
    private final int[] cbr_flag;
    private final int CpbCnt;
    private final int sub_pic_hrd_params_present_flag;

    public SubLayerHRDParameters(int subLayerId, int CpbCnt, int sub_pic_hrd_params_present_flag, BitSource bitSource) {
        this.subLayerId = subLayerId;
        this.CpbCnt = CpbCnt;
        this.sub_pic_hrd_params_present_flag = sub_pic_hrd_params_present_flag;
        this.bit_rate_value_minus1 = new int[CpbCnt + 1];
        this.cpb_size_value_minus1 = new int[CpbCnt + 1];
        this.cpb_size_du_value_minus1 = new int[CpbCnt + 1];
        this.bit_rate_du_value_minus1 = new int[CpbCnt + 1];
        this.cbr_flag = new int[CpbCnt + 1];
        for (int i = 0; i <= CpbCnt; ++i) {
            this.bit_rate_value_minus1[i] = bitSource.ue();
            this.cpb_size_value_minus1[i] = bitSource.ue();
            if (sub_pic_hrd_params_present_flag != 0) {
                this.cpb_size_du_value_minus1[i] = bitSource.ue();
                this.bit_rate_du_value_minus1[i] = bitSource.ue();
            }
            this.cbr_flag[i] = bitSource.u(1);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("SubLayerHRDParameters(i=" + this.subLayerId + ")"));
        for (int i = 0; i <= this.CpbCnt; ++i) {
            t.add(new DefaultMutableTreeNode(new KVP("bit_rate_value_minus1[" + i + "]", this.bit_rate_value_minus1[i], null)));
            t.add(new DefaultMutableTreeNode(new KVP("cpb_size_value_minus1[" + i + "]", this.cpb_size_value_minus1[i], null)));
            if (this.sub_pic_hrd_params_present_flag != 0) {
                t.add(new DefaultMutableTreeNode(new KVP("cpb_size_du_value_minus1[" + i + "]", this.cpb_size_du_value_minus1[i], null)));
                t.add(new DefaultMutableTreeNode(new KVP("bit_rate_du_value_minus1[" + i + "]", this.bit_rate_du_value_minus1[i], null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("cbr_flag[" + i + "]", this.cbr_flag[i], null)));
        }
        return t;
    }
}

