/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.VideoHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.H265HrdParameters;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.ProfileTierLevel;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;

public class Video_parameter_set_rbsp
extends RBSP {
    private static final Logger logger = Logger.getLogger(Video_parameter_set_rbsp.class.getName());
    private final int vps_video_parameter_set_id;
    private final int vps_base_layer_internal_flag;
    private final int vps_base_layer_available_flag;
    private final int vps_max_layers_minus1;
    private final int vps_max_sub_layers_minus1;
    private final int vps_temporal_id_nesting_flag;
    private final int vps_reserved_0xffff_16bits;
    private final ProfileTierLevel profile_tier_level;
    private final int vps_sub_layer_ordering_info_present_flag;
    private final int[] vps_max_dec_pic_buffering_minus1;
    private final int[] vps_max_num_reorder_pics;
    private final int[] vps_max_latency_increase_plus1;
    private final int vps_max_layer_id;
    private final int vps_num_layer_sets_minus1;
    private final int[][] layer_id_included_flag;
    private final int vps_timing_info_present_flag;
    private long vps_num_units_in_tick;
    private long vps_time_scale;
    private int vps_poc_proportional_to_timing_flag;
    private int vps_num_ticks_poc_diff_one_minus1;
    private int vps_num_hrd_parameters;
    private int[] hrd_layer_set_idx;
    private int[] cprms_present_flag;
    private H265HrdParameters[] hrd_parameters;
    private int vps_extension_flag;

    public Video_parameter_set_rbsp(byte[] rbsp_bytes, int numBytesInRBSP) {
        super(rbsp_bytes, numBytesInRBSP);
        int i;
        this.vps_video_parameter_set_id = this.bitSource.u(4);
        this.vps_base_layer_internal_flag = this.bitSource.u(1);
        this.vps_base_layer_available_flag = this.bitSource.u(1);
        this.vps_max_layers_minus1 = this.bitSource.u(6);
        this.vps_max_sub_layers_minus1 = this.bitSource.u(3);
        this.vps_temporal_id_nesting_flag = this.bitSource.u(1);
        this.vps_reserved_0xffff_16bits = this.bitSource.u(16);
        this.profile_tier_level = new ProfileTierLevel(1, this.vps_max_sub_layers_minus1, this.bitSource);
        this.vps_sub_layer_ordering_info_present_flag = this.bitSource.u(1);
        this.vps_max_dec_pic_buffering_minus1 = new int[this.vps_max_sub_layers_minus1 + 1];
        this.vps_max_num_reorder_pics = new int[this.vps_max_sub_layers_minus1 + 1];
        this.vps_max_latency_increase_plus1 = new int[this.vps_max_sub_layers_minus1 + 1];
        int n = i = this.vps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.vps_max_sub_layers_minus1;
        while (i <= this.vps_max_sub_layers_minus1) {
            this.vps_max_dec_pic_buffering_minus1[i] = this.bitSource.ue();
            this.vps_max_num_reorder_pics[i] = this.bitSource.ue();
            this.vps_max_latency_increase_plus1[i] = this.bitSource.ue();
            ++i;
        }
        this.vps_max_layer_id = this.bitSource.u(6);
        this.vps_num_layer_sets_minus1 = this.bitSource.ue();
        this.layer_id_included_flag = new int[this.vps_num_layer_sets_minus1 + 1][this.vps_max_layer_id + 1];
        for (i = 1; i <= this.vps_num_layer_sets_minus1; ++i) {
            for (int j = 0; j <= this.vps_max_layer_id; ++j) {
                this.layer_id_included_flag[i][j] = this.bitSource.u(1);
            }
        }
        this.vps_timing_info_present_flag = this.bitSource.u(1);
        if (this.vps_timing_info_present_flag != 0) {
            this.vps_num_units_in_tick = this.bitSource.readBitsLong(32);
            this.vps_time_scale = this.bitSource.readBitsLong(32);
            this.vps_poc_proportional_to_timing_flag = this.bitSource.u(1);
            if (this.vps_poc_proportional_to_timing_flag != 0) {
                this.vps_num_ticks_poc_diff_one_minus1 = this.bitSource.ue();
            }
            this.vps_num_hrd_parameters = this.bitSource.ue();
            this.hrd_layer_set_idx = new int[this.vps_num_hrd_parameters];
            this.cprms_present_flag = new int[this.vps_num_hrd_parameters];
            this.hrd_parameters = new H265HrdParameters[this.vps_num_hrd_parameters];
            for (i = 0; i < this.vps_num_hrd_parameters; ++i) {
                this.hrd_layer_set_idx[i] = this.bitSource.ue();
                if (i > 0) {
                    this.cprms_present_flag[i] = this.bitSource.u(1);
                }
                this.hrd_parameters[i] = new H265HrdParameters(this.cprms_present_flag[i], this.vps_max_sub_layers_minus1, this.bitSource);
            }
            this.vps_extension_flag = this.bitSource.u(1);
            if (this.vps_extension_flag != 0) {
                logger.warning("vps_extension_data_flag not implemented");
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        int i;
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Video_parameter_set_rbsp"));
        t.add(new DefaultMutableTreeNode(new KVP("vps_video_parameter_set_id", this.vps_video_parameter_set_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_base_layer_internal_flag", this.vps_base_layer_internal_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_base_layer_available_flag", this.vps_base_layer_available_flag, this.getBaseLayerDescription(this.vps_base_layer_internal_flag, this.vps_base_layer_available_flag))));
        t.add(new DefaultMutableTreeNode(new KVP("vps_max_layers_minus1", this.vps_max_layers_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_max_sub_layers_minus1", this.vps_max_sub_layers_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_temporal_id_nesting_flag", this.vps_temporal_id_nesting_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_reserved_0xffff_16bits", this.vps_reserved_0xffff_16bits, null)));
        t.add(this.profile_tier_level.getJTreeNode(modus));
        t.add(new DefaultMutableTreeNode(new KVP("vps_sub_layer_ordering_info_present_flag", this.vps_sub_layer_ordering_info_present_flag, null)));
        int n = i = this.vps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.vps_max_sub_layers_minus1;
        while (i <= this.vps_max_sub_layers_minus1) {
            t.add(new DefaultMutableTreeNode(new KVP("vps_max_dec_pic_buffering_minus1[" + i + "]", this.vps_max_dec_pic_buffering_minus1[i], null)));
            t.add(new DefaultMutableTreeNode(new KVP("vps_max_num_reorder_pics[" + i + "]", this.vps_max_num_reorder_pics[i], null)));
            t.add(new DefaultMutableTreeNode(new KVP("vps_max_latency_increase_plus1[" + i + "]", this.vps_max_latency_increase_plus1[i], null)));
            ++i;
        }
        t.add(new DefaultMutableTreeNode(new KVP("vps_max_layer_id", this.vps_max_layer_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_num_layer_sets_minus1", this.vps_num_layer_sets_minus1, null)));
        for (i = 1; i <= this.vps_num_layer_sets_minus1; ++i) {
            for (int j = 0; j <= this.vps_max_layer_id; ++j) {
                t.add(new DefaultMutableTreeNode(new KVP("layer_id_included_flag[" + i + "][" + j + "]", this.layer_id_included_flag[i][j], null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("vps_timing_info_present_flag", this.vps_timing_info_present_flag, null)));
        if (this.vps_timing_info_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("vps_num_units_in_tick", this.vps_num_units_in_tick, null)));
            t.add(new DefaultMutableTreeNode(new KVP("vps_time_scale", this.vps_time_scale, VideoHandler.getClockTickString(this.vps_num_units_in_tick, this.vps_time_scale))));
            t.add(new DefaultMutableTreeNode(new KVP("vps_poc_proportional_to_timing_flag", this.vps_poc_proportional_to_timing_flag, null)));
            if (this.vps_poc_proportional_to_timing_flag != 0) {
                t.add(new DefaultMutableTreeNode(new KVP("vps_num_ticks_poc_diff_one_minus1", this.vps_num_ticks_poc_diff_one_minus1, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("vps_num_hrd_parameters", this.vps_num_hrd_parameters, null)));
            for (i = 0; i < this.vps_num_hrd_parameters; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("hrd_layer_set_idx[" + i + "]", this.hrd_layer_set_idx[i], null)));
                if (i > 0) {
                    this.cprms_present_flag[i] = this.bitSource.u(1);
                    t.add(new DefaultMutableTreeNode(new KVP("cprms_present_flag[" + i + "]", this.cprms_present_flag[i], null)));
                }
                t.add(this.hrd_parameters[i].getJTreeNode(modus));
            }
            t.add(new DefaultMutableTreeNode(new KVP("vps_extension_flag", this.vps_extension_flag, null)));
            if (this.vps_extension_flag != 0) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("vps_extension_data_flag")));
                return t;
            }
        }
        return t;
    }

    private String getBaseLayerDescription(int vps_base_layer_internal_flag1, int vps_base_layer_available_flag) {
        if (this.vps_base_layer_internal_flag != 0 && vps_base_layer_available_flag != 0) {
            return "base layer is present in the bitstream";
        }
        if (this.vps_base_layer_internal_flag == 0 && vps_base_layer_available_flag != 0) {
            return "base layer is provided by an external means not specified";
        }
        if (this.vps_base_layer_internal_flag != 0 && vps_base_layer_available_flag == 0) {
            return "base layer is not available (neither present in the bitstream nor provided by external means) but the VPS includes information of the base layer as if it were present in the bitstream";
        }
        if (this.vps_base_layer_internal_flag == 0 && vps_base_layer_available_flag == 0) {
            return "base layer is not available (neither present in the bitstream nor provided by external means) but the VPS includes information of the base layer as if it were provided by an external means";
        }
        return null;
    }
}

