/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.H266NALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.H266NALUnitType;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Video266PESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.H26xHandler;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class H266Handler
extends H26xHandler<Video266PESDataField, H266NALUnit>
implements ImageSource {
    private static final int MAX_NAL_TYPES = 32;
    private static final EnumSet<H266NALUnitType> startElementsOfAU = EnumSet.of(H266NALUnitType.AUD_NUT, new H266NALUnitType[]{H266NALUnitType.OPI_NUT, H266NALUnitType.DCI_NUT, H266NALUnitType.VPS_NUT, H266NALUnitType.SPS_NUT, H266NALUnitType.PPS_NUT, H266NALUnitType.PREFIX_APS_NUT, H266NALUnitType.PH_NUT, H266NALUnitType.PREFIX_SEI_NUT, H266NALUnitType.RSV_NVCL_26, H266NALUnitType.UNSPEC_28, H266NALUnitType.UNSPEC_29});

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        this.pesPackets.add(new Video266PESDataField(pesData));
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("H.266 PES Data").addImageSource(this, "Frames"));
        Utils.addListJTree(s, this.pesPackets, modus, "PES Packets");
        this.addCCDataToTree(modus, s);
        return s;
    }

    @Override
    protected Video266PESDataField createH26xPESDataField(PesPacketData pesData) {
        return new Video266PESDataField(pesData);
    }

    @Override
    public BufferedImage getImage() {
        ArrayList<int[]> frameSize = new ArrayList<int[]>();
        ArrayList<ChartLabel> labels = new ArrayList<ChartLabel>();
        int[] accessUnitData = new int[32];
        boolean[] typeUsed = new boolean[32];
        int count = 0;
        H26xHandler.NALUnitIterator nalIter = new H26xHandler.NALUnitIterator(this);
        H266NALUnit unit = (H266NALUnit)nalIter.next();
        while (unit != null) {
            if (startElementsOfAU.contains((Object)unit.getNal_unit_type())) {
                count = H266Handler.drawBarAccessUnit(frameSize, labels, accessUnitData, count);
                accessUnitData = new int[32];
                while (unit != null && startElementsOfAU.contains((Object)unit.getNal_unit_type())) {
                    int n = unit.getNal_unit_type().getType();
                    accessUnitData[n] = accessUnitData[n] + unit.getNumBytesInRBSP();
                    typeUsed[unit.getNal_unit_type().getType()] = true;
                    unit = (H266NALUnit)nalIter.next();
                }
            }
            int n = unit.getNal_unit_type().getType();
            accessUnitData[n] = accessUnitData[n] + unit.getNumBytesInRBSP();
            typeUsed[unit.getNal_unit_type().getType()] = true;
            unit = (H266NALUnit)nalIter.next();
        }
        H266Handler.drawBarAccessUnit(frameSize, labels, accessUnitData, count);
        DefaultKeyedValues2DDataset dataset = new DefaultKeyedValues2DDataset();
        for (int i = 0; i < 32; ++i) {
            H266NALUnitType nalType = H266NALUnitType.getByType(i);
            if (nalType == null || !typeUsed[i]) continue;
            String typeName = nalType.name();
            Iterator frameSizeIter = frameSize.iterator();
            for (ChartLabel l : labels) {
                if (!frameSizeIter.hasNext()) continue;
                int[] v = (int[])frameSizeIter.next();
                dataset.setValue((double)v[i], (Comparable)((Object)typeName), (Comparable)l);
            }
        }
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(false);
        renderer.setItemMargin(0.0);
        CategoryAxis categoryAxis = new CategoryAxis("time");
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        NumberAxis valueAxis = new NumberAxis("frame size (bytes)");
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        String title = String.valueOf(this.getPID().getLabelMaker()) + " (Access Units, Transmission Order)";
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        return chart.createBufferedImage(frameSize.size() * 18 + 100, 640);
    }
}

