/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.H266NALUnitType;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractNALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;

public class H266NALUnit
extends AbstractNALUnit {
    private static final Logger logger = Logger.getLogger(H266NALUnit.class.getName());
    private final int forbidden_zero_bit;
    private final int nuh_reserved_zero_bit;
    private final H266NALUnitType nal_unit_type;
    private final int nuh_layer_id;
    private final int nuh_temporal_id_plus1;

    public H266NALUnit(byte[] bytes, int offset, int len) {
        super(bytes, offset, len);
        this.forbidden_zero_bit = this.bs.f(1);
        this.nuh_reserved_zero_bit = this.bs.u(1);
        this.nuh_layer_id = this.bs.u(6);
        this.nal_unit_type = H266NALUnitType.getByType(this.bs.u(5));
        this.nuh_temporal_id_plus1 = this.bs.u(3);
        this.readRBSPBytes();
        this.createRBSP();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("NALUnit (" + String.valueOf((Object)this.nal_unit_type) + ")"));
        t.add(new DefaultMutableTreeNode(new KVP("bytes", this.bytes, this.offset, this.numBytesInNALunit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("numBytesInNALunit", this.numBytesInNALunit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("forbidden_zero_bit", this.forbidden_zero_bit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nuh_reserved_zero_bit", this.nuh_reserved_zero_bit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nuh_layer_id", this.nuh_layer_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nal_unit_type", this.nal_unit_type.getType(), this.nal_unit_type.getDescription())));
        t.add(new DefaultMutableTreeNode(new KVP("nuh_temporal_id_plus1", this.nuh_temporal_id_plus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("rbsp_byte", this.rbsp_byte, 0, this.numBytesInRBSP, null)));
        t.add(new DefaultMutableTreeNode(new KVP("NumBytesInRBSP", this.numBytesInRBSP, null)));
        if (this.rbsp != null) {
            t.add(this.rbsp.getJTreeNode(modus));
        }
        return t;
    }

    public int getForbidden_zero_bit() {
        return this.forbidden_zero_bit;
    }

    public int getNuh_layer_id() {
        return this.nuh_layer_id;
    }

    public int getNuh_temporal_id_plus1() {
        return this.nuh_temporal_id_plus1;
    }

    @Override
    public String getNALUnitTypeString(int nal_unit_type) {
        return H266NALUnitType.getByType(nal_unit_type).getDescription();
    }

    @Override
    protected void createRBSP() {
        Class<? extends RBSP> rbspClass = this.nal_unit_type.getClazz();
        if (rbspClass != null) {
            try {
                Constructor<? extends RBSP> constr = rbspClass.getDeclaredConstructor(byte[].class, Integer.TYPE);
                this.rbsp = constr.newInstance(this.rbsp_byte, this.numBytesInRBSP);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            logger.info("unimplemented nal_unit_type:" + this.nal_unit_type.getType() + ", " + this.nal_unit_type.getDescription());
        }
    }

    public int getNuh_reserved_zero_bit() {
        return this.nuh_reserved_zero_bit;
    }

    public H266NALUnitType getNal_unit_type() {
        return this.nal_unit_type;
    }
}

