/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import java.util.HashMap;
import java.util.Map;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Adaptation_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Decoding_capability_information_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Operating_point_information_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Pic_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Picture_header_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Seq_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Slice_layer_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.Video_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Sei_rbsp;

public enum H266NALUnitType {
    TRAIL_NUT(0, "Coded slice of a trailing picture or subpicture", Slice_layer_rbsp.class),
    STSA_NUT(1, "Coded slice of an STSA picture or subpicture", Slice_layer_rbsp.class),
    RADL_NUT(2, "Coded slice of a RADL picture or subpicture", Slice_layer_rbsp.class),
    RASL_NUT(3, "Coded slice of a RASL picture or subpicture", Slice_layer_rbsp.class),
    RSV_VCL_4(4, "Reserved non-IRAP VCL NAL unit types", null),
    RSV_VCL_5(5, "Reserved non-IRAP VCL NAL unit types", null),
    RSV_VCL_6(6, "Reserved non-IRAP VCL NAL unit types", null),
    IDR_W_RADL(7, "Coded slice of an IDR picture or subpicture", Slice_layer_rbsp.class),
    IDR_N_LP(8, "Coded slice of an IDR picture or subpicture", Slice_layer_rbsp.class),
    CRA_NUT(9, "Coded slice of a CRA picture or subpicture", Slice_layer_rbsp.class),
    GDR_NUT(10, "Coded slice of a GDR picture or subpicture", Slice_layer_rbsp.class),
    RSV_IRAP_11(11, "Reserved IRAP VCL NAL unit type", null),
    OPI_NUT(12, "Operating point information", Operating_point_information_rbsp.class),
    DCI_NUT(13, "Decoding capability information", Decoding_capability_information_rbsp.class),
    VPS_NUT(14, "Video parameter set", Video_parameter_set_rbsp.class),
    SPS_NUT(15, "Sequence parameter set", Seq_parameter_set_rbsp.class),
    PPS_NUT(16, "Picture parameter set", Pic_parameter_set_rbsp.class),
    PREFIX_APS_NUT(17, "Adaptation parameter set", Adaptation_parameter_set_rbsp.class),
    SUFFIX_APS_NUT(18, "Adaptation parameter set", Adaptation_parameter_set_rbsp.class),
    PH_NUT(19, "Picture header", Picture_header_rbsp.class),
    AUD_NUT(20, "AU delimiter", null),
    EOS_NUT(21, "End of sequence", null),
    EOB_NUT(22, "End of bitstream", null),
    PREFIX_SEI_NUT(23, "Supplemental enhancement information", Sei_rbsp.class),
    SUFFIX_SEI_NUT(24, "Supplemental enhancement information", Sei_rbsp.class),
    FD_NUT(25, "Filler data", null),
    RSV_NVCL_26(26, "Reserved non-VCL NAL unit types", null),
    RSV_NVCL_27(27, "Reserved non-VCL NAL unit types", null),
    UNSPEC_28(28, "Unspecified non-VCL NAL unit types", null),
    UNSPEC_29(29, "Unspecified non-VCL NAL unit types", null),
    UNSPEC_30(30, "Unspecified non-VCL NAL unit types", null),
    UNSPEC_31(31, "Unspecified non-VCL NAL unit types", null);

    private int type;
    private String description;
    Class<? extends RBSP> clazz;
    private static Map<Integer, H266NALUnitType> enumMap;

    private H266NALUnitType(int type, String description, Class<? extends RBSP> class1) {
        this.type = type;
        this.description = description;
        this.clazz = class1;
    }

    public static String getDescription(int type) {
        H266NALUnitType byType = H266NALUnitType.getByType(type);
        if (byType != null) {
            return byType.getDescription();
        }
        return "unknown";
    }

    public static H266NALUnitType getByType(int type) {
        return enumMap.get(type);
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends RBSP> getClazz() {
        return this.clazz;
    }

    static {
        enumMap = new HashMap<Integer, H266NALUnitType>();
        for (H266NALUnitType e : H266NALUnitType.values()) {
            if (enumMap.put(e.getType(), e) == null) continue;
            throw new IllegalArgumentException("duplicate id: " + e.getType());
        }
    }
}

