/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.GeneralConstraintsInfo;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class ProfileTierLevel
implements TreeNode {
    public static final LookUpList general_profile_idc_list = new LookUpList.Builder().add(1, "Main 10 profile").add(2, "Main 12 profile").add(10, "Main 12 Intra profile").add(17, "Multilayer Main 10 pr").add(33, "Main 10 4:4:4 profile").add(34, "Main 12 4:4:4 profile").add(35, "Main 16 4:4:4 profile").add(42, "Main 12 4:4:4 Intra profile").add(43, "Main 16 4:4:4 Intra profile").add(49, "Multilayer Main 10 4:4:4 profile").add(65, "Main 10 Still Picture profile").add(66, "Main 12 Still Picture profile").add(97, "Main 10 4:4:4 Still Picture profile").add(98, "Main 12 4:4:4 Still Picture profile").add(99, "Main 16 4:4:4 Still Picture profile").build();
    final int profileTierPresentFlag;
    private final int max_num_sub_layers_minus1;
    private int general_profile_idc;
    private int general_tier_flag;
    private int general_level_idc;
    private int ptl_frame_only_constraint_flag;
    private int ptl_multilayer_enabled_flag;
    private GeneralConstraintsInfo general_constraints_info;
    private int[] ptl_sublayer_level_present_flag;
    private int[] sublayer_level_idc;
    private int ptl_num_sub_profiles;
    private int[] general_sub_profile_idc;

    public ProfileTierLevel(int profileTierPresentFlag, int max_num_sub_layers_minus1, BitSource bitSource) {
        int i;
        this.profileTierPresentFlag = profileTierPresentFlag;
        this.max_num_sub_layers_minus1 = max_num_sub_layers_minus1;
        this.ptl_sublayer_level_present_flag = new int[max_num_sub_layers_minus1];
        this.sublayer_level_idc = new int[max_num_sub_layers_minus1];
        if (profileTierPresentFlag == 1) {
            this.general_profile_idc = bitSource.u(7);
            this.general_tier_flag = bitSource.u(1);
        }
        this.general_level_idc = bitSource.u(8);
        this.ptl_frame_only_constraint_flag = bitSource.u(1);
        this.ptl_multilayer_enabled_flag = bitSource.u(1);
        if (profileTierPresentFlag == 1) {
            this.general_constraints_info = new GeneralConstraintsInfo(bitSource);
        }
        for (i = max_num_sub_layers_minus1 - 1; i >= 0; --i) {
            this.ptl_sublayer_level_present_flag[i] = bitSource.u(1);
        }
        bitSource.skiptoByteBoundary();
        for (i = max_num_sub_layers_minus1 - 1; i >= 0; --i) {
            if (this.ptl_sublayer_level_present_flag[i] != 1) continue;
            this.sublayer_level_idc[i] = bitSource.u(8);
        }
        if (profileTierPresentFlag == 1) {
            this.ptl_num_sub_profiles = bitSource.u(8);
            this.general_sub_profile_idc = new int[this.ptl_num_sub_profiles];
            for (i = 0; i < this.ptl_num_sub_profiles; ++i) {
                this.general_sub_profile_idc[i] = bitSource.u(32);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        int i;
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Profile_tier_level(profileTierPresentFlag=" + this.profileTierPresentFlag + ", max_num_sub_layers_minus1=" + this.max_num_sub_layers_minus1 + ")"));
        if (this.profileTierPresentFlag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("general_profile_idc", this.general_profile_idc, general_profile_idc_list.get(this.general_profile_idc, "unknown/reserved"))));
            t.add(new DefaultMutableTreeNode(new KVP("general_tier_flag", this.general_tier_flag, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("general_level_idc", this.general_level_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("ptl_frame_only_constraint_flag", this.ptl_frame_only_constraint_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("ptl_multilayer_enabled_flag", this.ptl_multilayer_enabled_flag, null)));
        if (this.profileTierPresentFlag == 1) {
            t.add(this.general_constraints_info.getJTreeNode(modus));
        }
        for (i = this.max_num_sub_layers_minus1 - 1; i >= 0; --i) {
            t.add(new DefaultMutableTreeNode(new KVP("ptl_sublayer_level_present_flag[" + i + "]", this.ptl_sublayer_level_present_flag[i], null)));
        }
        for (i = this.max_num_sub_layers_minus1 - 1; i >= 0; --i) {
            if (this.ptl_sublayer_level_present_flag[i] != 1) continue;
            t.add(new DefaultMutableTreeNode(new KVP("sublayer_level_idc[" + i + "]", this.sublayer_level_idc[i], null)));
        }
        if (this.profileTierPresentFlag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("ptl_num_sub_profiles", this.ptl_num_sub_profiles, null)));
            for (i = 0; i < this.ptl_num_sub_profiles; ++i) {
                t.add(new DefaultMutableTreeNode(new KVP("general_sub_profile_idc[" + i + "]", this.general_sub_profile_idc[i], null)));
            }
        }
        return t;
    }
}

