/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class VUIParameters
implements TreeNode {
    private static final LookUpList colour_primaries_list = new LookUpList.Builder().add(0, "Reserved").add(1, "BT.709-6").add(2, "Unspecified").add(3, "Reserved").add(4, "BT.470-6 System M (historical)").add(5, "BT.601-7 625").add(6, "BT.601-7 525").add(7, "SMPTE ST 240").add(8, "Generic film").add(9, "BT.2020-2").add(10, "SMPTE ST 428-1").add(11, "SMPTE RP 431-2").add(12, "SMPTE EG 432-1").add(13, 21, "Reserved").add(22, "No corresponding industry specification identified").add(23, 255, "Reserved").build();
    private int payloadSize;
    private int vui_progressive_source_flag;
    private int vui_interlaced_source_flag;
    private int vui_non_packed_constraint_flag;
    private int vui_non_projected_constraint_flag;
    private int vui_aspect_ratio_info_present_flag;
    private int vui_aspect_ratio_constant_flag;
    private int vui_aspect_ratio_idc;
    private int vui_sar_width;
    private int vui_sar_height;
    private int vui_overscan_info_present_flag;
    private int vui_overscan_appropriate_flag;
    private int vui_colour_description_present_flag;
    private int vui_colour_primaries;
    private int vui_transfer_characteristics;
    private int vui_matrix_coeffs;
    private int vui_full_range_flag;
    private int vui_chroma_loc_info_present_flag;
    private int vui_chroma_sample_loc_type_frame;
    private int vui_chroma_sample_loc_type_top_field;
    private int vui_chroma_sample_loc_type_bottom_field;

    public VUIParameters(int payloadSize, BitSource bitSource) {
        this.payloadSize = payloadSize;
        this.vui_progressive_source_flag = bitSource.u(1);
        this.vui_interlaced_source_flag = bitSource.u(1);
        this.vui_non_packed_constraint_flag = bitSource.u(1);
        this.vui_non_projected_constraint_flag = bitSource.u(1);
        this.vui_aspect_ratio_info_present_flag = bitSource.u(1);
        if (this.vui_aspect_ratio_info_present_flag != 0) {
            this.vui_aspect_ratio_constant_flag = bitSource.u(1);
            this.vui_aspect_ratio_idc = bitSource.u(8);
            if (this.vui_aspect_ratio_idc == 255) {
                this.vui_sar_width = bitSource.u(16);
                this.vui_sar_height = bitSource.u(16);
            }
        }
        this.vui_overscan_info_present_flag = bitSource.u(1);
        if (this.vui_overscan_info_present_flag != 0) {
            this.vui_overscan_appropriate_flag = bitSource.u(1);
        }
        this.vui_colour_description_present_flag = bitSource.u(1);
        if (this.vui_colour_description_present_flag != 0) {
            this.vui_colour_primaries = bitSource.u(8);
            this.vui_transfer_characteristics = bitSource.u(8);
            this.vui_matrix_coeffs = bitSource.u(8);
            this.vui_full_range_flag = bitSource.u(1);
        }
        this.vui_chroma_loc_info_present_flag = bitSource.u(1);
        if (this.vui_chroma_loc_info_present_flag != 0) {
            if (this.vui_progressive_source_flag != 0 && this.vui_interlaced_source_flag == 0) {
                this.vui_chroma_sample_loc_type_frame = bitSource.ue();
            } else {
                this.vui_chroma_sample_loc_type_top_field = bitSource.ue();
                this.vui_chroma_sample_loc_type_bottom_field = bitSource.ue();
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("vui_parameters(payloadSize:" + this.payloadSize + ")"));
        t.add(new DefaultMutableTreeNode(new KVP("vui_progressive_source_flag", this.vui_progressive_source_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vui_interlaced_source_flag", this.vui_interlaced_source_flag, VUIParameters.getSourceFlagsDescription(this.vui_progressive_source_flag, this.vui_interlaced_source_flag))));
        t.add(new DefaultMutableTreeNode(new KVP("vui_non_packed_constraint_flag", this.vui_non_packed_constraint_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vui_non_projected_constraint_flag", this.vui_non_projected_constraint_flag, null)));
        DefaultMutableTreeNode vui_aspect_ratio_info_present_flag_node = new DefaultMutableTreeNode(new KVP("vui_aspect_ratio_info_present_flag", this.vui_aspect_ratio_info_present_flag, null));
        t.add(vui_aspect_ratio_info_present_flag_node);
        if (this.vui_aspect_ratio_info_present_flag != 0) {
            vui_aspect_ratio_info_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_aspect_ratio_constant_flag", this.vui_aspect_ratio_constant_flag, null)));
            DefaultMutableTreeNode vui_aspect_ratio_idcNode = new DefaultMutableTreeNode(new KVP("vui_aspect_ratio_idc", this.vui_aspect_ratio_idc, null));
            vui_aspect_ratio_info_present_flag_node.add(vui_aspect_ratio_idcNode);
            if (this.vui_aspect_ratio_idc == 255) {
                vui_aspect_ratio_idcNode.add(new DefaultMutableTreeNode(new KVP("vui_sar_width", this.vui_sar_width, null)));
                vui_aspect_ratio_idcNode.add(new DefaultMutableTreeNode(new KVP("vui_sar_height", this.vui_sar_height, null)));
            }
        }
        DefaultMutableTreeNode vui_overscan_info_present_flag_node = new DefaultMutableTreeNode(new KVP("vui_overscan_info_present_flag", this.vui_overscan_info_present_flag, null));
        t.add(vui_overscan_info_present_flag_node);
        if (this.vui_overscan_info_present_flag != 0) {
            vui_overscan_info_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_overscan_appropriate_flag", this.vui_overscan_appropriate_flag, null)));
        }
        DefaultMutableTreeNode vui_colour_description_present_flag_node = new DefaultMutableTreeNode(new KVP("vui_colour_description_present_flag", this.vui_colour_description_present_flag, null));
        t.add(vui_colour_description_present_flag_node);
        if (this.vui_colour_description_present_flag != 0) {
            vui_colour_description_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_colour_primaries", this.vui_colour_primaries, colour_primaries_list.get(this.vui_colour_primaries))));
            vui_colour_description_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_transfer_characteristics", this.vui_transfer_characteristics, null)));
            vui_colour_description_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_matrix_coeffs", this.vui_matrix_coeffs, null)));
            vui_colour_description_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_full_range_flag", this.vui_full_range_flag, null)));
        }
        DefaultMutableTreeNode vui_chroma_loc_info_present_flag_node = new DefaultMutableTreeNode(new KVP("vui_chroma_loc_info_present_flag", this.vui_chroma_loc_info_present_flag, null));
        t.add(vui_chroma_loc_info_present_flag_node);
        if (this.vui_chroma_loc_info_present_flag != 0) {
            if (this.vui_progressive_source_flag != 0 && this.vui_interlaced_source_flag == 0) {
                vui_chroma_loc_info_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_chroma_sample_loc_type_frame", this.vui_chroma_sample_loc_type_frame, null)));
            } else {
                vui_chroma_loc_info_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_chroma_sample_loc_type_top_field", this.vui_chroma_sample_loc_type_top_field, null)));
                vui_chroma_loc_info_present_flag_node.add(new DefaultMutableTreeNode(new KVP("vui_chroma_sample_loc_type_bottom_field", this.vui_chroma_sample_loc_type_bottom_field, null)));
            }
        }
        return t;
    }

    private static String getSourceFlagsDescription(int vui_progressive_source_flag, int vui_interlaced_source_flag) {
        if (vui_progressive_source_flag == 1 && vui_interlaced_source_flag == 0) {
            return "source scan type progressive only";
        }
        if (vui_progressive_source_flag == 0 && vui_interlaced_source_flag == 1) {
            return "source scan type interlaced only";
        }
        if (vui_progressive_source_flag == 0 && vui_interlaced_source_flag == 0) {
            return "source scan type unknown or unspecified";
        }
        return "source scan type of each picture is indicated at the picture level using the syntax element ffi_source_scan_type in a frame-field information SEI message";
    }
}

