/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x;

import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.util.BitSource;

public abstract class AbstractNALUnit
implements TreeNode {
    protected static final Logger logger = Logger.getLogger(AbstractNALUnit.class.getName());
    protected final byte[] bytes;
    protected final int offset;
    protected final int numBytesInNALunit;
    protected BitSource bs;
    protected final byte[] rbsp_byte;
    protected int numBytesInRBSP = 0;
    protected RBSP rbsp = null;

    public abstract String getNALUnitTypeString(int var1);

    protected abstract void createRBSP();

    public AbstractNALUnit(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.offset = offset;
        this.numBytesInNALunit = len;
        this.rbsp_byte = new byte[len];
        this.bs = new BitSource(bytes, offset);
    }

    protected void readRBSPBytes() {
        this.numBytesInRBSP = 0;
        for (int i = 1; i < this.numBytesInNALunit; ++i) {
            if (i + 2 < this.numBytesInNALunit && this.bs.nextBits(24) == 3) {
                this.rbsp_byte[this.numBytesInRBSP++] = this.bs.readSignedByte(8);
                this.rbsp_byte[this.numBytesInRBSP++] = this.bs.readSignedByte(8);
                i += 2;
                this.bs.readSignedByte(8);
                continue;
            }
            this.rbsp_byte[this.numBytesInRBSP++] = this.bs.readSignedByte(8);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getNumBytesInNALunit() {
        return this.numBytesInNALunit;
    }

    public byte[] getRbsp_byte() {
        return this.rbsp_byte;
    }

    public int getNumBytesInRBSP() {
        return this.numBytesInRBSP;
    }

    public RBSP getRbsp() {
        return this.rbsp;
    }

    public static Logger getLogger() {
        return logger;
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSource getBs() {
        return this.bs;
    }
}

