/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.util.BitSource;

public class AbstractVuiParamters {
    protected int aspect_ratio_info_present_flag;
    protected int aspect_ratio_idc;
    protected int sar_width;
    protected int sar_height;
    protected int overscan_info_present_flag;
    protected int overscan_appropriate_flag;
    protected int video_signal_type_present_flag;
    protected int video_format;
    protected int video_full_range_flag;
    protected int colour_description_present_flag;
    protected int colour_primaries;
    protected int transfer_characteristics;
    protected int matrix_coefficients;
    protected int chroma_loc_info_present_flag;
    protected int chroma_sample_loc_type_top_field;
    protected int chroma_sample_loc_type_bottom_field;

    public AbstractVuiParamters(BitSource bitSource) {
        this.aspect_ratio_info_present_flag = bitSource.u(1);
        if (this.aspect_ratio_info_present_flag != 0) {
            this.aspect_ratio_idc = bitSource.u(8);
            if (this.aspect_ratio_idc == 255) {
                this.sar_width = bitSource.u(16);
                this.sar_height = bitSource.u(16);
            }
        }
        this.overscan_info_present_flag = bitSource.u(1);
        if (this.overscan_info_present_flag != 0) {
            this.overscan_appropriate_flag = bitSource.u(1);
        }
        this.video_signal_type_present_flag = bitSource.u(1);
        if (this.video_signal_type_present_flag != 0) {
            this.video_format = bitSource.u(3);
            this.video_full_range_flag = bitSource.u(1);
            this.colour_description_present_flag = bitSource.u(1);
            if (this.colour_description_present_flag != 0) {
                this.colour_primaries = bitSource.u(8);
                this.transfer_characteristics = bitSource.u(8);
                this.matrix_coefficients = bitSource.u(8);
            }
        }
        this.chroma_loc_info_present_flag = bitSource.u(1);
        if (this.chroma_loc_info_present_flag != 0) {
            this.chroma_sample_loc_type_top_field = bitSource.ue();
            this.chroma_sample_loc_type_bottom_field = bitSource.ue();
        }
    }

    public int getAspect_ratio_info_present_flag() {
        return this.aspect_ratio_info_present_flag;
    }

    public int getAspect_ratio_idc() {
        return this.aspect_ratio_idc;
    }

    public int getSar_width() {
        return this.sar_width;
    }

    public int getSar_height() {
        return this.sar_height;
    }

    public int getOverscan_info_present_flag() {
        return this.overscan_info_present_flag;
    }

    public int getOverscan_appropriate_flag() {
        return this.overscan_appropriate_flag;
    }

    public int getVideo_signal_type_present_flag() {
        return this.video_signal_type_present_flag;
    }

    public int getVideo_format() {
        return this.video_format;
    }

    public int getVideo_full_range_flag() {
        return this.video_full_range_flag;
    }

    public int getColour_description_present_flag() {
        return this.colour_description_present_flag;
    }

    public int getColour_primaries() {
        return this.colour_primaries;
    }

    public int getTransfer_characteristics() {
        return this.transfer_characteristics;
    }

    public int getMatrix_coefficients() {
        return this.matrix_coefficients;
    }

    public int getChroma_loc_info_present_flag() {
        return this.chroma_loc_info_present_flag;
    }

    public int getChroma_sample_loc_type_top_field() {
        return this.chroma_sample_loc_type_top_field;
    }

    public int getChroma_sample_loc_type_bottom_field() {
        return this.chroma_sample_loc_type_bottom_field;
    }

    protected void addCommonFields(DefaultMutableTreeNode t) {
        t.add(new DefaultMutableTreeNode(new KVP("aspect_ratio_info_present_flag", this.aspect_ratio_info_present_flag, null)));
        if (this.aspect_ratio_info_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("aspect_ratio_idc", this.aspect_ratio_idc, AbstractVuiParamters.getAspectRationIdcString(this.aspect_ratio_idc))));
            if (this.aspect_ratio_idc == 255) {
                t.add(new DefaultMutableTreeNode(new KVP("sar_width", this.sar_width, null)));
                t.add(new DefaultMutableTreeNode(new KVP("sar_height", this.sar_height, null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("overscan_info_present_flag", this.overscan_info_present_flag, null)));
        if (this.overscan_info_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("overscan_appropriate_flag", this.overscan_appropriate_flag, this.overscan_appropriate_flag == 1 ? "suitable for display using overscan" : "output should not be displayed using overscan")));
        }
        t.add(new DefaultMutableTreeNode(new KVP("video_signal_type_present_flag", this.video_signal_type_present_flag, null)));
        if (this.video_signal_type_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("video_format", this.video_format, AbstractVuiParamters.getVideoFormatString(this.video_format))));
            t.add(new DefaultMutableTreeNode(new KVP("video_full_range_flag", this.video_full_range_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("colour_description_present_flag", this.colour_description_present_flag, null)));
            if (this.colour_description_present_flag != 0) {
                t.add(new DefaultMutableTreeNode(new KVP("colour_primaries", this.colour_primaries, null)));
                t.add(new DefaultMutableTreeNode(new KVP("transfer_characteristics", this.transfer_characteristics, null)));
                t.add(new DefaultMutableTreeNode(new KVP("matrix_coefficients", this.matrix_coefficients, null)));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("chroma_loc_info_present_flag", this.chroma_loc_info_present_flag, null)));
        if (this.chroma_loc_info_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("chroma_sample_loc_type_top_field", this.chroma_sample_loc_type_top_field, null)));
            t.add(new DefaultMutableTreeNode(new KVP("chroma_sample_loc_type_bottom_field", this.chroma_sample_loc_type_bottom_field, null)));
        }
    }

    public static String getAspectRationIdcString(int aspect_ratio_idc) {
        switch (aspect_ratio_idc) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "1:1 (square)";
            }
            case 2: {
                return "12:11";
            }
            case 3: {
                return "10:11";
            }
            case 4: {
                return "16:11";
            }
            case 5: {
                return "40:33";
            }
            case 6: {
                return "24:11";
            }
            case 7: {
                return "20:11";
            }
            case 8: {
                return "32:11";
            }
            case 9: {
                return "80:33";
            }
            case 10: {
                return "18:11";
            }
            case 11: {
                return "15:11";
            }
            case 12: {
                return "64:33";
            }
            case 13: {
                return "160:99";
            }
            case 14: {
                return "4:3";
            }
            case 15: {
                return "3:2";
            }
            case 16: {
                return "2:1";
            }
            case 255: {
                return "Extended_SAR";
            }
        }
        return "reserved";
    }

    public static String getVideoFormatString(int video_format) {
        switch (video_format) {
            case 0: {
                return "Component";
            }
            case 1: {
                return "PAL";
            }
            case 2: {
                return "NTSC";
            }
            case 3: {
                return "SECAM";
            }
            case 4: {
                return "MAC";
            }
            case 5: {
                return "Unspecified video format";
            }
        }
        return "reserved";
    }
}

