/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.AuxiliaryData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.VideoHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractNALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.H26xPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Sei_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.Sei_message;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.UserDataRegisteredItuT35Sei_message;

public abstract class H26xHandler<P extends H26xPESDataField<?>, N extends AbstractNALUnit>
extends VideoHandler {
    private static final Logger logger = Logger.getLogger(H26xHandler.class.getName());

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        this.pesPackets.add(this.createH26xPESDataField(pesData));
    }

    @Override
    protected void collectCEA708Data() {
        for (PesPacketData pesPacket : this.pesPackets) {
            H26xPESDataField h26xPesPacket = (H26xPESDataField)pesPacket;
            if (h26xPesPacket.hasPTS()) {
                long pts = h26xPesPacket.getPts();
                for (AbstractNALUnit nalUnit : h26xPesPacket.getNalUnits()) {
                    RBSP rbsp = nalUnit.getRbsp();
                    if (!(rbsp instanceof Sei_rbsp)) continue;
                    List<Sei_message> messages = ((Sei_rbsp)rbsp).getSei_messages();
                    for (Sei_message message : messages) {
                        UserDataRegisteredItuT35Sei_message userDataRegisteredItuT35Sei_message;
                        if (message.getPayloadType() != 4 || !(message instanceof UserDataRegisteredItuT35Sei_message) || (userDataRegisteredItuT35Sei_message = (UserDataRegisteredItuT35Sei_message)message).getItu_t_t35_country_code() != 181 || userDataRegisteredItuT35Sei_message.getItu_t_t35_provider_code() != 49) continue;
                        AuxiliaryData auxData = userDataRegisteredItuT35Sei_message.getAuxData();
                        this.find708AuxData(pts, auxData);
                    }
                }
                continue;
            }
            logger.warning("no pts for PES Field, ignoring possible cc_data");
        }
    }

    protected abstract P createH26xPESDataField(PesPacketData var1);

    protected static boolean notZero(int[] accessUnitData) {
        for (int i : accessUnitData) {
            if (i == 0) continue;
            return true;
        }
        return false;
    }

    protected static int drawBarAccessUnit(List<int[]> frameSize, List<ChartLabel> labels, int[] accessUnitData, int c) {
        int count = c;
        if (H26xHandler.notZero(accessUnitData)) {
            ChartLabel label = new ChartLabel("" + count, (short)count);
            labels.add(label);
            frameSize.add(accessUnitData);
            ++count;
        }
        return count;
    }

    protected class NALUnitIterator {
        Iterator<PesPacketData> pesIterator = null;
        N nextSection = null;
        private Iterator<? extends N> sectionIter;

        public NALUnitIterator(H26xHandler this$0) {
            this.pesIterator = this$0.pesPackets.iterator();
            this.sectionIter = this.getNextSectionIter();
            if (this.sectionIter != null) {
                this.nextSection = (AbstractNALUnit)this.sectionIter.next();
            }
        }

        private Iterator<N> getNextSectionIter() {
            H26xPESDataField pesPacket;
            Iterator result = null;
            while (((result = (pesPacket = (H26xPESDataField)this.pesIterator.next()).getNalUnits().iterator()) == null || !result.hasNext()) && this.pesIterator.hasNext()) {
            }
            return result;
        }

        public N next() {
            Object result = this.nextSection;
            if (this.sectionIter != null && this.sectionIter.hasNext()) {
                this.nextSection = (AbstractNALUnit)this.sectionIter.next();
            } else if (this.pesIterator.hasNext()) {
                this.sectionIter = this.getNextSectionIter();
                this.nextSection = this.sectionIter.hasNext() ? (AbstractNALUnit)this.sectionIter.next() : null;
            } else {
                this.nextSection = null;
            }
            return result;
        }
    }
}

