/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractNALUnit;
import nl.digitalekabeltelevisie.util.Utils;

public abstract class H26xPESDataField<E extends AbstractNALUnit>
extends PesPacketData {
    private static final Logger logger = Logger.getLogger(H26xPESDataField.class.getName());
    protected List<E> nalUnits = new ArrayList();

    protected abstract E createNALUnitInstance(byte[] var1, int var2, int var3);

    public H26xPESDataField(PesPacketData pesPacket) {
        super(pesPacket);
        int i = this.pesDataStart;
        while (i < this.data.length && i >= 0) {
            if ((i = Utils.indexOf(this.data, new byte[]{0, 0, 1}, i)) < 0) continue;
            int zeroEnd = Utils.indexOf(this.data, new byte[]{0, 0, 0}, i += 3);
            int oneEnd = Utils.indexOf(this.data, new byte[]{0, 0, 1}, i);
            int end = zeroEnd >= 0 ? (oneEnd >= 0 ? Math.min(zeroEnd, oneEnd) : zeroEnd) : (oneEnd >= 0 ? oneEnd : this.pesDataLen);
            if (end <= i) continue;
            try {
                E nalUnit = this.createNALUnitInstance(this.data, i, end - i);
                this.nalUnits.add(nalUnit);
            }
            catch (Exception e) {
                logger.info("Create NALUnit failed: data.length=" + this.data.length + " i=" + i + ", end=" + end + ", exception=" + e.getMessage());
            }
            i = end;
        }
    }

    public List<E> getNalUnits() {
        return this.nalUnits;
    }
}

