/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;

public abstract class RBSP
implements TreeNode {
    protected BitSource bitSource;
    protected byte[] bytes;
    protected int numBytesInRBSP;

    public static String getChroma_format_idcString(int chroma_format_idc) {
        switch (chroma_format_idc) {
            case 0: {
                return "monochrome";
            }
            case 1: {
                return "4:2:0";
            }
            case 2: {
                return "4:2:2";
            }
            case 3: {
                return "4:4:4";
            }
        }
        return "error";
    }

    protected RBSP(byte[] rbsp_bytes, int numBytesInRBSP) {
        this.bitSource = new BitSource(rbsp_bytes, 0, numBytesInRBSP);
        this.bytes = rbsp_bytes;
        this.numBytesInRBSP = numBytesInRBSP;
    }

    public static int scaling_list(int[] deltaScalingList, int sizeOfScalingList, BitSource bitSource) {
        int lastScale = 8;
        int nextScale = 8;
        int no_deltas = 0;
        for (int j = 0; j < sizeOfScalingList; ++j) {
            if (nextScale != 0) {
                int delta_scale = bitSource.se();
                ++no_deltas;
                deltaScalingList[j] = delta_scale;
                nextScale = (lastScale + delta_scale + 256) % 256;
            }
            lastScale = nextScale == 0 ? lastScale : nextScale;
        }
        return no_deltas;
    }

    public static DefaultMutableTreeNode getScalingListJTree(int[] deltaScalingList, int i, int sizeOfScalingList, int deltas_read) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("scaling_list[" + i + "]"));
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < deltas_read; ++j) {
            if (nextScale != 0) {
                nextScale = (lastScale + deltaScalingList[j] + 256) % 256;
                t.add(new DefaultMutableTreeNode(new KVP("delta_scale", deltaScalingList[j], "scaling_list[" + i + "][" + j + "]=" + nextScale)));
            }
            lastScale = nextScale == 0 ? lastScale : nextScale;
        }
        return t;
    }

    public BitSource getBitSource() {
        return this.bitSource;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getNumBytesInRBSP() {
        return this.numBytesInRBSP;
    }
}

