/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Payload;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class DVBT2TimestampPayload
extends Payload {
    private static LookUpList bw_list = new LookUpList.Builder().add(0, "Bandwidth: 1,7 MHz, T2 Elementary period T: 71/131 \u00b5s, subseconds unit, Tsub \u00b5s: 1/131 \u00b5s").add(1, "Bandwidth: 5 MHz, T2 Elementary period T: 7/40 \u00b5s, subseconds unit, Tsub \u00b5s: 1/40 \u00b5s").add(2, "Bandwidth: 6 MHz, T2 Elementary period T: 7/48 \u00b5s, subseconds unit, Tsub \u00b5s: 1/48 \u00b5s").add(3, "Bandwidth: 7 MHz, T2 Elementary period T: 7/56 \u00b5s, subseconds unit, Tsub \u00b5s: 1/56 \u00b5s").add(4, "Bandwidth: 8 MHz, T2 Elementary period T: 7/64 \u00b5s, subseconds unit, Tsub \u00b5s: 1/64 \u00b5s").add(5, "Bandwidth: 10 MHz, T2 Elementary period T: 7/80  \u00b5s, subseconds unit, Tsub \u00b5s: 1/80 \u00b5s").build();

    public DVBT2TimestampPayload(byte[] data) {
        super(data);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode payloadNode = new DefaultMutableTreeNode(new KVP("payload"));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("bw", this.getBW(), DVBT2TimestampPayload.getBWString(this.getBW()))));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("seconds_since_2000", this.getSecondsSince2000(), null)));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("subseconds", this.getSubSeconds(), null)));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("utco", this.getUtco(), null)));
        return payloadNode;
    }

    public int getBW() {
        return Byte.toUnsignedInt(this.data[6]) & 0xF;
    }

    public static String getBWString(int bw) {
        return bw_list.get(bw);
    }

    public long getSecondsSince2000() {
        return Utils.getLong(this.data, 7, 5, 0xFFFFFFFFFFL);
    }

    public long getSubSeconds() {
        return Utils.getLong(this.data, 12, 4, -1L) >> 3;
    }

    public int getUtco() {
        return Utils.getInt(this.data, 15, 2, 8191);
    }
}

