/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Configurable1PostSignalling;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class DynamicL1PostSignalling
implements TreeNode {
    private int frame_idx;
    private int sub_slice_interval;
    private int type_2_start;
    private int l1_change_counter;
    private int start_rf_idx;
    private int reserved_1;
    private List<PLP> plpList = new ArrayList<PLP>();
    private int reserved_3;
    private List<AuxPrivateDyn> aux_private_dynList = new ArrayList<AuxPrivateDyn>();

    public DynamicL1PostSignalling(BitSource bs, Configurable1PostSignalling configurable1PostSignalling) {
        int i;
        this.frame_idx = bs.readBits(8);
        this.sub_slice_interval = bs.readBits(22);
        this.type_2_start = bs.readBits(22);
        this.l1_change_counter = bs.readBits(8);
        this.start_rf_idx = bs.readBits(3);
        this.reserved_1 = bs.readBits(8);
        for (i = 0; i < configurable1PostSignalling.getNum_plp(); ++i) {
            this.plpList.add(new PLP(this, bs));
        }
        this.reserved_3 = bs.readBits(8);
        for (i = 0; i < configurable1PostSignalling.getNum_aux(); ++i) {
            this.aux_private_dynList.add(new AuxPrivateDyn(this, bs));
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Dynamic L1-post signalling"));
        t.add(new DefaultMutableTreeNode(new KVP("frame_idx", this.frame_idx, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sub_slice_interval", this.sub_slice_interval, null)));
        t.add(new DefaultMutableTreeNode(new KVP("type_2_start", this.type_2_start, null)));
        t.add(new DefaultMutableTreeNode(new KVP("l1_change_counter", this.l1_change_counter, null)));
        t.add(new DefaultMutableTreeNode(new KVP("start_rf_idx", this.start_rf_idx, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_1", this.reserved_1, null)));
        Utils.addListJTree(t, this.plpList, modus, "PLPs");
        t.add(new DefaultMutableTreeNode(new KVP("reserved_3", this.reserved_3, null)));
        Utils.addListJTree(t, this.aux_private_dynList, modus, "AUX_PRIVATE_DYNs");
        return t;
    }

    public class PLP
    implements TreeNode {
        private int plp_id;
        private int plp_start;
        private int plp_num_blocks;
        private int reserved_2;

        public PLP(DynamicL1PostSignalling this$0, BitSource bs) {
            this.plp_id = bs.readBits(8);
            this.plp_start = bs.readBits(22);
            this.plp_num_blocks = bs.readBits(10);
            this.reserved_2 = bs.readBits(8);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("PLP"));
            t.add(new DefaultMutableTreeNode(new KVP("plp_id", this.plp_id, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_start", this.plp_start, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_num_blocks", this.plp_num_blocks, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved_2", this.reserved_2, null)));
            return t;
        }
    }

    public class AuxPrivateDyn
    implements TreeNode {
        private long aux_private_dyn;

        public AuxPrivateDyn(DynamicL1PostSignalling this$0, BitSource bs) {
            this.aux_private_dyn = bs.readBitsLong(48);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("aux_private_dyn", this.aux_private_dyn, null));
            return t;
        }
    }
}

