/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Configurable1PostSignalling;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.DynamicL1PostSignalling;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.L1PreSignallingData;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Payload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.T2miPacket;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class L1CurrentT2MIPacketsPayload
extends Payload {
    private static LookUpList freq_source_list = new LookUpList.Builder().add(0, "the FREQUENCY field(s) of the DVB-T2 signal shall be according to the signalled value(s) in the L1-current data field of the T2-MI signal ").add(1, "the FREQUENCY field(s) of the DVB-T2 signal shall be according to the T2-MI frequency individual addressing function ").add(2, " the FREQUENCY field(s) of the DVB-T2 signal shall be according to the manually set value(s) for each modulator. ").add(3, "reserved for future use").build();
    private L1PreSignallingData l1PreSignallingData;
    private int l1ConfLen;
    private Configurable1PostSignalling configurable1PostSignalling;
    private int l1DynCurrLen;
    private DynamicL1PostSignalling dynamicL1PostSignalling;
    private int l1ExtLen;

    public L1CurrentT2MIPacketsPayload(byte[] data) {
        super(data);
        BitSource bs = new BitSource(data, 8, data.length - 4);
        this.l1PreSignallingData = new L1PreSignallingData(bs);
        this.l1ConfLen = bs.readBits(16);
        this.configurable1PostSignalling = new Configurable1PostSignalling(bs, this.l1PreSignallingData);
        bs.skiptoByteBoundary();
        this.l1DynCurrLen = bs.readBits(16);
        this.dynamicL1PostSignalling = new DynamicL1PostSignalling(bs, this.configurable1PostSignalling);
        bs.skiptoByteBoundary();
        this.l1ExtLen = bs.readBits(16);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode payloadNode = new DefaultMutableTreeNode(new KVP("payload"));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("frame_idx", this.getFrameIdx(), null)));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("freq_source", this.getFreqSource(), L1CurrentT2MIPacketsPayload.getFreqSourceString(this.getFreqSource()))));
        DefaultMutableTreeNode l1currentData = new DefaultMutableTreeNode(new KVP("L1-current_data"));
        payloadNode.add(l1currentData);
        l1currentData.add(this.l1PreSignallingData.getJTreeNode(modus));
        l1currentData.add(new DefaultMutableTreeNode(new KVP("L1CONF_LEN", this.l1ConfLen, T2miPacket.getLenInBytes(this.l1ConfLen))));
        l1currentData.add(this.configurable1PostSignalling.getJTreeNode(modus));
        l1currentData.add(new DefaultMutableTreeNode(new KVP("L1DYN_CURR_LEN", this.l1DynCurrLen, T2miPacket.getLenInBytes(this.l1DynCurrLen))));
        l1currentData.add(this.dynamicL1PostSignalling.getJTreeNode(modus));
        l1currentData.add(new DefaultMutableTreeNode(new KVP("L1EXT_LEN", this.l1ExtLen, T2miPacket.getLenInBytes(this.l1ExtLen))));
        if (this.l1ExtLen != 0) {
            l1currentData.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("L1-post extension field")));
        }
        return payloadNode;
    }

    public int getFreqSource() {
        return Byte.toUnsignedInt(this.data[7]) >> 6;
    }

    public static String getFreqSourceString(int freq_source) {
        return freq_source_list.get(freq_source);
    }
}

