/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.CRCcheck;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.BasebandFramePayload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.DVBT2TimestampPayload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.IndividualAddressingPayload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.L1CurrentT2MIPacketsPayload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Payload;
import nl.digitalekabeltelevisie.util.LookUpList;

public class T2miPacket
implements TreeNode {
    private static final Logger LOGGER = Logger.getLogger(T2miPacket.class.getName());
    private static LookUpList packet_type_list = new LookUpList.Builder().add(0, "Baseband Frame").add(1, "Auxiliary stream I/Q data").add(2, "Arbitrary cell insertion").add(16, "L1-current").add(17, "L1-future").add(18, "P2 bias balancing cells").add(32, "DVB-T2 timestamp").add(33, "Individual addressing").add(48, "FEF part: Null").add(49, "FEF part: I/Q data").add(50, "FEF part: composite").add(51, "FEF sub-part").build();
    private byte[] data;
    private int packetNo;
    private Payload payload;

    public T2miPacket(byte[] result, int packetNo) {
        this.data = result;
        this.packetNo = packetNo;
        switch (this.getPacketType()) {
            case 0: {
                this.payload = new BasebandFramePayload(this.data);
                break;
            }
            case 16: {
                this.payload = new L1CurrentT2MIPacketsPayload(this.data);
                break;
            }
            case 32: {
                this.payload = new DVBT2TimestampPayload(this.data);
                break;
            }
            case 33: {
                this.payload = new IndividualAddressingPayload(this.data);
                break;
            }
            default: {
                this.payload = new Payload(this.data, T2miPacket.getPacketTypeString(this.getPacketType()));
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("T2MI Packet (" + T2miPacket.getPacketTypeString(this.getPacketType()) + ")"));
        t.add(new DefaultMutableTreeNode(new KVP("Start TS Packet No", this.packetNo, null)));
        t.add(new DefaultMutableTreeNode(new KVP("data", this.data, null)));
        t.add(new DefaultMutableTreeNode(new KVP("packet_type", this.getPacketType(), T2miPacket.getPacketTypeString(this.getPacketType()))));
        t.add(new DefaultMutableTreeNode(new KVP("packet_count", this.getPacketCount(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("superframe_idx", this.getSuperframeIdx(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("t2mi_stream_id", this.getT2miStreamId(), null)));
        int payloadLenBits = this.getPayloadLen();
        t.add(new DefaultMutableTreeNode(new KVP("payload_len", payloadLenBits, T2miPacket.getLenInBytes(payloadLenBits))));
        t.add(this.payload.getJTreeNode(modus));
        long crcResult = this.getCRCresult();
        String crcMsg = null;
        if (crcResult != 0L) {
            LOGGER.warning("CRC check failed for t2mi, result:" + crcResult + ", packetNo:" + this.packetNo + ", packetType:" + this.getPacketType());
            crcMsg = "CRC check failed!";
        }
        t.add(new DefaultMutableTreeNode(new KVP("crc32", this.data, this.data.length - 4, 4, crcMsg)));
        return t;
    }

    public long getCRCresult() {
        return CRCcheck.crc32(this.data, this.data.length);
    }

    public static String getLenInBytes(int payloadLenBits) {
        return "bits = " + (payloadLenBits + 7) / 8 + " Bytes";
    }

    public int getPacketType() {
        return Byte.toUnsignedInt(this.data[0]);
    }

    public static String getPacketTypeString(int type) {
        return packet_type_list.get(type);
    }

    public int getPacketCount() {
        return Byte.toUnsignedInt(this.data[1]);
    }

    public int getSuperframeIdx() {
        return Byte.toUnsignedInt(this.data[2]) >> 4;
    }

    public int getT2miStreamId() {
        return Byte.toUnsignedInt(this.data[4]) & 7;
    }

    public int getPayloadLen() {
        return 256 * Byte.toUnsignedInt(this.data[4]) + Byte.toUnsignedInt(this.data[5]);
    }

    public int getPacketNo() {
        return this.packetNo;
    }

    public Payload getPayload() {
        return this.payload;
    }
}

