/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.ApplicationNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;

public class AITsection
extends TableSectionExtendedSyntax {
    private int test_application_flag;
    private int application_type;
    private int common_descriptors_length;
    private List<Descriptor> common_descriptor_loop;
    private int application_loop_length;
    private List<Application> applications;

    public AITsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.test_application_flag = Utils.getInt(raw_data.getData(), 3, 1, 128) >> 7;
        this.application_type = Utils.getInt(raw_data.getData(), 3, 2, Short.MAX_VALUE);
        this.common_descriptors_length = Utils.getInt(raw_data.getData(), 8, 2, 4095);
        this.common_descriptor_loop = DescriptorFactory.buildDescriptorList(raw_data.getData(), 10, this.common_descriptors_length, this);
        this.application_loop_length = Utils.getInt(raw_data.getData(), 10 + this.common_descriptors_length, 2, 4095);
        this.applications = this.buildApplicationList(raw_data.getData(), 12 + this.common_descriptors_length, this.application_loop_length);
    }

    private List<Application> buildApplicationList(byte[] data, int i, int length) {
        Application a;
        ArrayList<Application> r = new ArrayList<Application>();
        for (int t = 0; t < length; t += 9 + a.getApplication_descriptors_loop_length()) {
            a = new Application();
            a.setOrganisation_id(Utils.getLong(data, i + t, 4, -1L));
            a.setApplication_id(Utils.getInt(data, i + t + 4, 2, 65535));
            a.setApplication_control_code(Utils.getInt(data, i + t + 6, 1, 255));
            a.setApplication_descriptors_loop_length(Utils.getInt(data, i + t + 7, 2, 4095));
            a.setApplicationDescriptors(DescriptorFactory.buildDescriptorList(data, i + t + 9, a.getApplication_descriptors_loop_length(), this));
            r.add(a);
        }
        return r;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("AITsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(AITsection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("common_descriptors_length", this.common_descriptors_length, null)));
        Utils.addListJTree(t, this.common_descriptor_loop, modus, "common_descriptor_loop");
        Utils.addListJTree(t, this.applications, modus, "applications");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "test_application_flag (1 bit) / application_type (15 bits)";
    }

    @Override
    protected String getTableIdExtensionDescription(int tableIdExtension) {
        int test_application_flag = (tableIdExtension & 0x8000) >> 15;
        int application_type = tableIdExtension & Short.MAX_VALUE;
        return "test_application_flag=" + test_application_flag + ", application_type=" + application_type + " (" + Utils.getAppTypeIDString(application_type) + ")";
    }

    public int getApplication_loop_length() {
        return this.application_loop_length;
    }

    public void setApplication_loop_length(int application_loop_length) {
        this.application_loop_length = application_loop_length;
    }

    public int getApplication_type() {
        return this.application_type;
    }

    public void setApplication_type(int application_type) {
        this.application_type = application_type;
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    public List<Descriptor> getCommon_descriptor_loop() {
        return this.common_descriptor_loop;
    }

    public void setCommon_descriptor_loop(List<Descriptor> common_descriptor_loop) {
        this.common_descriptor_loop = common_descriptor_loop;
    }

    public int getCommon_descriptors_length() {
        return this.common_descriptors_length;
    }

    public void setCommon_descriptors_length(int common_descriptors_length) {
        this.common_descriptors_length = common_descriptors_length;
    }

    public static String getApplicationControlCodeString(int i) {
        switch (i) {
            case 0: {
                return "reserved_future_use";
            }
            case 1: {
                return "AUTOSTART";
            }
            case 2: {
                return "PRESENT";
            }
            case 3: {
                return "DESTROY";
            }
            case 4: {
                return "KILL";
            }
            case 5: {
                return "PREFETCH";
            }
            case 6: {
                return "REMOTE";
            }
            case 7: {
                return "DISABLED";
            }
            case 8: {
                return "PLAYBACK_AUTOSTART";
            }
        }
        return "reserved for future use";
    }

    public static String getApplicationIDString(int i) {
        if (i == 0) {
            return "Shall not be used";
        }
        if (i >= 1 && i <= 16383) {
            return "Application_ids for unsigned applications";
        }
        if (i >= 16384 && i <= Short.MAX_VALUE) {
            return "Application_ids for signed applications";
        }
        if (i >= 32768 && i <= 40959) {
            return "Application_ids for privileged applications";
        }
        if (i >= 40960 && i <= 65533) {
            return "Reserved for future use by DVB";
        }
        if (i == 65534) {
            return "Special wildcard value for signed applications of an organization";
        }
        if (i == 65535) {
            return "Special wildcard value for all applications of an organization";
        }
        return "unknown";
    }

    public int getTest_application_flag() {
        return this.test_application_flag;
    }

    public static class Application
    implements TreeNode {
        private long organisation_id;
        private int application_id;
        private int application_control_code;
        private int application_descriptors_loop_length;
        private List<Descriptor> applicationDescriptors;

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            ApplicationNameDescriptor appNameDesc;
            List<ApplicationNameDescriptor.ApplicationName> appNames;
            StringBuilder label = new StringBuilder("application");
            List<ApplicationNameDescriptor> applicationNameDescriptors = Descriptor.findGenericDescriptorsInList(this.applicationDescriptors, ApplicationNameDescriptor.class);
            if (applicationNameDescriptors.size() > 0 && (appNames = (appNameDesc = applicationNameDescriptors.get(0)).getApplicationNames()) != null && appNames.size() > 0) {
                ApplicationNameDescriptor.ApplicationName appName = appNames.get(0);
                label.append(" (").append(appName.application_name().toString()).append(")");
            }
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP(label.toString()));
            t.add(new DefaultMutableTreeNode(new KVP("organisation_id", this.organisation_id, Utils.getMHPOrganistionIdString(this.organisation_id))));
            t.add(new DefaultMutableTreeNode(new KVP("application_id", this.application_id, AITsection.getApplicationIDString(this.application_id))));
            t.add(new DefaultMutableTreeNode(new KVP("application_control_code", this.application_control_code, AITsection.getApplicationControlCodeString(this.application_control_code))));
            t.add(new DefaultMutableTreeNode(new KVP("application_descriptors_loop_length", this.application_descriptors_loop_length, null)));
            Utils.addListJTree(t, this.applicationDescriptors, modus, "application_descriptors");
            return t;
        }

        public int getApplication_control_code() {
            return this.application_control_code;
        }

        public void setApplication_control_code(int application_control_code) {
            this.application_control_code = application_control_code;
        }

        public int getApplication_descriptors_loop_length() {
            return this.application_descriptors_loop_length;
        }

        public void setApplication_descriptors_loop_length(int application_descriptors_loop_lengt) {
            this.application_descriptors_loop_length = application_descriptors_loop_lengt;
        }

        public int getApplication_id() {
            return this.application_id;
        }

        public void setApplication_id(int application_id) {
            this.application_id = application_id;
        }

        public List<Descriptor> getApplicationDescriptors() {
            return this.applicationDescriptors;
        }

        public void setApplicationDescriptors(List<Descriptor> applicationDescriptor) {
            this.applicationDescriptors = applicationDescriptor;
        }

        public long getOrganisation_id() {
            return this.organisation_id;
        }

        public void setOrganisation_id(long organisation_id) {
            this.organisation_id = organisation_id;
        }
    }
}

