/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;

public abstract class AbstractPSITabel
implements TreeNode {
    protected PSI parentPSI;

    protected AbstractPSITabel(PSI parentPSI) {
        this.parentPSI = parentPSI;
    }

    public PSI getParentPSI() {
        return this.parentPSI;
    }

    public void setParentPSI(PSI parentPSI) {
        this.parentPSI = parentPSI;
    }

    public static void addSectionVersionsToJTree(DefaultMutableTreeNode n, TableSection tableSection, int modus) {
        n.add(tableSection.getJTreeNode(modus));
        for (TableSection versions = tableSection.getNextVersion(); versions != null; versions = versions.getNextVersion()) {
            n.add(versions.getJTreeNode(modus));
        }
    }

    public static TableSection updateSectionVersion(TableSection newSection, TableSection section) {
        TableSection last = section;
        while (last.getNextVersion() != null) {
            last = last.getNextVersion();
        }
        if (last.equals(newSection)) {
            int previousPacketNo = last.getLast_packet_no();
            TransportStream transportStream = newSection.getParentTransportStream();
            long distance = newSection.getParentTransportStream().isAVCHD() ? transportStream.getAVCHDPacketTime(newSection.getPacket_no()) - transportStream.getAVCHDPacketTime(previousPacketNo) : (long)(newSection.getPacket_no() - previousPacketNo);
            if (distance > last.getMaxPacketDistance()) {
                last.setMaxPacketDistance(distance);
            }
            if (distance < last.getMinPacketDistance()) {
                last.setMinPacketDistance(distance);
            }
            last.setLast_packet_no(newSection.getPacket_no());
            last.setOccurrence_count(last.getOccurrence_count() + 1);
            return last;
        }
        last.setNextVersion(newSection);
        return newSection;
    }
}

