/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CADescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.CAT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class CAsection
extends TableSectionExtendedSyntax
implements TableSource {
    private List<Descriptor> descriptorList;

    public CAsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.descriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 8, this.sectionLength - 9, this);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("CAsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber());
        return b.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        if (!this.descriptorList.isEmpty()) {
            KVP kvp = (KVP)t.getUserObject();
            kvp.addTableSource(this, "cat");
        }
        Utils.addListJTree(t, this.descriptorList, modus, "descriptors");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "reserved";
    }

    public List<Descriptor> getDescriptorList() {
        return this.descriptorList;
    }

    public void setDescriptorList(List<Descriptor> descriptorList) {
        this.descriptorList = descriptorList;
    }

    @Override
    public TableModel getTableModel() {
        FlexTableModel<CAsection, CADescriptor> tableModel = new FlexTableModel<CAsection, CADescriptor>(CAT.buildCatTableHeader());
        tableModel.addData(this, Descriptor.findGenericDescriptorsInList(this.getDescriptorList(), CADescriptor.class));
        tableModel.process();
        return tableModel;
    }
}

