/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.DFITSection;

public class DFIT
extends AbstractPSITabel {
    private final Map<Integer, DFITSection[]> dfits = new TreeMap<Integer, DFITSection[]>();
    private int pid = 0;

    protected DFIT(PSI parentPSI) {
        super(parentPSI);
    }

    public void update(DFITSection section) {
        this.pid = section.getParentPID().getPid();
        int fontId = section.getFont_id();
        DFITSection[] sections = this.dfits.computeIfAbsent(fontId, f -> new DFITSection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            DFITSection last = sections[section.getSectionNumber()];
            DFIT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("DFIT PID=" + this.pid));
        for (Map.Entry<Integer, DFITSection[]> dfit : this.dfits.entrySet()) {
            int font_id = dfit.getKey();
            DFITSection[] sections = dfit.getValue();
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new KVP("DFIT, fontId", font_id, null));
            for (DFITSection tsection : sections) {
                if (tsection == null) continue;
                DFIT.addSectionVersionsToJTree(n, tsection, modus);
            }
            t.add(n);
        }
        return t;
    }
}

