/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.IntPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ParentalRatingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.EITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.gui.EITableImage;
import nl.digitalekabeltelevisie.util.Interval;
import nl.digitalekabeltelevisie.util.ServiceIdentification;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;
import org.apache.commons.lang3.ArrayUtils;

public class EIT
extends AbstractPSITabel {
    private static final String EVENT_GRID_TITLE = "Grid";
    private static final String EVENTS_SCHEDULE_TITLE = "Events Schedule";
    private final Map<Integer, TreeMap<Integer, TreeMap<Integer, TreeMap<Integer, EITsection[]>>>> eit = new TreeMap<Integer, TreeMap<Integer, TreeMap<Integer, TreeMap<Integer, EITsection[]>>>>();
    private static final Logger logger = Logger.getLogger(EIT.class.getName());

    public EIT(PSI parent) {
        super(parent);
    }

    public void update(EITsection section) {
        int original_network_id = section.getOriginalNetworkID();
        int streamId = section.getTransportStreamID();
        int serviceId = section.getServiceID();
        int tableId = section.getTableId();
        TreeMap networkSections = this.eit.computeIfAbsent(original_network_id, k -> new TreeMap());
        TreeMap programStreamSections = networkSections.computeIfAbsent(streamId, k -> new TreeMap());
        TreeMap serviceSections = programStreamSections.computeIfAbsent(serviceId, k -> new TreeMap());
        EITsection[] tableSectionArray = serviceSections.computeIfAbsent(tableId, k -> new EITsection[section.getSectionLastNumber() + 1]);
        if (tableSectionArray.length <= section.getSectionNumber()) {
            tableSectionArray = Arrays.copyOf(tableSectionArray, section.getSectionNumber() + 1);
            serviceSections.put(tableId, tableSectionArray);
        }
        if (tableSectionArray[section.getSectionNumber()] == null) {
            tableSectionArray[section.getSectionNumber()] = section;
        } else {
            EITsection last = tableSectionArray[section.getSectionNumber()];
            EIT.updateSectionVersion(section, last);
        }
    }

    public EITsection[] getActualTransportStreamEitPF(int serviceId) {
        for (TreeMap<Integer, TreeMap<Integer, TreeMap<Integer, EITsection[]>>> onid : this.eit.values()) {
            for (TreeMap<Integer, TreeMap<Integer, EITsection[]>> ts : onid.values()) {
                EITsection[] res;
                TreeMap<Integer, EITsection[]> serviceEit = ts.get(serviceId);
                if (serviceEit == null || (res = serviceEit.get(78)) == null) continue;
                return res;
            }
        }
        return new EITsection[0];
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("EIT");
        TreeMap<ServiceIdentification, EITsection[]> allEitImageMap = new TreeMap<ServiceIdentification, EITsection[]>();
        for (Map.Entry<Integer, TreeMap<Integer, TreeMap<Integer, TreeMap<Integer, EITsection[]>>>> network : this.eit.entrySet()) {
            Integer orgNetworkId = network.getKey();
            SortedMap networkSections = network.getValue();
            KVP networkNode = new KVP("original_network_id", orgNetworkId).setDescription(Utils.getOriginalNetworkIDString(orgNetworkId));
            t.add(networkNode);
            TreeMap<ServiceIdentification, EITsection[]> networkImageMap = new TreeMap<ServiceIdentification, EITsection[]>();
            for (Map.Entry netWorkSection : networkSections.entrySet()) {
                Integer transport_stream_id = (Integer)netWorkSection.getKey();
                SortedMap streams = (SortedMap)netWorkSection.getValue();
                KVP streamNode = new KVP("transport_stream_id", transport_stream_id);
                networkNode.add(streamNode);
                TreeMap<ServiceIdentification, EITsection[]> streamImageMap = new TreeMap<ServiceIdentification, EITsection[]>();
                for (Map.Entry streamEntry : streams.entrySet()) {
                    Integer serviceId = (Integer)streamEntry.getKey();
                    SortedMap service = (SortedMap)streamEntry.getValue();
                    EITsection[] serviceSections = new EITsection[]{};
                    KVP serviceNode = new KVP("service_id", serviceId).setDescription(this.getParentPSI().getSdt().getServiceName(orgNetworkId, transport_stream_id, serviceId));
                    serviceNode.addHTMLSource(() -> service.entrySet().stream().filter(s -> (Integer)s.getKey() >= 80).map(Map.Entry::getValue).flatMap(Arrays::stream).filter(Objects::nonNull).map(e -> e.getHtmlForEit(modus)).collect(Collectors.joining("", "<b>Schedule</b><br><br>", "")), "List");
                    serviceNode.addTableSource(() -> EIT.getTableModelForService(service.entrySet()), EVENTS_SCHEDULE_TITLE);
                    streamNode.add(serviceNode);
                    for (Map.Entry serviceEntry : service.entrySet()) {
                        Integer tableId = (Integer)serviceEntry.getKey();
                        EITsection[] sections = (EITsection[])serviceEntry.getValue();
                        KVP tableNode = new KVP("tableid", tableId).setDescription(TableSection.getTableType(tableId));
                        tableNode.addHTMLSource(() -> Arrays.stream(sections).filter(Objects::nonNull).map(e -> e.getHtmlForEit(modus)).collect(Collectors.joining()), "List");
                        tableNode.addTableSource(() -> EIT.getTableModel(sections), "Events");
                        serviceNode.add(tableNode);
                        if (tableId >= 80) {
                            serviceSections = EIT.appendSections(serviceSections, sections);
                        }
                        for (EITsection section : sections) {
                            if (section == null) continue;
                            if (Utils.simpleModus(modus)) {
                                Utils.addListJTree(tableNode, section.getEventList(), modus, "events");
                                continue;
                            }
                            EIT.addSectionVersionsToJTree(tableNode, section, modus);
                        }
                    }
                    streamImageMap.put(new ServiceIdentification(orgNetworkId, transport_stream_id, serviceId), serviceSections);
                }
                streamNode.addImageSource(new EITableImage(this, streamImageMap), EVENT_GRID_TITLE);
                streamNode.addTableSource(() -> EIT.getTableModelForStream(streamImageMap.values()), EVENTS_SCHEDULE_TITLE);
                networkImageMap.putAll(streamImageMap);
            }
            networkNode.addImageSource(new EITableImage(this, networkImageMap), EVENT_GRID_TITLE);
            networkNode.addTableSource(() -> EIT.getTableModelForStream(networkImageMap.values()), EVENTS_SCHEDULE_TITLE);
            allEitImageMap.putAll(networkImageMap);
        }
        t.addImageSource(new EITableImage(this, allEitImageMap), EVENT_GRID_TITLE);
        t.addTableSource(() -> EIT.getTableModelForStream(allEitImageMap.values()), EVENTS_SCHEDULE_TITLE);
        return t;
    }

    private static TableModel getTableModelForStream(Collection<EITsection[]> collection) {
        FlexTableModel<EITsection, EITsection.Event> tableModel = new FlexTableModel<EITsection, EITsection.Event>(EIT.buildEitTableHeader());
        for (EITsection[] sections : collection) {
            for (EITsection section : sections) {
                if (section == null) continue;
                tableModel.addData(section, section.getEventList());
            }
        }
        tableModel.process();
        return tableModel;
    }

    private static TableModel getTableModelForService(Set<Map.Entry<Integer, EITsection[]>> entrySet) {
        FlexTableModel<EITsection, EITsection.Event> tableModel = new FlexTableModel<EITsection, EITsection.Event>(EIT.buildEitTableHeader());
        for (Map.Entry<Integer, EITsection[]> entry : entrySet) {
            EITsection[] sections;
            if (entry.getKey() < 80) continue;
            for (EITsection section : sections = entry.getValue()) {
                if (section == null) continue;
                tableModel.addData(section, section.getEventList());
            }
        }
        tableModel.process();
        return tableModel;
    }

    private static TableModel getTableModel(EITsection[] sections) {
        FlexTableModel<EITsection, EITsection.Event> tableModel = new FlexTableModel<EITsection, EITsection.Event>(EIT.buildEitTableHeader());
        for (EITsection section : sections) {
            if (section == null) continue;
            tableModel.addData(section, section.getEventList());
        }
        tableModel.process();
        return tableModel;
    }

    private static EITsection[] appendSections(EITsection[] serviceSections, EITsection[] sections) {
        EITsection[] tmpArray = new EITsection[serviceSections.length + sections.length];
        System.arraycopy(serviceSections, 0, tmpArray, 0, serviceSections.length);
        System.arraycopy(sections, 0, tmpArray, serviceSections.length, sections.length);
        return tmpArray;
    }

    public static Interval getSpanningInterval(Set<ServiceIdentification> serviceSet, Map<ServiceIdentification, EITsection[]> eitTable) {
        LocalDateTime startDate = null;
        LocalDateTime endDate = null;
        for (ServiceIdentification serviceNo : serviceSet) {
            for (EITsection section : eitTable.get(serviceNo)) {
                if (section == null) continue;
                List<EITsection.Event> eventList = section.getEventList();
                for (EITsection.Event event : eventList) {
                    byte[] startTime = event.getStartTime();
                    if (Utils.isUndefined(startTime)) continue;
                    LocalDateTime eventStart = Utils.getUTCLocalDateTime(startTime);
                    if (startDate == null || startDate.isAfter(eventStart)) {
                        startDate = eventStart;
                    }
                    if (eventStart == null) continue;
                    try {
                        LocalDateTime eventEnd = eventStart.plusSeconds(Utils.getDurationSeconds(event.getDuration()));
                        if (endDate != null && !endDate.isBefore(eventEnd)) continue;
                        endDate = eventEnd;
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.WARNING, "getSpanningInterval: Event.duration is not a valid BCD number;", nfe);
                    }
                }
            }
        }
        if (startDate != null && endDate != null) {
            return new Interval(startDate, endDate);
        }
        return null;
    }

    public Map<ServiceIdentification, EITsection[]> getCombinedSchedule() {
        return this.getFlatEit(tableId -> tableId >= 80);
    }

    public Map<ServiceIdentification, EITsection[]> getCombinedPresentFollowing() {
        return this.getFlatEit(tableId -> tableId < 80);
    }

    public Map<ServiceIdentification, EITsection[]> getFlatEit(IntPredicate scheduleOrPF) {
        TreeMap<ServiceIdentification, EITsection[]> result = new TreeMap<ServiceIdentification, EITsection[]>();
        for (Map.Entry<Integer, TreeMap<Integer, TreeMap<Integer, TreeMap<Integer, EITsection[]>>>> networkEntry : this.eit.entrySet()) {
            int orgNetworkId = networkEntry.getKey();
            SortedMap network = networkEntry.getValue();
            for (Map.Entry streamEntry : network.entrySet()) {
                int streamId = (Integer)streamEntry.getKey();
                SortedMap stream = (SortedMap)streamEntry.getValue();
                for (Map.Entry serviceEntry : stream.entrySet()) {
                    int serviceId = (Integer)serviceEntry.getKey();
                    SortedMap service = (SortedMap)serviceEntry.getValue();
                    for (Map.Entry tableEntry : service.entrySet()) {
                        int tableId = (Integer)tableEntry.getKey();
                        if (!scheduleOrPF.test(tableId)) continue;
                        result.merge(new ServiceIdentification(orgNetworkId, streamId, serviceId), (EITsection[])tableEntry.getValue(), ArrayUtils::addAll);
                    }
                }
            }
        }
        return result;
    }

    static TableHeader<EITsection, EITsection.Event> buildEitTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("onid", EITsection::getOriginalNetworkID, Integer.class).addRequiredBaseColumn("tsid", EITsection::getTransportStreamID, Integer.class).addRequiredBaseColumn("sid", EITsection::getServiceID, Integer.class).addRequiredBaseColumn("service", EITsection::findServiceName, String.class).addRequiredRowColumn("Start time", e -> Utils.getEITStartTimeAsString(e.getStartTime()), String.class).addRequiredRowColumn("duration", e -> Utils.formatDuration(e.getDuration()), String.class).addRequiredRowColumn("Event ID", EITsection.Event::getEventID, Integer.class).addRequiredRowColumn("Event Name", EITsection.Event::getEventName, String.class).addOptionalRepeatingRowColumn("rating ", component -> Descriptor.findDescriptorApplyListFunc(component.getDescriptorList(), ParentalRatingDescriptor.class, ratingDescriptor -> new ArrayList<ParentalRatingDescriptor.Rating>(ratingDescriptor.getRatingList())), ParentalRatingDescriptor.Rating.class).build();
    }
}

