/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ComponentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ContentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ExtendedEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LanguageDependentEitDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ParentalRatingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ShortEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TimeShiftedEventDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.EIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class EITsection
extends TableSectionExtendedSyntax {
    private List<Event> eventList;
    private final int transportStreamID;
    private final int originalNetworkID;
    private final int segmentLastSectionNumber;
    private final int lastTableID;

    public EITsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.transportStreamID = Utils.getInt(raw_data.getData(), 8, 2, 65535);
        this.originalNetworkID = Utils.getInt(raw_data.getData(), 10, 2, 65535);
        this.segmentLastSectionNumber = Utils.getInt(raw_data.getData(), 12, 1, 255);
        this.lastTableID = Utils.getInt(raw_data.getData(), 13, 1, 255);
        this.eventList = this.buildEventList(raw_data.getData(), 14, this.sectionLength - 14 - 4);
    }

    public int getServiceID() {
        return this.getTableIdExtension();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("EITsection section=");
        b.append(this.getSectionNumber()).append(", OrgNetworkId=").append(this.originalNetworkID).append(", TransportStreamID=").append(this.transportStreamID).append(", ServiceD=").append(this.getServiceID()).append(", tableType=").append(EITsection.getTableType(this.getTableId())).append(", lastSection=").append(this.getSectionLastNumber());
        return b.toString();
    }

    public List<Event> getEventList() {
        return this.eventList;
    }

    public void setEventList(List<Event> eventList) {
        this.eventList = eventList;
    }

    public int noEvents() {
        return this.eventList.size();
    }

    private List<Event> buildEventList(byte[] data, int offset, int programInfoLength) {
        Event c;
        ArrayList<Event> r = new ArrayList<Event>();
        for (int t = 0; t < programInfoLength; t += 12 + c.getDescriptorsLoopLength()) {
            c = new Event();
            c.setEventID(Utils.getInt(data, offset + t, 2, 65535));
            c.setStartTime(Arrays.copyOfRange(data, offset + t + 2, offset + t + 7));
            c.setDuration(Utils.getBCD(data, (offset + t + 7) * 2, 6));
            c.setRunningStatus(Utils.getInt(data, offset + t + 10, 1, 224) >> 5);
            c.setFreeCAMode(Utils.getInt(data, offset + t + 10, 1, 16) >> 4);
            c.setDescriptorsLoopLength(Utils.getInt(data, offset + t + 10, 2, 4095));
            c.setDescriptorList(DescriptorFactory.buildDescriptorList(data, offset + t + 12, c.getDescriptorsLoopLength(), this));
            r.add(c);
        }
        return r;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        KVP kvp = (KVP)t.getUserObject();
        kvp.addHTMLSource(() -> this.getHtmlForEit(modus), "List");
        kvp.addTableSource(this::getTableModel, "Events");
        t.add(new KVP("service_id", this.getServiceID()));
        t.add(new KVP("transport_stream_id", this.transportStreamID));
        t.add(new KVP("original_network_id", this.originalNetworkID).setDescription(Utils.getOriginalNetworkIDString(this.originalNetworkID)));
        t.add(new KVP("segment_last_section_number", this.segmentLastSectionNumber));
        t.add(new KVP("last_table_id", this.lastTableID));
        Utils.addListJTree(t, this.eventList, modus, "events");
        return t;
    }

    String getHtmlForEit(int modus) {
        StringBuilder b = new StringBuilder();
        b.append("<code>");
        b.append((CharSequence)this.getHTMLLines(modus));
        b.append("</code>");
        return b.toString();
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "service_id";
    }

    public StringBuilder getHTMLLines(int modus) {
        StringBuilder b = new StringBuilder();
        for (Event event : this.eventList) {
            b.append(Utils.escapeHTML(Utils.getEITStartTimeAsString(event.getStartTime()))).append("&nbsp;").append(Utils.formatDuration(event.getDuration())).append("&nbsp;");
            List<Descriptor> descList = event.getDescriptorList();
            List<ShortEventDescriptor> shortDesc = Descriptor.findGenericDescriptorsInList(descList, ShortEventDescriptor.class);
            if (!shortDesc.isEmpty()) {
                for (ShortEventDescriptor shortEventDescriptor : shortDesc) {
                    b.append("<b><span style=\"background-color: white\">").append("<a href=\"root/psi/eit/original_network_id:").append(this.originalNetworkID).append("/transport_stream_id:").append(this.transportStreamID).append("/service_id:").append(this.getServiceID()).append("/tableid:").append(this.tableId);
                    if (!Utils.simpleModus(modus)) {
                        b.append("/tablesection:").append(this.getSectionNumber()).append("/events");
                    }
                    b.append("/event:").append(event.eventID).append("\">").append(Utils.escapeHTML(shortEventDescriptor.getEventName().toString())).append("</a>").append("</span></b>&nbsp;").append(Utils.escapeHTML(shortEventDescriptor.getText().toString()));
                }
            }
            List<ExtendedEventDescriptor> extendedDesc = Descriptor.findGenericDescriptorsInList(descList, ExtendedEventDescriptor.class);
            for (ExtendedEventDescriptor extEvent : extendedDesc) {
                b.append(Utils.escapeHTML(extEvent.getText().toString()));
            }
            b.append("<br>");
        }
        return b;
    }

    public int getTransportStreamID() {
        return this.transportStreamID;
    }

    public int getOriginalNetworkID() {
        return this.originalNetworkID;
    }

    public String findServiceName() {
        return this.getPSI().getSdt().getServiceName(this.originalNetworkID, this.transportStreamID, this.getServiceID());
    }

    public TableModel getTableModel() {
        FlexTableModel<EITsection, Event> tableModel = new FlexTableModel<EITsection, Event>(EIT.buildEitTableHeader());
        tableModel.addData(this, this.eventList);
        tableModel.process();
        return tableModel;
    }

    public static class Event
    implements TreeNode,
    HTMLSource {
        private int eventID;
        private byte[] startTime;
        private String duration;
        private int runningStatus;
        private int freeCAMode;
        private int descriptorsLoopLength;
        private List<Descriptor> descriptorList;

        public List<Descriptor> getDescriptorList() {
            return this.descriptorList;
        }

        public void setDescriptorList(List<Descriptor> descriptorList) {
            this.descriptorList = descriptorList;
        }

        public int getEventID() {
            return this.eventID;
        }

        public void setEventID(int eventID) {
            this.eventID = eventID;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Event, ID=");
            b.append(this.eventID).append(", start_time:").append(Utils.getEITStartTimeAsString(this.startTime)).append(", duration:").append(Utils.formatDuration(this.duration));
            for (Descriptor d : this.descriptorList) {
                b.append(d).append(", ");
            }
            return b.toString();
        }

        public String getEventName() {
            for (Descriptor d : this.descriptorList) {
                if (!(d instanceof ShortEventDescriptor)) continue;
                ShortEventDescriptor shortEventDescriptor = (ShortEventDescriptor)d;
                return shortEventDescriptor.getEventName().toString();
            }
            return "";
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("event", this.eventID).setDescription(Utils.getEITStartTimeAsString(this.startTime) + " " + this.getEventName());
            t.addHTMLSource(this, "Event details");
            t.add(new KVP("event_id", this.eventID));
            t.add(new KVP("start_time", this.startTime).setDescription(Utils.getEITStartTimeAsString(this.startTime)));
            t.add(new KVP("duration", this.duration).setDescription(Utils.formatDuration(this.duration)));
            t.add(new KVP("running_status", this.runningStatus).setDescription(TableSection.getRunningStatusString(this.runningStatus)));
            t.add(new KVP("free_CA_mode", this.freeCAMode).setDescription(TableSection.getFreeCAmodeString(this.freeCAMode)));
            t.add(new KVP("descriptors_loop_length", this.descriptorsLoopLength));
            Utils.addListJTree(t, this.descriptorList, modus, "event_descriptors");
            return t;
        }

        public int getDescriptorsLoopLength() {
            return this.descriptorsLoopLength;
        }

        public void setDescriptorsLoopLength(int descriptorsLoopLength) {
            this.descriptorsLoopLength = descriptorsLoopLength;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public int getFreeCAMode() {
            return this.freeCAMode;
        }

        public void setFreeCAMode(int freeCAMode) {
            this.freeCAMode = freeCAMode;
        }

        public int getRunningStatus() {
            return this.runningStatus;
        }

        public void setRunningStatus(int runningStatus) {
            this.runningStatus = runningStatus;
        }

        public byte[] getStartTime() {
            return this.startTime;
        }

        public void setStartTime(byte[] startTime) {
            this.startTime = startTime;
        }

        @Override
        public String getHTML() {
            StringBuilder r1 = new StringBuilder();
            r1.append("Start:&nbsp;").append(Utils.getEITStartTimeAsString(this.getStartTime())).append("&nbsp;Duration: ").append(Utils.formatDuration(this.duration)).append("<br><hr><br>");
            List<Descriptor> descList = this.descriptorList;
            Event.addTimeShiftDetails(r1, Descriptor.findGenericDescriptorsInList(descList, TimeShiftedEventDescriptor.class));
            LinkedHashMap<String, ArrayList<LanguageDependentEitDescriptor>> languageDependentDescriptorsMap = Event.mapDescriptorsByLanguage(descList);
            for (String isoLanguage : languageDependentDescriptorsMap.keySet()) {
                ArrayList<LanguageDependentEitDescriptor> languageList = languageDependentDescriptorsMap.get(isoLanguage);
                r1.append("ISO_639_language_code: ").append(isoLanguage).append("<br><br>");
                Event.addShortEventDetails(r1, languageList);
                Event.addExtendedEventDetails(r1, languageList);
                Event.addComponentDetails(r1, languageList);
                r1.append("<hr><br>");
            }
            Event.addContentDetails(r1, Descriptor.findGenericDescriptorsInList(descList, ContentDescriptor.class));
            Event.addParentalRatingDetails(r1, Descriptor.findGenericDescriptorsInList(descList, ParentalRatingDescriptor.class));
            return r1.toString();
        }

        private static void addTimeShiftDetails(StringBuilder r1, List<TimeShiftedEventDescriptor> timeShiftedEventDescriptorList) {
            for (TimeShiftedEventDescriptor timeShiftedEventDescriptor : timeShiftedEventDescriptorList) {
                r1.append("Event is a time shifted copy of other event; service_id:").append(timeShiftedEventDescriptor.getReference_service_id()).append(", event_id:").append(timeShiftedEventDescriptor.getReference_event_id()).append("<br><br>");
            }
        }

        private static void addParentalRatingDetails(StringBuilder r1, List<ParentalRatingDescriptor> ratingDescList) {
            for (ParentalRatingDescriptor ratingDesc : ratingDescList) {
                List<ParentalRatingDescriptor.Rating> ratingList = ratingDesc.getRatingList();
                for (ParentalRatingDescriptor.Rating c : ratingList) {
                    r1.append("Rating: ").append(c.getCountryCode()).append(": ").append(ParentalRatingDescriptor.getRatingTypeAge(c.getRating())).append("<br>");
                }
                r1.append("<br>");
            }
        }

        private static void addContentDetails(StringBuilder r1, List<ContentDescriptor> contentDescList) {
            if (!contentDescList.isEmpty()) {
                for (ContentDescriptor contentDesc : contentDescList) {
                    List<ContentDescriptor.ContentItem> contentList = contentDesc.getContentList();
                    for (ContentDescriptor.ContentItem c : contentList) {
                        r1.append("Content type: ").append(ContentDescriptor.getContentNibbleLevel1String(c.contentNibbleLevel1())).append(ContentDescriptor.getContentNibbleLevel2String(c.contentNibbleLevel1(), c.contentNibbleLevel2())).append("<br>");
                    }
                }
                r1.append("<br>");
            }
        }

        private static void addComponentDetails(StringBuilder r1, ArrayList<LanguageDependentEitDescriptor> languageList) {
            List<ComponentDescriptor> componentDescriptorList = Descriptor.findGenericDescriptorsInList(languageList, ComponentDescriptor.class);
            for (ComponentDescriptor componentDescriptor : componentDescriptorList) {
                r1.append("Component: ").append(componentDescriptor.getStreamTypeString()).append(", component_tag: ").append(componentDescriptor.getComponentTag()).append(", text: ").append(componentDescriptor.getText().toEscapedHTML()).append("<br>");
            }
        }

        private static void addShortEventDetails(StringBuilder r1, ArrayList<LanguageDependentEitDescriptor> languageList) {
            List<ShortEventDescriptor> shortDesc = Descriptor.findGenericDescriptorsInList(languageList, ShortEventDescriptor.class);
            if (!shortDesc.isEmpty()) {
                for (ShortEventDescriptor shortEventDescriptor : shortDesc) {
                    r1.append("Event name: <b>").append(shortEventDescriptor.getEventName().toEscapedHTML()).append("</b><br>");
                    String shortText = shortEventDescriptor.getText().toEscapedHTML();
                    if (shortText != null && !shortText.isEmpty()) {
                        r1.append("Short description: ").append(shortText).append("<br>");
                    }
                    r1.append("<br>");
                }
            }
        }

        private static void addExtendedEventDetails(StringBuilder r1, ArrayList<LanguageDependentEitDescriptor> languageList) {
            List<ExtendedEventDescriptor> extendedDesc = Descriptor.findGenericDescriptorsInList(languageList, ExtendedEventDescriptor.class);
            ArrayList<DVBString> extendedEventStrings = new ArrayList<DVBString>();
            for (ExtendedEventDescriptor extEvent : extendedDesc) {
                if (!extEvent.getItemList().isEmpty()) {
                    r1.append("<br><table>");
                    for (ExtendedEventDescriptor.Item item : extEvent.getItemList()) {
                        r1.append("<tr><td>").append(item.itemDescription().toEscapedHTML()).append("</td><td>").append(item.item().toEscapedHTML()).append("</td></tr>");
                    }
                    r1.append("</table>");
                }
                extendedEventStrings.add(extEvent.getText());
            }
            if (!extendedEventStrings.isEmpty()) {
                r1.append("<br>Extended description:<br><br>").append(Utils.getEscapedHTML(extendedEventStrings, 80));
                r1.append("<br><br>");
            }
        }

        private static LinkedHashMap<String, ArrayList<LanguageDependentEitDescriptor>> mapDescriptorsByLanguage(List<Descriptor> descList) {
            LinkedHashMap<String, ArrayList<LanguageDependentEitDescriptor>> languageDependentDescriptorsMap = new LinkedHashMap<String, ArrayList<LanguageDependentEitDescriptor>>();
            for (Descriptor d : descList) {
                if (!(d instanceof LanguageDependentEitDescriptor)) continue;
                LanguageDependentEitDescriptor languageDependentEitDescriptor = (LanguageDependentEitDescriptor)d;
                String iso639LanguageCode = languageDependentEitDescriptor.getIso639LanguageCode();
                List lst = languageDependentDescriptorsMap.computeIfAbsent(iso639LanguageCode, s -> new ArrayList());
                lst.add(languageDependentEitDescriptor);
            }
            return languageDependentDescriptorsMap;
        }
    }
}

