/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;

public class GeneralPSITable
extends AbstractPSITabel {
    private final TreeMap<Integer, TreeMap<Integer, TableSection[]>> longSections = new TreeMap();
    private LinkedHashMap<TableSection, TableSection> simpleSectionsd = new LinkedHashMap();
    private List<TableSectionOccurrence> tableSectionOccurrences = new ArrayList<TableSectionOccurrence>();

    public GeneralPSITable(PSI parent) {
        super(parent);
    }

    public void update(TableSection section) {
        int startPacket = section.getPacket_no();
        if (section.sectionSyntaxIndicator == 1) {
            int tableId = section.getTableId();
            TreeMap table = this.longSections.computeIfAbsent(tableId, k -> new TreeMap());
            TableSection[] sections = table.computeIfAbsent(section.getTableIdExtension(), k -> new TableSection[section.getSectionLastNumber() + 1]);
            if (sections.length <= section.getSectionNumber()) {
                sections = Arrays.copyOf(sections, section.getSectionNumber() + 1);
                table.put(section.getTableIdExtension(), sections);
            }
            if (sections[section.getSectionNumber()] == null) {
                sections[section.getSectionNumber()] = section;
                this.tableSectionOccurrences.add(new TableSectionOccurrence(this, startPacket, section));
            } else {
                TableSection last = sections[section.getSectionNumber()];
                TableSection refSection = GeneralPSITable.updateSectionVersion(section, last);
                this.tableSectionOccurrences.add(new TableSectionOccurrence(this, startPacket, refSection));
            }
        } else {
            TableSection existingSection = this.simpleSectionsd.get(section);
            if (existingSection != null) {
                int previousPacketNo = existingSection.getLast_packet_no();
                int distance = section.getPacket_no() - previousPacketNo;
                if ((long)distance > existingSection.getMaxPacketDistance()) {
                    existingSection.setMaxPacketDistance(distance);
                }
                if ((long)distance < existingSection.getMinPacketDistance()) {
                    existingSection.setMinPacketDistance(distance);
                }
                existingSection.setLast_packet_no(section.getPacket_no());
                existingSection.setOccurrence_count(existingSection.getOccurrence_count() + 1);
                this.tableSectionOccurrences.add(new TableSectionOccurrence(this, startPacket, existingSection));
            } else {
                this.simpleSectionsd.put(section, section);
                this.tableSectionOccurrences.add(new TableSectionOccurrence(this, startPacket, section));
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("PSI Data"));
        if (!PreferencesManager.isEnableGenericPSI()) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getErrorKVP("Generic PSI not enabled, select 'Settings -> Enable Generic PSI' to enable ")));
            return t;
        }
        for (Map.Entry<Integer, TreeMap<Integer, TableSection[]>> tableIDSections : this.longSections.entrySet()) {
            int tableId = tableIDSections.getKey();
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new KVP("table_id", tableId, TableSection.getTableType(tableId)));
            TreeMap<Integer, TableSection[]> tableIdExtensionSections = tableIDSections.getValue();
            for (Map.Entry<Integer, TableSection[]> tableIdExtensionSection : tableIdExtensionSections.entrySet()) {
                TableSection[] sections;
                int tableIdExt = tableIdExtensionSection.getKey();
                DefaultMutableTreeNode o = new DefaultMutableTreeNode(new KVP("table_id_extension", tableIdExt, null));
                for (TableSection section : sections = tableIdExtensionSection.getValue()) {
                    if (section == null) continue;
                    if (!Utils.simpleModus(modus)) {
                        GeneralPSITable.addSectionVersionsToJTree(o, section, modus);
                        continue;
                    }
                    o.add(section.getJTreeNode(modus));
                }
                n.add(o);
            }
            t.add(n);
        }
        if (!this.simpleSectionsd.isEmpty()) {
            Utils.addListJTree(t, this.simpleSectionsd.keySet(), modus, "syntax0");
        }
        return t;
    }

    public boolean exists(int tableId, int tableIdExtension, int section) {
        return this.longSections.get(tableId) != null && this.longSections.get(tableId).get(tableIdExtension) != null && this.longSections.get(tableId).get(tableIdExtension).length > section && this.longSections.get(tableId).get(tableIdExtension)[section] != null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.simpleSectionsd == null ? 0 : this.simpleSectionsd.hashCode());
        result = 31 * result + this.longSections.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralPSITable other = (GeneralPSITable)obj;
        if (this.simpleSectionsd == null ? other.simpleSectionsd != null : !this.simpleSectionsd.equals(other.simpleSectionsd)) {
            return false;
        }
        return this.longSections.equals(other.longSections);
    }

    public Map<Integer, TreeMap<Integer, TableSection[]>> getLongSections() {
        return this.longSections;
    }

    public Collection<TableSection> getSimpleSectionsd() {
        return this.simpleSectionsd.keySet();
    }

    public List<TableSectionOccurrence> getTableSectionOccurrences() {
        return this.tableSectionOccurrences;
    }

    public class TableSectionOccurrence {
        private final int packetNo;
        private final TableSection tableSection;

        public TableSectionOccurrence(GeneralPSITable this$0, int packetNo, TableSection tableSection) {
            this.packetNo = packetNo;
            this.tableSection = tableSection;
        }

        public int getPacketNo() {
            return this.packetNo;
        }

        public TableSection getTableSection() {
            return this.tableSection;
        }

        public String toString() {
            return "TableSectionOccurrence [packetNo=" + this.packetNo + ", tableSection=" + String.valueOf(this.tableSection) + "]";
        }
    }
}

