/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CableDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.NetworkNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SatelliteDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TerrestrialDeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.T2DeliverySystemDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.NITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TransportStream;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class NIT
extends AbstractPSITabel {
    private Map<Integer, NITsection[]> networks = new HashMap<Integer, NITsection[]>();

    public NIT(PSI parent) {
        super(parent);
    }

    public void update(NITsection section) {
        int key = section.getNetworkID();
        NITsection[] sections = this.networks.computeIfAbsent(key, k -> new NITsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            NITsection last = sections[section.getSectionNumber()];
            NIT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvpNit = new KVP("NIT");
        if (!this.networks.isEmpty()) {
            kvpNit.addTableSource(this::getTableModel, "Transport Streams");
        }
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(kvpNit);
        TreeSet<Integer> s = new TreeSet<Integer>(this.networks.keySet());
        for (Integer networkNo : s) {
            NITsection[] sections;
            KVP kvp = new KVP("network_id", networkNo, this.getNetworkName(networkNo));
            kvp.addTableSource(() -> this.getTableForNetworkID(networkNo), "Transport Streams");
            kvp.addTableSource(() -> this.getServiceTableForNetworkID(networkNo), "Services");
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(kvp);
            for (NITsection tsection : sections = this.networks.get(networkNo)) {
                if (tsection == null) continue;
                if (!Utils.simpleModus(modus)) {
                    NIT.addSectionVersionsToJTree(n, tsection, modus);
                    continue;
                }
                Utils.addListJTree(n, tsection.getNetworkDescriptorList(), modus, "descriptors");
                Utils.addListJTree(n, tsection.getTransportStreamList(), modus, "transport streams");
            }
            treeNode.add(n);
        }
        return treeNode;
    }

    public String getNetworkName(int networkNo) {
        NITsection[] sections = this.networks.get(networkNo);
        if (sections != null) {
            for (NITsection section : sections) {
                if (section == null) continue;
                for (Descriptor d : section.getNetworkDescriptorList()) {
                    if (!(d instanceof NetworkNameDescriptor)) continue;
                    NetworkNameDescriptor networkNameDescriptor = (NetworkNameDescriptor)d;
                    return networkNameDescriptor.getNetworkNameAsString();
                }
            }
        }
        return null;
    }

    public NITsection[] getNetwork(int networkNo) {
        return this.networks.get(networkNo);
    }

    public Map<Integer, NITsection[]> getNetworks() {
        return this.networks;
    }

    public int getActualNetworkID() {
        TreeSet<Integer> s = new TreeSet<Integer>(this.networks.keySet());
        for (Integer networkNo : s) {
            NITsection[] sections;
            for (NITsection tsection : sections = this.networks.get(networkNo)) {
                if (tsection == null || tsection.getTableId() != 64) continue;
                return networkNo;
            }
        }
        return -1;
    }

    public List<Descriptor> getNetworkDescriptors(int networkNo) {
        ArrayList<Descriptor> res = new ArrayList<Descriptor>();
        NITsection[] sections = this.networks.get(networkNo);
        if (sections != null) {
            for (NITsection tsection : sections) {
                if (tsection == null) continue;
                res.addAll(tsection.getNetworkDescriptorList());
            }
        }
        return res;
    }

    private TableModel getTableForNetworkID(int networkNo) {
        NITsection[] sections;
        FlexTableModel<NITsection, TransportStream> tableModel = new FlexTableModel<NITsection, TransportStream>(NIT.buildNitTableHeader());
        for (NITsection tsection : sections = this.networks.get(networkNo)) {
            if (tsection == null) continue;
            tableModel.addData(tsection, tsection.getTransportStreamList());
        }
        tableModel.process();
        return tableModel;
    }

    public TableModel getTableModel() {
        FlexTableModel<NITsection, TransportStream> tableModel = new FlexTableModel<NITsection, TransportStream>(NIT.buildNitTableHeader());
        for (NITsection[] nitSections : this.networks.values()) {
            for (NITsection tsection : nitSections) {
                if (tsection == null) continue;
                tableModel.addData(tsection, tsection.getTransportStreamList());
            }
        }
        tableModel.process();
        return tableModel;
    }

    private TableModel getServiceTableForNetworkID(int networkNo) {
        NITsection[] sections;
        FlexTableModel<TransportStream, ServiceListDescriptor.Service> tableModel = new FlexTableModel<TransportStream, ServiceListDescriptor.Service>(NIT.buildServiceTableHeader());
        for (NITsection tsection : sections = this.networks.get(networkNo)) {
            if (tsection == null) continue;
            List<TransportStream> tsList = tsection.getTransportStreamList();
            for (TransportStream ts : tsList) {
                List<ServiceListDescriptor> sldList = Descriptor.findGenericDescriptorsInList(ts.descriptorList(), ServiceListDescriptor.class);
                for (ServiceListDescriptor sld : sldList) {
                    tableModel.addData(ts, sld.getServiceList());
                }
            }
        }
        tableModel.process();
        return tableModel;
    }

    static TableHeader<TransportStream, ServiceListDescriptor.Service> buildServiceTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("tsid", TransportStream::transport_stream_id, Integer.class).addRequiredBaseColumn("onid", TransportStream::original_network_id, Integer.class).addRequiredRowColumn("sid", ServiceListDescriptor.Service::getServiceID, Number.class).addRequiredRowColumn("type", ServiceListDescriptor.Service::getServiceType, Integer.class).addRequiredRowColumn("type description", ServiceListDescriptor.Service::getServiceTypeString, String.class).addOptionalRowColumn("name", ServiceListDescriptor.Service::getServiceName, String.class).addOptionalRowColumn("lcn", ServiceListDescriptor.Service::getLCN, Integer.class).build();
    }

    static TableHeader<NITsection, TransportStream> buildNitTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("network_id", NITsection::getNetworkID, Integer.class).addRequiredRowColumn("tsid", TransportStream::transport_stream_id, Integer.class).addRequiredRowColumn("onid", TransportStream::original_network_id, Integer.class).addOptionalRowColumn("terrestrial frequency", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, ter -> Descriptor.formatTerrestrialFrequency(ter.getFrequency())), Number.class).addOptionalRowColumn("terrestrial bandwidth", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, ter -> TerrestrialDeliverySystemDescriptor.getBandwidtString(ter.getBandwidth())), Number.class).addOptionalRowColumn("terrestrial priority", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, ter -> TerrestrialDeliverySystemDescriptor.getPriorityString(ter.getPriority())), String.class).addOptionalRowColumn("terrestrial time_slicing_indicator", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, TerrestrialDeliverySystemDescriptor::getTimeSlicingString), String.class).addOptionalRowColumn("terrestrial MPE-FEC_indicator", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, TerrestrialDeliverySystemDescriptor::getMpeFecString), String.class).addOptionalRowColumn("terrestrial constellation", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, t -> TerrestrialDeliverySystemDescriptor.getConstellationString(t.getConstellation())), String.class).addOptionalRowColumn("terrestrial hierarchy_information", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, t -> TerrestrialDeliverySystemDescriptor.getHierarchyInformationString(t.getHierarchy_information())), String.class).addOptionalRowColumn("terrestrial code_rate-HP_stream", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, t -> TerrestrialDeliverySystemDescriptor.getCodeRateString(t.getCode_rate_HP_stream())), String.class).addOptionalRowColumn("terrestrial code_rate-LP_stream", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, t -> TerrestrialDeliverySystemDescriptor.getCodeRateString(t.getCode_rate_LP_stream())), String.class).addOptionalRowColumn("terrestrial guard_interval", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, t -> TerrestrialDeliverySystemDescriptor.getGuardIntervalString(t.getGuard_interval())), String.class).addOptionalRowColumn("terrestrial transmission_mode", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), TerrestrialDeliverySystemDescriptor.class, t -> TerrestrialDeliverySystemDescriptor.getTransmissionModeString(t.getTransmission_mode())), String.class).addOptionalRowColumn("T2 plp_id", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), T2DeliverySystemDescriptor.class, T2DeliverySystemDescriptor::getPlp_id), Integer.class).addOptionalRowColumn("T2_system_id", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), T2DeliverySystemDescriptor.class, T2DeliverySystemDescriptor::getT2_system_id), Integer.class).addOptionalRowColumn("T2 siso_miso", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), T2DeliverySystemDescriptor.class, t2 -> t2.getDescriptorLength() > 4 ? T2DeliverySystemDescriptor.getSisoMisoModeList().get(t2.getSiso_miso()) : null), String.class).addOptionalRowColumn("T2 bandwidth", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), T2DeliverySystemDescriptor.class, t2 -> t2.getDescriptorLength() > 4 ? T2DeliverySystemDescriptor.getBandwidthList().get(t2.getBandwidth()) : null), Number.class).addOptionalRowColumn("T2 guard_interval", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), T2DeliverySystemDescriptor.class, t2 -> t2.getDescriptorLength() > 4 ? T2DeliverySystemDescriptor.getGuardIntervalList().get(t2.getGuard_interval()) : null), Number.class).addOptionalRowColumn("T2 transmission_mode", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), T2DeliverySystemDescriptor.class, t2 -> t2.getDescriptorLength() > 4 ? T2DeliverySystemDescriptor.getTransmissionModeList().get(t2.getTransmission_mode()) : null), Number.class).addOptionalRowColumn("cable frequency", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), CableDeliverySystemDescriptor.class, cable -> Descriptor.formatCableFrequency(cable.getFrequency())), Number.class).addOptionalRowColumn("cable fec_outter", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), CableDeliverySystemDescriptor.class, CableDeliverySystemDescriptor::getFEC_outerString), String.class).addOptionalRowColumn("cable modulation", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), CableDeliverySystemDescriptor.class, cable -> CableDeliverySystemDescriptor.getModulationString(cable.getModulation())), String.class).addOptionalRowColumn("cable symbol_rate", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), CableDeliverySystemDescriptor.class, cable -> Descriptor.formatSymbolRate(cable.getSymbol_rate())), Number.class).addOptionalRowColumn("cable fec_inner", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), CableDeliverySystemDescriptor.class, cable -> Descriptor.getFEC_innerString(cable.getFEC_inner())), String.class).addOptionalRowColumn("satellite frequency", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.formatSatelliteFrequency(sat.getFrequency())), Number.class).addOptionalRowColumn("satellite orbital_position", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.formatOrbitualPosition(sat.getOrbitalPosition())), Number.class).addOptionalRowColumn("satellite west_east_flag", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, SatelliteDeliverySystemDescriptor::getWestEastFlagString), String.class).addOptionalRowColumn("satellite polarization", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> SatelliteDeliverySystemDescriptor.getPolarizationString(sat.getPolarization())), String.class).addOptionalRowColumn("satellite modulation_system", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, SatelliteDeliverySystemDescriptor::getModulationSystemString), String.class).addOptionalRowColumn("satellite roll_off", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> sat.getModulationSystem() == 1 ? SatelliteDeliverySystemDescriptor.getRollOffString(sat.getRollOff()) : null), Number.class).addOptionalRowColumn("satellite modulation_type", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> SatelliteDeliverySystemDescriptor.getModulationString(sat.getModulationType())), String.class).addOptionalRowColumn("satellite symbol_rate", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.formatSymbolRate(sat.getSymbol_rate())), Number.class).addOptionalRowColumn("satellite fec_inner", transportStream -> Descriptor.findDescriptorApplyFunc(transportStream.descriptorList(), SatelliteDeliverySystemDescriptor.class, sat -> Descriptor.getFEC_innerString(sat.getFEC_inner())), String.class).build();
    }

    public int getOriginalNetworkID(int networkID, int streamID) {
        NITsection[] sections = this.networks.get(networkID);
        if (sections != null) {
            for (NITsection tsection : sections) {
                TransportStream ts;
                if (tsection == null || (ts = tsection.getTransportStream(streamID)) == null) continue;
                return ts.original_network_id();
            }
        }
        return -1;
    }
}

