/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorContext;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.NIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.data.mpeg.psi.TransportStream;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class NITsection
extends TableSectionExtendedSyntax
implements TableSource {
    private List<Descriptor> networkDescriptorList;
    private List<TransportStream> transportStreamList;
    private int networkDescriptorsLength;
    private int transportStreamLoopLength;

    public NITsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.networkDescriptorsLength = Utils.getInt(raw_data.getData(), 8, 2, 4095);
        this.transportStreamLoopLength = Utils.getInt(raw_data.getData(), 10 + this.networkDescriptorsLength, 2, 4095);
        this.networkDescriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 10, this.networkDescriptorsLength, this);
        this.transportStreamList = this.buildTransportStreamList(raw_data.getData(), 12 + this.networkDescriptorsLength, this.transportStreamLoopLength);
    }

    public int getNetworkID() {
        return this.getTableIdExtension();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("NITsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(NITsection.getTableType(this.tableId)).append(", NetworkID=").append(this.getNetworkID()).append(", ");
        return b.toString();
    }

    public List<Descriptor> getNetworkDescriptorList() {
        return this.networkDescriptorList;
    }

    public void setNetworkDescriptorList(List<Descriptor> networkDescriptorList) {
        this.networkDescriptorList = networkDescriptorList;
    }

    public int getNetworkDescriptorsLength() {
        return this.networkDescriptorsLength;
    }

    public void setNetworkDescriptorsLength(int networkDescriptorsLength) {
        this.networkDescriptorsLength = networkDescriptorsLength;
    }

    public List<TransportStream> getTransportStreamList() {
        return this.transportStreamList;
    }

    public TransportStream getTransportStream(int streamID) {
        for (TransportStream tStream : this.transportStreamList) {
            if (tStream.transport_stream_id() != streamID) continue;
            return tStream;
        }
        return null;
    }

    public void setTransportStreamList(List<TransportStream> transportStreamList) {
        this.transportStreamList = transportStreamList;
    }

    public int getTransportStreamLoopLength() {
        return this.transportStreamLoopLength;
    }

    public int noTransportStreams() {
        return this.transportStreamList.size();
    }

    public void setTransportStreamLoopLength(int transportStreamLoopLength) {
        this.transportStreamLoopLength = transportStreamLoopLength;
    }

    private List<TransportStream> buildTransportStreamList(byte[] data, int i, int programInfoLength) {
        int transport_descriptors_length;
        ArrayList<TransportStream> r = new ArrayList<TransportStream>();
        for (int t = 0; t < programInfoLength; t += 6 + transport_descriptors_length) {
            int transport_stream_id = Utils.getInt(data, i + t, 2, 65535);
            int original_network_id = Utils.getInt(data, i + t + 2, 2, 65535);
            transport_descriptors_length = Utils.getInt(data, i + t + 4, 2, 4095);
            DescriptorContext dc = new DescriptorContext(original_network_id, transport_stream_id, this.getNetworkID());
            List<Descriptor> descriptorList = DescriptorFactory.buildDescriptorList(data, i + t + 6, transport_descriptors_length, this, dc);
            r.add(new TransportStream(transport_stream_id, original_network_id, transport_descriptors_length, descriptorList));
        }
        return r;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        KVP kvp = (KVP)t.getUserObject();
        kvp.addTableSource(this, "Transport Streams");
        kvp.addTableSource(this::getServicesTableD, "Services");
        t.add(new DefaultMutableTreeNode(new KVP("network_descriptors_length", this.getNetworkDescriptorsLength(), null)));
        Utils.addListJTree(t, this.networkDescriptorList, modus, "network_descriptors");
        t.add(new DefaultMutableTreeNode(new KVP("transport_stream_loop_length", this.getTransportStreamLoopLength(), null)));
        Utils.addListJTree(t, this.transportStreamList, modus, "transport_stream_loop");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "network_id";
    }

    private TableModel getServicesTableD() {
        FlexTableModel<TransportStream, ServiceListDescriptor.Service> tableModel = new FlexTableModel<TransportStream, ServiceListDescriptor.Service>(NIT.buildServiceTableHeader());
        for (TransportStream ts : this.getTransportStreamList()) {
            List<ServiceListDescriptor> sldList = Descriptor.findGenericDescriptorsInList(ts.descriptorList(), ServiceListDescriptor.class);
            for (ServiceListDescriptor sld : sldList) {
                tableModel.addData(ts, sld.getServiceList());
            }
        }
        tableModel.process();
        return tableModel;
    }

    @Override
    public TableModel getTableModel() {
        FlexTableModel<NITsection, TransportStream> tableModel = new FlexTableModel<NITsection, TransportStream>(NIT.buildNitTableHeader());
        tableModel.addData(this, this.getTransportStreamList());
        tableModel.process();
        return tableModel;
    }
}

