/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.ComponentType;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ApplicationSignallingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ISO639LanguageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.StreamIdentifierDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SubtitlingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TeletextDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;
import nl.digitalekabeltelevisie.util.tablemodel.cellrenderer.StreamTypeTableCellRenderer;

public class PMTs
extends AbstractPSITabel
implements Iterable<PMTsection[]> {
    private final Map<Integer, PMTsection[]> pmts = new HashMap<Integer, PMTsection[]>();

    public PMTs(PSI parentPSI) {
        super(parentPSI);
    }

    public void update(PMTsection section) {
        int programNumber = section.getProgramNumber();
        PMTsection[] sections = this.pmts.computeIfAbsent(programNumber, k -> new PMTsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            PMTsection last = sections[section.getSectionNumber()];
            PMTs.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("PMTs"));
        TreeSet<Integer> serviceIds = new TreeSet<Integer>(this.pmts.keySet());
        for (Integer programNumber : serviceIds) {
            PMTsection[] sections = this.pmts.get(programNumber);
            KVP kvp = new KVP("program", programNumber, this.getParentPSI().getSdt().getServiceNameForActualTransportStream(programNumber));
            kvp.addTableSource(() -> this.getTableForProgram(programNumber), "Components");
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(kvp);
            for (PMTsection pmtSection : sections) {
                if (pmtSection == null) continue;
                if (Utils.simpleModus(modus)) {
                    treeNode.add(new DefaultMutableTreeNode(new KVP("PCR_PID", pmtSection.getPcrPid(), null)));
                    Utils.addListJTree(treeNode, pmtSection.getDescriptorList(), modus, "program_info");
                    Utils.addListJTree(treeNode, pmtSection.getComponentenList(), modus, "components");
                    continue;
                }
                PMTs.addSectionVersionsToJTree(treeNode, pmtSection, modus);
            }
            t.add(treeNode);
        }
        return t;
    }

    static TableHeader<PMTsection, PMTsection.Component> buildPmtTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("program number", PMTsection::getProgramNumber, Integer.class).addOptionalRowColumn("stream type", PMTsection.Component::getStreamtype, StreamTypeTableCellRenderer.class).addOptionalRowColumn("usage", component -> TransportStream.determineComponentType(component.getComponentDescriptorList()).map(ComponentType::getDescription).orElse(Utils.getStreamTypeShortString(component.getStreamtype())), String.class).addOptionalRowColumn("elementary PID", PMTsection.Component::getElementaryPID, Integer.class).addOptionalRowColumn("component tag", component -> Descriptor.findDescriptorApplyFunc(component.getComponentDescriptorList(), StreamIdentifierDescriptor.class, StreamIdentifierDescriptor::getComponentTag), Integer.class).addOptionalRepeatingGroupedColumn("iso language", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), ISO639LanguageDescriptor.class, iso -> iso.getLanguageList().stream().map(ISO639LanguageDescriptor.Language::getIso639LanguageCode).collect(Collectors.toList())), String.class, "iso").addOptionalRepeatingGroupedColumn("iso type", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), ISO639LanguageDescriptor.class, iso -> iso.getLanguageList().stream().map(language -> ISO639LanguageDescriptor.getAudioTypeString(language.getAudioType())).collect(Collectors.toList())), String.class, "iso").addOptionalRepeatingGroupedColumn("teletext language", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), TeletextDescriptor.class, ttd -> ttd.getTeletextList().stream().map(TeletextDescriptor.Teletext::getIso639LanguageCode).collect(Collectors.toList())), String.class, "ttx").addOptionalRepeatingGroupedColumn("teletext type", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), TeletextDescriptor.class, teletextDescriptor -> teletextDescriptor.getTeletextList().stream().map(t -> TeletextDescriptor.getTeletextTypeString(t.getTeletextType())).collect(Collectors.toList())), String.class, "ttx").addOptionalRepeatingGroupedColumn("subtitle language", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), SubtitlingDescriptor.class, sub -> sub.getSubtitleList().stream().map(SubtitlingDescriptor.Subtitle::getIso639LanguageCode).collect(Collectors.toList())), String.class, "sub").addOptionalRepeatingGroupedColumn("subtitle type", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), SubtitlingDescriptor.class, sub -> sub.getSubtitleList().stream().map(t -> Descriptor.getComponentType0x03String(t.getSubtitlingType())).collect(Collectors.toList())), String.class, "sub").addOptionalRepeatingRowColumn("application type", component -> Descriptor.findDescriptorApplyListFunc(component.getComponentDescriptorList(), ApplicationSignallingDescriptor.class, app -> app.getApplicationTypeList().stream().map(a -> Utils.getAppTypeIDString(a.getApplicationType())).collect(Collectors.toList())), String.class).build();
    }

    private TableModel getTableForProgram(int programNumber) {
        PMTsection[] sections;
        FlexTableModel<PMTsection, PMTsection.Component> tableModel = new FlexTableModel<PMTsection, PMTsection.Component>(PMTs.buildPmtTableHeader());
        for (PMTsection pmtSection : sections = this.pmts.get(programNumber)) {
            if (pmtSection == null) continue;
            tableModel.addData(pmtSection, pmtSection.getComponentenList());
        }
        tableModel.process();
        return tableModel;
    }

    public int getPmtPID(int programNumber) {
        PMTsection[] sections;
        for (PMTsection section : sections = this.pmts.get(programNumber)) {
            if (section == null) continue;
            return section.getParentPID().getPid();
        }
        return -1;
    }

    public List<PMTsection> findPMTsFromComponentPID(int pid) {
        ArrayList<PMTsection> result = new ArrayList<PMTsection>();
        block0: for (PMTsection[] pmtArray : this.pmts.values()) {
            PMTsection p = pmtArray[0];
            for (PMTsection.Component component : p.getComponentenList()) {
                if (component.getElementaryPID() != pid) continue;
                result.add(p);
                continue block0;
            }
        }
        return result;
    }

    public PMTsection getPmt(int programNumber) {
        return this.pmts.get(programNumber)[0];
    }

    @Override
    public Iterator<PMTsection[]> iterator() {
        return this.pmts.values().iterator();
    }

    public Map<Integer, PMTsection[]> getPmts() {
        return this.pmts;
    }
}

