/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class PMTsection
extends TableSectionExtendedSyntax {
    private int pcrPid = 0;
    private int programInfoLength = 0;
    private List<Descriptor> descriptorList;
    private final List<Component> componentsList;

    private List<Component> buildComponentList(byte[] data, int i, int length) {
        Component c;
        ArrayList<Component> r = new ArrayList<Component>();
        for (int t = 0; t < length; t += 5 + c.getEsInfoLength()) {
            c = new Component();
            c.setStreamtype(Byte.toUnsignedInt(data[i + t]));
            c.setElementaryPID(256 * (Byte.toUnsignedInt(data[i + t + 1]) & 0x1F) + Byte.toUnsignedInt(data[i + t + 2]));
            c.setEsInfoLength(256 * (Byte.toUnsignedInt(data[i + t + 3]) & 0xF) + Byte.toUnsignedInt(data[i + t + 4]));
            c.setComponentDescriptorList(DescriptorFactory.buildDescriptorList(data, i + t + 5, c.getEsInfoLength(), this));
            r.add(c);
        }
        return r;
    }

    public PMTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.pcrPid = Utils.getInt(raw_data.getData(), 8, 2, 8191);
        this.programInfoLength = Utils.getInt(raw_data.getData(), 10, 2, 4095);
        this.descriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 12, this.programInfoLength, this);
        this.componentsList = this.buildComponentList(raw_data.getData(), 12 + this.programInfoLength, raw_data.getNoBytes() - 16 - this.programInfoLength);
    }

    public int getProgramNumber() {
        return this.getTableIdExtension();
    }

    public int noStreams() {
        return this.componentsList.size();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("PMTsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", program_number=").append(this.getProgramNumber()).append(", ").append(", PMT_PID:").append(this.getParentPID().getPid());
        return b.toString();
    }

    public int getPcrPid() {
        return this.pcrPid;
    }

    public void setPcrPid(int pcrPid) {
        this.pcrPid = pcrPid;
    }

    public List<Descriptor> getDescriptorList() {
        return this.descriptorList;
    }

    public void setDescriptorList(List<Descriptor> descriptorList) {
        this.descriptorList = descriptorList;
    }

    public int getProgramInfoLength() {
        return this.programInfoLength;
    }

    public void setProgramInfoLength(int programInfoLength) {
        this.programInfoLength = programInfoLength;
    }

    public List<Component> getComponentenList() {
        return this.componentsList;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        KVP kvp = (KVP)t.getUserObject();
        kvp.addTableSource(this::getTableModel, "Components");
        t.add(new DefaultMutableTreeNode(new KVP("PMT_PID", this.getParentPID().getPid(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("PCR_PID", this.pcrPid, null)));
        t.add(new DefaultMutableTreeNode(new KVP("program_info_length", this.programInfoLength, null)));
        Utils.addListJTree(t, this.descriptorList, modus, "program_info");
        Utils.addListJTree(t, this.componentsList, modus, "components");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "program_number";
    }

    public TableModel getTableModel() {
        FlexTableModel<PMTsection, Component> tableModel = new FlexTableModel<PMTsection, Component>(PMTs.buildPmtTableHeader());
        tableModel.addData(this, this.getComponentenList());
        tableModel.process();
        return tableModel;
    }

    public boolean hasComponentWithPid(int pid) {
        for (Component component : this.componentsList) {
            if (component.getElementaryPID() != pid) continue;
            return true;
        }
        return false;
    }

    public static class Component
    implements TreeNode {
        private int streamtype;
        private int elementaryPID;
        private int esInfoLength;
        private List<Descriptor> componentDescriptorList;

        public String getStreamTypeString() {
            return Utils.getStreamTypeString(this.streamtype);
        }

        public int getElementaryPID() {
            return this.elementaryPID;
        }

        public void setElementaryPID(int elementaryPID) {
            this.elementaryPID = elementaryPID;
        }

        public int getEsInfoLength() {
            return this.esInfoLength;
        }

        public void setEsInfoLength(int infoLength) {
            this.esInfoLength = infoLength;
        }

        public int getStreamtype() {
            return this.streamtype;
        }

        public void setStreamtype(int streamtype) {
            this.streamtype = streamtype;
        }

        public List<Descriptor> getComponentDescriptorList() {
            return this.componentDescriptorList;
        }

        public void setComponentDescriptorList(List<Descriptor> descriptorList) {
            this.componentDescriptorList = descriptorList;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Component stream type=");
            b.append(this.getStreamtype()).append(" (").append(this.getStreamTypeString()).append("), ElementaryPID=").append(this.getElementaryPID()).append(", ");
            for (Descriptor d : this.componentDescriptorList) {
                b.append(d).append(", ");
            }
            return b.toString();
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("component (" + Utils.getStreamTypeString(this.streamtype) + ")"));
            t.add(new DefaultMutableTreeNode(new KVP("stream_type", this.streamtype, Utils.getStreamTypeString(this.streamtype))));
            t.add(new DefaultMutableTreeNode(new KVP("elementary_PID", this.elementaryPID, null)));
            t.add(new DefaultMutableTreeNode(new KVP("ES_info_length", this.esInfoLength, null)));
            Utils.addListJTree(t, this.componentDescriptorList, modus, "component_descriptors");
            return t;
        }
    }
}

