/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class RCTsection
extends TableSectionExtendedSyntax {
    private static final LookUpList link_type_list = new LookUpList.Builder().add(0, "Link information is a URI string only").add(1, "Link information is a binary locator only").add(2, "Link information is both a binary locator and a URI string").add(3, "Link information is through means of a descriptor").add(4, 15, "DVB reserved").build();
    private static final LookUpList how_related_classification_scheme_id_list = new LookUpList.Builder().add(0, "urn:tva:metadata:HowRelatedCS:2004 [25], clause A.3.").add(1, "urn:tva:metadata:HowRelatedCS:2005 [26], clause A.3.").add(2, "urn:tva:metadata:HowRelatedCS:2007 [4], clause A.3.").add(3, 47, "DVB reserved").add(48, 63, "User Private").build();
    private final int year_offset;
    private final int link_count;
    private final int descriptor_loop_length;
    private final List<Descriptor> descriptor_loop;
    private final List<LinkInfo> links = new ArrayList<LinkInfo>();

    public RCTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        byte[] b = raw_data.getData();
        this.year_offset = Utils.getInt(b, 8, 2, 65535);
        this.link_count = Utils.getInt(b, 10, 1, 255);
        int localOffset = 11;
        for (int i = 0; i < this.link_count; ++i) {
            int link_info_length = Utils.getInt(b, localOffset, 2, 4095);
            LinkInfo linkInfo = new LinkInfo(this, b, localOffset + 2, link_info_length);
            this.links.add(linkInfo);
            localOffset += 2 + link_info_length;
        }
        this.descriptor_loop_length = Utils.getInt(b, localOffset, 2, 4095);
        this.descriptor_loop = DescriptorFactory.buildDescriptorList(b, localOffset += 2, this.descriptor_loop_length, this);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("AITsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(RCTsection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("year_offset", this.year_offset));
        t.add(new KVP("link_count", this.link_count));
        Utils.addListJTree(t, this.links, modus, "link_infos");
        t.add(new KVP("descriptor_loop_length", this.descriptor_loop_length));
        Utils.addListJTree(t, this.descriptor_loop, modus, "descriptor_loop");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "service_id";
    }

    public class LinkInfo
    implements TreeNode {
        private final int len;
        private final int link_type;
        private final int how_related_classification_scheme_id;
        private final int term_id;
        private final int group_id;
        private final int precedence;
        private int media_uri_length;
        private byte[] media_uri_byte;
        private final int number_items;
        private final List<PromotionalText> promotional_items = new ArrayList<PromotionalText>();
        private final int default_icon_flag;
        private final int icon_id;
        private final int descriptor_loop_length;
        private final List<Descriptor> descriptor_loop;

        protected LinkInfo(RCTsection this$0, byte[] data, int offset, int len) {
            this.len = len;
            BitSource bs = new BitSource(data, offset, len);
            this.link_type = bs.readBits(4);
            bs.readBits(2);
            this.how_related_classification_scheme_id = bs.readBits(6);
            this.term_id = bs.readBits(12);
            this.group_id = bs.readBits(4);
            this.precedence = bs.readBits(4);
            if (this.link_type == 0 || this.link_type == 2) {
                this.media_uri_length = bs.readBits(8);
                this.media_uri_byte = bs.readBytes(this.media_uri_length);
            }
            if (this.link_type == 1 || this.link_type == 2) {
                throw new RuntimeException("Unimplemented dvb_binary_locator()");
            }
            bs.readBits(2);
            this.number_items = bs.readBits(6);
            for (int k = 0; k < this.number_items; ++k) {
                byte[] iso_639_2_language_code = bs.readBytes(3);
                DVBString promotional_text_char = bs.readDVBString();
                PromotionalText pt = new PromotionalText(new String(iso_639_2_language_code), promotional_text_char);
                this.promotional_items.add(pt);
            }
            this.default_icon_flag = bs.readBits(1);
            this.icon_id = bs.readBits(3);
            this.descriptor_loop_length = bs.readBits(12);
            byte[] descriptorData = bs.readBytes(this.descriptor_loop_length);
            this.descriptor_loop = DescriptorFactory.buildDescriptorList(descriptorData, 0, this.descriptor_loop_length, this$0);
        }

        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("link_info");
            t.add(new KVP("link_info_length", this.len));
            t.add(new KVP("link_type", this.link_type).setDescription(link_type_list.get(this.link_type)));
            t.add(new KVP("how_related_classification_scheme_id", this.how_related_classification_scheme_id).setDescription(how_related_classification_scheme_id_list.get(this.how_related_classification_scheme_id)));
            t.add(new KVP("term_id", this.term_id));
            t.add(new KVP("group_id", this.group_id));
            t.add(new KVP("precedence", this.precedence));
            t.add(new KVP("media_uri_length", this.media_uri_length));
            t.add(new KVP("media_uri_byte", this.media_uri_byte));
            t.add(new KVP("number_items", this.number_items));
            Utils.addListJTree(t, this.promotional_items, modus, "Promotional text Items");
            t.add(new KVP("default_icon_flag", this.default_icon_flag));
            t.add(new KVP("icon_id", this.icon_id));
            t.add(new KVP("descriptor_loop_length", this.descriptor_loop_length));
            Utils.addListJTree(t, this.descriptor_loop, modus, "descriptor_loop");
            return t;
        }

        public record PromotionalText(String iso639LanguageCode, DVBString promotional_text) implements TreeNode
        {
            @Override
            public KVP getJTreeNode(int modus) {
                KVP t = new KVP("promotional_text");
                t.add(new KVP("ISO 639-2_language_code", this.iso639LanguageCode));
                t.add(new KVP("promotional_text", this.promotional_text));
                return t;
            }
        }
    }
}

