/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSections;

public class SCTE35
extends AbstractPSITabel {
    private final Map<Integer, SpliceInfoSections> spliceSections = new HashMap<Integer, SpliceInfoSections>();

    public SCTE35(PSI parentPSI) {
        super(parentPSI);
    }

    public void update(SpliceInfoSection section) {
        int pid = section.getParentPID().getPid();
        SpliceInfoSections sections = this.spliceSections.get(pid);
        if (sections == null) {
            sections = new SpliceInfoSections(this.parentPSI);
            this.spliceSections.put(pid, sections);
        }
        sections.update(section);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("SCTE-35"));
        TreeSet<Integer> s = new TreeSet<Integer>(this.spliceSections.keySet());
        for (Integer pid : s) {
            SpliceInfoSections sections = this.spliceSections.get(pid);
            t.add(sections.getJTreeNode(modus));
        }
        return t;
    }

    public SpliceInfoSections getSpliceInfoSections(int pid) {
        return this.spliceSections.get(pid);
    }
}

