/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.SDTsection;
import nl.digitalekabeltelevisie.util.ServiceIdentification;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class SDT
extends AbstractPSITabel {
    private final Map<Integer, HashMap<Integer, SDTsection[]>> networks = new HashMap<Integer, HashMap<Integer, SDTsection[]>>();
    private SDTsection[] actualTransportStreamSDT;

    public SDT(PSI parentPSI) {
        super(parentPSI);
    }

    public void update(SDTsection section) {
        int original_network_id = section.getOriginalNetworkID();
        int streamId = section.getTransportStreamID();
        Map networkSections = this.networks.computeIfAbsent(original_network_id, HashMap::new);
        SDTsection[] tsSections = networkSections.computeIfAbsent(streamId, k -> new SDTsection[section.getSectionLastNumber() + 1]);
        SDT.addSectionToArray(section, tsSections);
        if (section.getTableId() == 66) {
            this.actualTransportStreamSDT = tsSections;
        }
    }

    private static void addSectionToArray(SDTsection section, SDTsection[] tsSections) {
        if (tsSections[section.getSectionNumber()] == null) {
            tsSections[section.getSectionNumber()] = section;
        } else {
            SDTsection last = tsSections[section.getSectionNumber()];
            SDT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP sdtKvp = new KVP("SDT");
        if (!this.networks.isEmpty()) {
            sdtKvp.addTableSource(this::getTableForSdt, "SDT");
        }
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(sdtKvp);
        TreeSet<Integer> networksTreeSet = new TreeSet<Integer>(this.networks.keySet());
        for (Integer orgNetworkId : networksTreeSet) {
            Map networkSections = this.networks.get(orgNetworkId);
            KVP kvpOrgNetwork = new KVP("original_network_id", orgNetworkId, Utils.getOriginalNetworkIDString(orgNetworkId));
            kvpOrgNetwork.addTableSource(() -> this.getTableForOriginalNetwork(orgNetworkId), "SDT original_network_id: " + orgNetworkId);
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(kvpOrgNetwork);
            t.add(n);
            TreeSet streamsTreeSet = new TreeSet(networkSections.keySet());
            for (Integer transport_stream_id : streamsTreeSet) {
                SDTsection[] sections = (SDTsection[])networkSections.get(transport_stream_id);
                KVP kvpTsId = new KVP("transport_stream_id", transport_stream_id, null);
                kvpTsId.addTableSource(() -> this.getTableForTransportStreamID(orgNetworkId, transport_stream_id), "SDT transport_stream_id: " + transport_stream_id);
                DefaultMutableTreeNode m = new DefaultMutableTreeNode(kvpTsId);
                n.add(m);
                for (SDTsection section : sections) {
                    if (section == null) continue;
                    if (!Utils.simpleModus(modus)) {
                        SDT.addSectionVersionsToJTree(m, section, modus);
                        continue;
                    }
                    Utils.addListJTree(m, section.getServiceList(), modus, "services");
                }
            }
        }
        return t;
    }

    public Optional<String> getServiceNameForActualTransportStreamOptional(int serviceID) {
        return this.getServiceNameForActualTransportStreamDVBString(serviceID).map(DVBString::toString);
    }

    public String getServiceNameForActualTransportStream(int serviceID) {
        return this.getServiceNameForActualTransportStreamOptional(serviceID).orElse(null);
    }

    public Optional<DVBString> getServiceNameForActualTransportStreamDVBString(int serviceID) {
        return this.getServiceForActualTransportStream(serviceID).map(SDTsection.Service::getDescriptorList).orElseGet(ArrayList::new).stream().filter(ServiceDescriptor.class::isInstance).map(ServiceDescriptor.class::cast).findFirst().map(ServiceDescriptor::getServiceName);
    }

    public String getServiceName(int original_network_id, int transport_stream_id, int serviceID) {
        return this.getServiceNameDVBString(original_network_id, transport_stream_id, serviceID).map(DVBString::toString).orElse(null);
    }

    public Optional<DVBString> getServiceNameDVBString(ServiceIdentification serviceIdentification) {
        return this.getServiceNameDVBString(serviceIdentification.originalNetworkId(), serviceIdentification.transportStreamId(), serviceIdentification.serviceId());
    }

    public Optional<DVBString> getServiceNameDVBString(int original_network_id, int transport_stream_id, int serviceID) {
        return this.getService(original_network_id, transport_stream_id, serviceID).map(SDTsection.Service::getDescriptorList).orElseGet(ArrayList::new).stream().filter(ServiceDescriptor.class::isInstance).map(ServiceDescriptor.class::cast).findFirst().map(ServiceDescriptor::getServiceName);
    }

    public Optional<SDTsection.Service> getService(int orgNetworkId, int transportStreamID, int serviceID) {
        SDTsection[] sections;
        HashMap<Integer, SDTsection[]> transportStreams = this.networks.get(orgNetworkId);
        if (transportStreams != null && (sections = transportStreams.get(transportStreamID)) != null) {
            for (SDTsection section : sections) {
                if (section == null) continue;
                for (SDTsection.Service service : section.getServiceList()) {
                    if (service.getServiceID() != serviceID) continue;
                    return Optional.of(service);
                }
            }
        }
        return Optional.empty();
    }

    public int getOrgNetworkForActualTransportStream() {
        if (this.actualTransportStreamSDT != null) {
            SDTsection[] sections;
            for (SDTsection section : sections = this.actualTransportStreamSDT) {
                if (section == null) continue;
                return section.getOriginalNetworkID();
            }
        }
        return -1;
    }

    public Optional<SDTsection.Service> getServiceForActualTransportStream(int serviceID) {
        if (this.actualTransportStreamSDT != null) {
            SDTsection[] sections;
            for (SDTsection section : sections = this.actualTransportStreamSDT) {
                if (section == null) continue;
                for (SDTsection.Service service : section.getServiceList()) {
                    if (service.getServiceID() != serviceID) continue;
                    return Optional.of(service);
                }
            }
        }
        return Optional.empty();
    }

    public int getTransportStreamID(int serviceID) {
        TreeSet<Integer> t = new TreeSet<Integer>(this.networks.keySet());
        for (int orgNetworkId : t) {
            HashMap<Integer, SDTsection[]> transportStreams = this.networks.get(orgNetworkId);
            TreeSet<Integer> s = new TreeSet<Integer>(transportStreams.keySet());
            for (Integer transportStreamID : s) {
                SDTsection[] sections = transportStreams.get(transportStreamID);
                if (sections == null) continue;
                for (SDTsection section : sections) {
                    if (section == null) continue;
                    for (SDTsection.Service service : section.getServiceList()) {
                        if (serviceID != service.getServiceID()) continue;
                        return transportStreamID;
                    }
                }
            }
        }
        return -1;
    }

    static TableHeader<SDTsection, SDTsection.Service> buildSdtTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("onid", SDTsection::getOriginalNetworkID, Integer.class).addRequiredBaseColumn("tsid", SDTsection::getTransportStreamID, Integer.class).addOptionalRowColumn("sid", SDTsection.Service::getServiceID, Integer.class).addOptionalRowColumn("service_name", service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), ServiceDescriptor.class, sd -> sd.getServiceName().toString()), String.class).addOptionalRowColumn("service_type", service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), ServiceDescriptor.class, ServiceDescriptor::getServiceType), Integer.class).addOptionalRowColumn("service_type description", service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), ServiceDescriptor.class, sd -> Descriptor.getServiceTypeString(sd.getServiceType())), String.class).addOptionalRowColumn("service_provider_name", service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), ServiceDescriptor.class, sd -> sd.getServiceProviderName().toString()), String.class).addOptionalRowColumn("EIT_schedule_flag", SDTsection.Service::getEitScheduleFlag, Integer.class).addOptionalRowColumn("EIT_present_following_flag", SDTsection.Service::getEitPresentFollowingFlag, Integer.class).addOptionalRowColumn("running_status", SDTsection.Service::getRunningStatus, Integer.class).addOptionalRowColumn("free_CA_mode", SDTsection.Service::getFreeCAmode, Integer.class).build();
    }

    private TableModel getTableForTransportStreamID(int orgNetworkId, int tsId) {
        FlexTableModel<SDTsection, SDTsection.Service> tableModel = new FlexTableModel<SDTsection, SDTsection.Service>(SDT.buildSdtTableHeader());
        SDTsection[] sections = this.networks.get(orgNetworkId).get(tsId);
        SDT.fillTableForTsSDT(tableModel, sections);
        tableModel.process();
        return tableModel;
    }

    private TableModel getTableForOriginalNetwork(int orgNetworkId) {
        FlexTableModel<SDTsection, SDTsection.Service> tableModel = new FlexTableModel<SDTsection, SDTsection.Service>(SDT.buildSdtTableHeader());
        HashMap<Integer, SDTsection[]> networkSDT = this.networks.get(orgNetworkId);
        SDT.fillTableForNetworkSDT(tableModel, networkSDT);
        tableModel.process();
        return tableModel;
    }

    private TableModel getTableForSdt() {
        FlexTableModel<SDTsection, SDTsection.Service> tableModel = new FlexTableModel<SDTsection, SDTsection.Service>(SDT.buildSdtTableHeader());
        this.networks.values().forEach(s -> SDT.fillTableForNetworkSDT(tableModel, s));
        tableModel.process();
        return tableModel;
    }

    private static void fillTableForNetworkSDT(FlexTableModel<SDTsection, SDTsection.Service> tableModel, HashMap<Integer, SDTsection[]> networkSDT) {
        networkSDT.values().forEach(s -> SDT.fillTableForTsSDT(tableModel, s));
    }

    private static void fillTableForTsSDT(FlexTableModel<SDTsection, SDTsection.Service> tableModel, SDTsection[] tsSDT) {
        for (SDTsection tsection : tsSDT) {
            if (tsection == null) continue;
            tableModel.addData(tsection, tsection.getServiceList());
        }
    }
}

