/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class SpliceInfoSection
extends TableSection {
    private static final Logger logger = Logger.getLogger(SpliceInfoSection.class.getName());
    private int protocol_version;
    private int encrypted_packet;
    private int encryption_algorithm;
    private long pts_adjustment;
    private int cw_index;
    private int tier;
    private int splice_command_length;
    private int splice_command_type;
    private int descriptor_loop_length;
    List<Descriptor> splice_descriptors = new ArrayList<Descriptor>();
    private TreeNode splice_command;

    public SpliceInfoSection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        byte[] data = raw_data.getData();
        BitSource bitSource = new BitSource(data, 3, this.sectionLength);
        this.protocol_version = bitSource.readBits(8);
        this.encrypted_packet = bitSource.readBits(1);
        this.encryption_algorithm = bitSource.readBits(6);
        this.pts_adjustment = bitSource.readBitsLong(33);
        this.cw_index = bitSource.readBits(8);
        this.tier = bitSource.readBits(12);
        this.splice_command_length = bitSource.readBits(12);
        if (this.encrypted_packet == 0) {
            this.splice_command_type = bitSource.readBits(8);
            if (this.splice_command_type == 0) {
                this.splice_command = new SpliceNull(bitSource);
            } else if (this.splice_command_type == 5) {
                this.splice_command = new SpliceInsert(this, bitSource);
            } else if (this.splice_command_type == 6) {
                this.splice_command = new TimeSignal(this, bitSource);
            } else if (this.splice_command_type == 7) {
                this.splice_command = new BandwidthReservation(bitSource);
            } else {
                logger.info("Not implemented: splice_command_type=" + this.splice_command_type + " (" + SpliceInfoSection.getSpliceCommandTypeString(this.splice_command_type) + ")");
            }
            int loopstart = 0;
            if (this.splice_command_type == 0 || this.splice_command_type == 5 || this.splice_command_type == 7) {
                loopstart = bitSource.getNextFullByteOffset();
            } else if (this.splice_command_length != 4095) {
                loopstart = 14 + this.splice_command_length;
            }
            if (loopstart != 0) {
                this.descriptor_loop_length = Utils.getInt(data, loopstart, 2, 4095);
                this.splice_descriptors = DescriptorFactory.buildDescriptorList(data, loopstart + 2, this.descriptor_loop_length, this);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("protocol_version", this.protocol_version, null)));
        t.add(new DefaultMutableTreeNode(new KVP("encrypted_packet", this.encrypted_packet, this.encrypted_packet == 1 ? "portions of the splice_info_section, starting with splice_command_type and ending with and including E_CRC_32, are encrypted" : "no part of this message is encrypted")));
        t.add(new DefaultMutableTreeNode(new KVP("encryption_algorithm", this.encryption_algorithm, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pts_adjustment", this.pts_adjustment, null)));
        t.add(new DefaultMutableTreeNode(new KVP("cw_index", this.cw_index, null)));
        t.add(new DefaultMutableTreeNode(new KVP("tier", this.tier, null)));
        t.add(new DefaultMutableTreeNode(new KVP("splice_command_length", this.splice_command_length, this.splice_command_length == 4095 ? "The value of 0xFFF provides backwards compatibility and shall be ignored by downstream equipment" : null)));
        if (this.encrypted_packet == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("splice_command_type", this.splice_command_type, SpliceInfoSection.getSpliceCommandTypeString(this.splice_command_type))));
            if (this.splice_command_type == 0) {
                t.add(this.splice_command.getJTreeNode(modus));
            } else if (this.splice_command_type == 5) {
                t.add(this.splice_command.getJTreeNode(modus));
            } else if (this.splice_command_type == 6) {
                t.add(this.splice_command.getJTreeNode(modus));
            } else if (this.splice_command_type == 7) {
                t.add(this.splice_command.getJTreeNode(modus));
            } else {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("splice_command_type =" + this.splice_command_type + " (" + SpliceInfoSection.getSpliceCommandTypeString(this.splice_command_type) + ")")));
                return t;
            }
            t.add(new DefaultMutableTreeNode(new KVP("descriptor_loop_length", this.descriptor_loop_length, null)));
            Utils.addListJTree(t, this.splice_descriptors, modus, "splice_descriptors");
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("this portion of the splice_info_section, starting with splice_command_type and ending with and including E_CRC_32, is encrypted")));
        }
        return t;
    }

    private static String getSpliceCommandTypeString(int splice_command_type) {
        switch (splice_command_type) {
            case 0: {
                return "splice_null";
            }
            case 4: {
                return "splice_schedule";
            }
            case 5: {
                return "splice_insert";
            }
            case 6: {
                return "time_signal";
            }
            case 7: {
                return "bandwidth_reservation";
            }
            case 255: {
                return "private_command";
            }
        }
        return "Reserved";
    }

    public int getProtocol_version() {
        return this.protocol_version;
    }

    public int getEncrypted_packet() {
        return this.encrypted_packet;
    }

    public int getEncryption_algorithm() {
        return this.encryption_algorithm;
    }

    public long getPts_adjustment() {
        return this.pts_adjustment;
    }

    public int getCw_index() {
        return this.cw_index;
    }

    public int getTier() {
        return this.tier;
    }

    public int getSplice_command_length() {
        return this.splice_command_length;
    }

    public int getSplice_command_type() {
        return this.splice_command_type;
    }

    public int getDescriptor_loop_length() {
        return this.descriptor_loop_length;
    }

    public List<Descriptor> getSplice_descriptors() {
        return this.splice_descriptors;
    }

    public TreeNode getSplice_command() {
        return this.splice_command;
    }

    private static class SpliceNull
    implements TreeNode {
        private SpliceNull(BitSource bs) {
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            return new DefaultMutableTreeNode(new KVP("splice_null"));
        }
    }

    public class SpliceInsert
    implements TreeNode {
        private long splice_event_id;
        private int splice_event_cancel_indicator;
        private int out_of_network_indicator;
        private int program_splice_flag;
        private int duration_flag;
        private int splice_immediate_flag;
        private int unique_program_id;
        private int avail_num;
        private int avails_expected;
        private int component_count;
        private SpliceTime splice_time;
        private BreakDuration break_duration;
        private List<Integer> componentTags = new ArrayList<Integer>();
        private List<SpliceTime> componentSpliceTimes = new ArrayList<SpliceTime>();

        private SpliceInsert(SpliceInfoSection this$0, BitSource bitSource) {
            this.splice_event_id = bitSource.readBitsLong(32);
            this.splice_event_cancel_indicator = bitSource.readBits(1);
            bitSource.readBits(7);
            if (this.splice_event_cancel_indicator == 0) {
                this.out_of_network_indicator = bitSource.readBits(1);
                this.program_splice_flag = bitSource.readBits(1);
                this.duration_flag = bitSource.readBits(1);
                this.splice_immediate_flag = bitSource.readBits(1);
                bitSource.readBits(4);
                if (this.program_splice_flag == 1 && this.splice_immediate_flag == 0) {
                    this.splice_time = this$0.new SpliceTime(bitSource);
                }
                if (this.program_splice_flag == 0) {
                    this.component_count = bitSource.readBits(8);
                    for (int i = 0; i < this.component_count; ++i) {
                        int component_tag = bitSource.readBits(8);
                        this.componentTags.add(component_tag);
                        if (this.splice_immediate_flag != 0) continue;
                        SpliceTime component_splice_time = this$0.new SpliceTime(bitSource);
                        this.componentSpliceTimes.add(component_splice_time);
                    }
                }
                if (this.duration_flag == 1) {
                    this.break_duration = new BreakDuration(bitSource);
                }
                this.unique_program_id = bitSource.readBits(16);
                this.avail_num = bitSource.readBits(8);
                this.avails_expected = bitSource.readBits(8);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("splice_insert"));
            t.add(new DefaultMutableTreeNode(new KVP("splice_event_id", this.splice_event_id, null)));
            t.add(new DefaultMutableTreeNode(new KVP("splice_event_cancel_indicator", this.splice_event_cancel_indicator, this.splice_event_cancel_indicator == 1 ? "a previously sent splice event, identified by splice_event_id, has been cancelled" : null)));
            if (this.splice_event_cancel_indicator == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("out_of_network_indicator", this.out_of_network_indicator, this.out_of_network_indicator == 1 ? "the splice event is an opportunity to exit from the network feed" : "the splice event is an opportunity to return to the network feed")));
                t.add(new DefaultMutableTreeNode(new KVP("program_splice_flag", this.program_splice_flag, this.program_splice_flag == 1 ? "the message refers to a Program Splice Point" : "each component that is intended to be spliced will be listed separately")));
                t.add(new DefaultMutableTreeNode(new KVP("duration_flag", this.duration_flag, this.duration_flag == 1 ? "break_duration() field present" : "break_duration() field not present")));
                t.add(new DefaultMutableTreeNode(new KVP("splice_immediate_flag", this.splice_immediate_flag, this.splice_immediate_flag == 1 ? "splice mode shall be the Splice Immediate Mode" : "splice_time() field present")));
                if (this.program_splice_flag == 1 && this.splice_immediate_flag == 0) {
                    t.add(this.splice_time.getJTreeNode(modus));
                }
                if (this.program_splice_flag == 0) {
                    t.add(new DefaultMutableTreeNode(new KVP("component_count", this.component_count, null)));
                    for (int i = 0; i < this.component_count; ++i) {
                        t.add(new DefaultMutableTreeNode(new KVP("component_tag [" + i + "]", this.componentTags.get(i), null)));
                        if (this.splice_immediate_flag != 0) continue;
                        t.add(this.componentSpliceTimes.get(i).getJTreeNode(modus));
                    }
                }
                if (this.duration_flag == 1) {
                    t.add(this.break_duration.getJTreeNode(modus));
                }
                t.add(new DefaultMutableTreeNode(new KVP("unique_program_id", this.unique_program_id, null)));
                t.add(new DefaultMutableTreeNode(new KVP("avail_num", this.avail_num, null)));
                t.add(new DefaultMutableTreeNode(new KVP("avails_expected", this.avails_expected, null)));
            }
            return t;
        }

        public long getSplice_event_id() {
            return this.splice_event_id;
        }

        public int getSplice_event_cancel_indicator() {
            return this.splice_event_cancel_indicator;
        }

        public int getOut_of_network_indicator() {
            return this.out_of_network_indicator;
        }

        public int getProgram_splice_flag() {
            return this.program_splice_flag;
        }

        public int getDuration_flag() {
            return this.duration_flag;
        }

        public int getSplice_immediate_flag() {
            return this.splice_immediate_flag;
        }

        public int getUnique_program_id() {
            return this.unique_program_id;
        }

        public int getAvail_num() {
            return this.avail_num;
        }

        public int getAvails_expected() {
            return this.avails_expected;
        }

        public int getComponent_count() {
            return this.component_count;
        }

        public SpliceTime getSplice_time() {
            return this.splice_time;
        }

        public BreakDuration getBreak_duration() {
            return this.break_duration;
        }

        public List<Integer> getComponentTags() {
            return this.componentTags;
        }

        public List<SpliceTime> getComponentSpliceTimes() {
            return this.componentSpliceTimes;
        }
    }

    public class TimeSignal
    implements TreeNode {
        private SpliceTime splice_time;

        public SpliceTime getSplice_time() {
            return this.splice_time;
        }

        private TimeSignal(SpliceInfoSection this$0, BitSource bs) {
            this.splice_time = this$0.new SpliceTime(bs);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("time_signal"));
            t.add(this.splice_time.getJTreeNode(modus));
            return t;
        }
    }

    public static class BandwidthReservation
    implements TreeNode {
        private BandwidthReservation(BitSource bs) {
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            return new DefaultMutableTreeNode(new KVP("bandwidth_reservation"));
        }
    }

    private static class BreakDuration
    implements TreeNode {
        private int auto_return;
        private int reserved;
        private long duration;

        private BreakDuration(BitSource bs) {
            this.auto_return = bs.readBits(1);
            this.reserved = bs.readBits(6);
            this.duration = bs.readBitsLong(33);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("break_duration"));
            t.add(new DefaultMutableTreeNode(new KVP("auto_return", this.auto_return, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            t.add(new DefaultMutableTreeNode(new KVP("duration", this.duration, Utils.printTimebase90kHz(this.duration))));
            return t;
        }
    }

    public class SpliceTime
    implements TreeNode {
        private int time_specified_flag;
        private long pts_time;

        private SpliceTime(BitSource bs) {
            this.time_specified_flag = bs.readBits(1);
            if (this.time_specified_flag == 1) {
                bs.readBits(6);
                this.pts_time = bs.readBitsLong(33);
            } else {
                bs.readBits(7);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            String preRoolTime = this.getPreRollTimeString();
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("splice_time" + preRoolTime));
            t.add(new DefaultMutableTreeNode(new KVP("time_specified_flag", this.time_specified_flag, null)));
            if (this.time_specified_flag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("pts_time", this.pts_time, Utils.printTimebase90kHz(this.pts_time))));
            }
            return t;
        }

        private String getPreRollTimeString() {
            if (this.time_specified_flag == 1) {
                Long packetPcrTime;
                PMTsection pmt;
                PID pcrPid;
                PID parentPid = SpliceInfoSection.this.getParentPID();
                if (parentPid == null) {
                    return "";
                }
                TransportStream ts = parentPid.getParentTransportStream();
                PMTs pmts = ts.getPsi().getPmts();
                List<PMTsection> pmtList = pmts.findPMTsFromComponentPID(parentPid.getPid());
                if (pmtList.size() >= 1 && (pcrPid = ts.getPID((pmt = pmtList.get(0)).getPcrPid())) != null && (packetPcrTime = pcrPid.getPacketPcrTime(SpliceInfoSection.this.getFirst_packet_no())) != null) {
                    double preRollSecs = (double)(this.getSpliceTimeAdjusted() - packetPcrTime / 300L) / 90000.0;
                    return String.format(" (preroll time = %3.3f secs)", preRollSecs);
                }
            }
            return "";
        }

        public int getTime_specified_flag() {
            return this.time_specified_flag;
        }

        public long getPts_time() {
            return this.pts_time;
        }

        public long getSpliceTimeAdjusted() {
            return this.pts_time + SpliceInfoSection.this.pts_adjustment & 0x1FFFFFFFFL;
        }
    }
}

