/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSection;

public class SpliceInfoSections
extends AbstractPSITabel {
    private final List<SpliceInfoSection> spliceInfoSectionList = new ArrayList<SpliceInfoSection>();
    private int pid = 0;

    public SpliceInfoSections(PSI parent) {
        super(parent);
    }

    public void update(SpliceInfoSection section) {
        this.spliceInfoSectionList.add(section);
        this.pid = section.getParentPID().getPid();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        int programNumber = this.getParentPSI().getPmts().findPMTsFromComponentPID(this.pid).get(0).getProgramNumber();
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("SpliceInfoSections PID=" + this.pid + " for program", programNumber, this.getParentPSI().getSdt().getServiceNameForActualTransportStream(programNumber)));
        for (SpliceInfoSection toTsection : this.spliceInfoSectionList) {
            t.add(toTsection.getJTreeNode(modus));
        }
        return t;
    }

    public List<SpliceInfoSection> getSpliceInfoSectionList() {
        return this.spliceInfoSectionList;
    }
}

