/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDT;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class TDTsection
extends TableSection {
    private final byte[] UTC_time;

    public TDTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.UTC_time = Arrays.copyOfRange(raw_data.getData(), 3, 8);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("TDTsection UTC_Time=");
        b.append(Utils.toHexString(this.UTC_time)).append(", UTC_timeString=").append(this.getUTC_timeString()).append(", length=").append(this.getSectionLength());
        return b.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        KVP kvp = (KVP)t.getUserObject();
        kvp.addTableSource(this::getTableModel, "TDT Section");
        t.add(new DefaultMutableTreeNode(new KVP("UTC_time", this.UTC_time, Utils.getUTCFormattedString(this.UTC_time))));
        return t;
    }

    public byte[] getUTC_time() {
        return this.UTC_time;
    }

    public String getUTC_timeString() {
        return Utils.getUTCFormattedString(this.UTC_time);
    }

    public TableModel getTableModel() {
        FlexTableModel<TDTsection, TDTsection> tableModel = new FlexTableModel<TDTsection, TDTsection>(TDT.buildTdtTableHeader());
        ArrayList<TDTsection> lst = new ArrayList<TDTsection>();
        lst.add(this);
        tableModel.addData(this, lst);
        tableModel.process();
        return tableModel;
    }
}

