/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LocalTimeOffsetDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.TOTsection;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class TOT
extends AbstractPSITabel {
    private final List<TOTsection> totSectionList = new ArrayList<TOTsection>();

    public TOT(PSI parent) {
        super(parent);
    }

    public void update(TOTsection section) {
        this.totSectionList.add(section);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP("TOT");
        if (!this.totSectionList.isEmpty()) {
            kvp.addTableSource(this::getTableModel, "TOT");
        }
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        for (TOTsection toTsection : this.totSectionList) {
            t.add(toTsection.getJTreeNode(modus));
        }
        return t;
    }

    public List<TOTsection> getTotSectionList() {
        return this.totSectionList;
    }

    static TableHeader<TOTsection, LocalTimeOffsetDescriptor> buildTotTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("UTC_time", totSection -> Utils.getUTCFormattedString(totSection.getUTC_time()), Number.class).addOptionalRepeatingGroupedColumn("country_code", ltod -> ltod.getOffsetList().stream().map(LocalTimeOffsetDescriptor.LocalTimeOffset::getCountryCode).collect(Collectors.toList()), Number.class, "offset").addOptionalRepeatingGroupedColumn("local_time_offset", ltod -> ltod.getOffsetList().stream().map(LocalTimeOffsetDescriptor.LocalTimeOffset::getLocalOffsetString).collect(Collectors.toList()), Number.class, "offset").addOptionalRepeatingGroupedColumn("time_of_change", ltod -> ltod.getOffsetList().stream().map(LocalTimeOffsetDescriptor.LocalTimeOffset::getTimeOfChangeString).collect(Collectors.toList()), Number.class, "offset").addOptionalRepeatingGroupedColumn("next_time_offset", ltod -> ltod.getOffsetList().stream().map(LocalTimeOffsetDescriptor.LocalTimeOffset::getNextTimeOffsetString).collect(Collectors.toList()), Number.class, "offset").build();
    }

    public TableModel getTableModel() {
        FlexTableModel<TOTsection, LocalTimeOffsetDescriptor> tableModel = new FlexTableModel<TOTsection, LocalTimeOffsetDescriptor>(TOT.buildTotTableHeader());
        for (TOTsection element : this.totSectionList) {
            if (element == null) continue;
            tableModel.addData(element, Descriptor.findGenericDescriptorsInList(element.getDescriptorList(), LocalTimeOffsetDescriptor.class));
        }
        tableModel.process();
        return tableModel;
    }
}

