/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.OperatorFastscan;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class FSTsection
extends TableSectionExtendedSyntax {
    private final List<Service> serviceList;

    public FSTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.serviceList = this.buildTransportStreamList(raw_data.getData(), 8, this.sectionLength - 9);
    }

    public int getOperatorNetworkID() {
        return this.getTableIdExtension();
    }

    @Override
    public String toString() {
        return "FSTsection section=" + this.getSectionNumber() + ", lastSection=" + this.getSectionLastNumber() + ", tableType=" + FSTsection.getTableType(this.tableId) + ", NetworkID=" + this.getOperatorNetworkID() + ", ";
    }

    private List<Service> buildTransportStreamList(byte[] data, int offset, int programInfoLength) {
        int transportDescriptorsLength;
        ArrayList<Service> r = new ArrayList<Service>();
        for (int t = 0; t < programInfoLength; t += 18 + transportDescriptorsLength) {
            int originalNetworkID = Utils.getInt(data, offset + t, 2, 65535);
            int transportStreamID = Utils.getInt(data, offset + t + 2, 2, 65535);
            int serviceId = Utils.getInt(data, offset + t + 4, 2, 65535);
            int defaultVideoPid = Utils.getInt(data, offset + t + 6, 2, 65535);
            int defaultAudioPid = Utils.getInt(data, offset + t + 8, 2, 65535);
            int defaultVideoEcmPid = Utils.getInt(data, offset + t + 10, 2, 65535);
            int defaultAudioEcmPid = Utils.getInt(data, offset + t + 12, 2, 65535);
            int defaultPcrPid = Utils.getInt(data, offset + t + 14, 2, 65535);
            transportDescriptorsLength = Utils.getInt(data, offset + t + 16, 2, 4095);
            List<Descriptor> descriptorList = DescriptorFactory.buildDescriptorList(data, offset + t + 18, transportDescriptorsLength, this);
            Service service = new Service(originalNetworkID, transportStreamID, serviceId, defaultVideoPid, defaultAudioPid, defaultVideoEcmPid, defaultAudioEcmPid, defaultPcrPid, transportDescriptorsLength, descriptorList);
            r.add(service);
        }
        return r;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP kvp = (KVP)super.getJTreeNode(modus);
        kvp.addTableSource(this::getTableModel, "FST");
        kvp.addList(this.serviceList, modus, "service_loop");
        return kvp;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "operator_network_id";
    }

    public TableModel getTableModel() {
        FlexTableModel<FSTsection, Service> tableModel = new FlexTableModel<FSTsection, Service>(FSTsection.buildFstTableHeader());
        tableModel.addData(this, this.serviceList);
        tableModel.process();
        return tableModel;
    }

    public List<Service> getServiceList() {
        return this.serviceList;
    }

    static TableHeader<FSTsection, Service> buildFstTableHeader() {
        return new TableHeaderBuilder().addRequiredRowColumn("onid", Service::original_network_id, Integer.class).addRequiredRowColumn("tsid", Service::transport_stream_id, Integer.class).addRequiredRowColumn("sid", Service::service_id, Integer.class).addRequiredRowColumn("default_video_pid", Service::default_video_PID, Integer.class).addRequiredRowColumn("default_audio_pid", Service::default_audio_PID, Integer.class).addRequiredRowColumn("default_pcr_pid", Service::default_PCR_PID, Integer.class).addOptionalRowColumn("service name", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), ServiceDescriptor.class, sd -> sd.getServiceName().toString(OperatorFastscan.m7FastScanCharset)), String.class).addOptionalRowColumn("service provider", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), ServiceDescriptor.class, sd -> sd.getServiceProviderName().toString(OperatorFastscan.m7FastScanCharset)), String.class).addOptionalRowColumn("service type", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), ServiceDescriptor.class, sd -> Descriptor.getServiceTypeString(sd.getServiceType())), String.class).build();
    }

    public record Service(int original_network_id, int transport_stream_id, int service_id, int default_video_PID, int default_audio_PID, int default_video_ECM_PID, int default_audio_ECM_PID, int default_PCR_PID, int transportDescriptorsLength, List<Descriptor> descriptorList) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP kvp = new KVP("service:", this.service_id);
            kvp.add(new KVP("original_network_id", this.original_network_id, Utils.getOriginalNetworkIDString(this.original_network_id)));
            kvp.add(new KVP("transport_stream_id", this.transport_stream_id));
            kvp.add(new KVP("service_id", this.service_id));
            kvp.add(new KVP("default_video_PID", this.default_video_PID));
            kvp.add(new KVP("default_audio_PID", this.default_audio_PID));
            kvp.add(new KVP("default_video_ECM_PID", this.default_video_ECM_PID));
            kvp.add(new KVP("default_audio_ECM_PID", this.default_audio_ECM_PID));
            kvp.add(new KVP("default_PCR_PID", this.default_PCR_PID));
            kvp.add(new KVP("default_video_ECM_PID", this.default_video_ECM_PID));
            kvp.add(new KVP("descriptor_loop_length", this.transportDescriptorsLength));
            kvp.addList(this.descriptorList, modus, "service_descriptor");
            return kvp;
        }
    }
}

