/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LinkageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.NIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FNTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FSTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.ONTSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.OperatorFastscan;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;

public class M7Fastscan
implements TreeNode {
    private final Map<Integer, Map<Integer, OperatorFastscan>> operators = new HashMap<Integer, Map<Integer, OperatorFastscan>>();
    private ONTSection[] ontSections;
    private final PSI parentPSI;

    public static boolean isValidM7Code(int code) {
        return code >= 30465 && code <= 30719;
    }

    public M7Fastscan(PSI psi) {
        this.parentPSI = psi;
    }

    public void update(ONTSection section) {
        if (this.ontSections == null) {
            this.ontSections = new ONTSection[section.getSectionLastNumber() + 1];
        }
        if (this.ontSections[section.getSectionNumber()] == null) {
            this.ontSections[section.getSectionNumber()] = section;
        } else {
            ONTSection last = this.ontSections[section.getSectionNumber()];
            AbstractPSITabel.updateSectionVersion(section, last);
        }
    }

    public void update(FSTsection section) {
        int pid = section.getParentPID().getPid();
        int operator = section.getOperatorNetworkID();
        this.findOrCreateOperatorFastscan(operator, pid).update(section);
    }

    private OperatorFastscan findOrCreateOperatorFastscan(int operator, int pid) {
        Map p = this.operators.computeIfAbsent(operator, k -> new HashMap());
        return p.computeIfAbsent(pid, k -> new OperatorFastscan(pid, this));
    }

    public void update(FNTsection section) {
        int pid = section.getParentPID().getPid();
        int operator = section.getOperatorNetworkID();
        this.findOrCreateOperatorFastscan(operator, pid).update(section);
    }

    public String getOperatorName(int operator_network_id) {
        if (this.ontSections != null) {
            for (ONTSection ontSection : this.ontSections) {
                String r;
                if (ontSection == null || (r = ontSection.getOperatorName(operator_network_id)) == null) continue;
                return r;
            }
        }
        return null;
    }

    public String getOperatorSubListName(int operatorNetworkId, int fstPid) {
        LinkageDescriptor homeTP_location_descriptor;
        Optional<LinkageDescriptor.BrandHomeTransponder> optionalBrandHomeTransponder;
        NIT nit = this.parentPSI.getNit();
        int actualNetworkID = nit.getActualNetworkID();
        List<Descriptor> descriptors = nit.getNetworkDescriptors(actualNetworkID);
        Optional<LinkageDescriptor> optionalHomeTP_location_descriptor = descriptors.stream().filter(LinkageDescriptor.class::isInstance).map(LinkageDescriptor.class::cast).filter(linkageDescriptor -> linkageDescriptor.getLinkageType() >= 136 && linkageDescriptor.getLinkageType() <= 138).findFirst();
        if (optionalHomeTP_location_descriptor.isPresent() && (optionalBrandHomeTransponder = (homeTP_location_descriptor = optionalHomeTP_location_descriptor.get()).getM7BrandHomeTransponderList().stream().filter(brandHomeTransponder -> brandHomeTransponder.operator_network_id() == operatorNetworkId).filter(brandHomeTransponder -> brandHomeTransponder.fst_pid() == fstPid).findFirst()).isPresent()) {
            LinkageDescriptor.BrandHomeTransponder brandHomeTransponder2 = optionalBrandHomeTransponder.get();
            int sublist_id = brandHomeTransponder2.operator_sublist_id();
            String r = "sublist_id: " + sublist_id;
            if (this.ontSections != null) {
                for (ONTSection ontSection : this.ontSections) {
                    String sublistNamme;
                    if (ontSection == null || (sublistNamme = ontSection.getOperatorSublistName(operatorNetworkId, sublist_id)) == null) continue;
                    return r + " : " + sublistNamme;
                }
            }
            return r;
        }
        return null;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("M7 Fastscan");
        if (this.ontSections != null) {
            KVP ont = new KVP("ONT");
            ont.addTableSource(this::getTableModelOnt, "ONT");
            for (ONTSection ontSection : this.ontSections) {
                if (ontSection == null) continue;
                AbstractPSITabel.addSectionVersionsToJTree(ont, ontSection, modus);
            }
            t.add(ont);
        }
        for (Integer operatorId : new TreeSet<Integer>(this.operators.keySet())) {
            Map<Integer, OperatorFastscan> operatorsInPid = this.operators.get(operatorId);
            KVP operatorNode = new KVP("operator_network_id", operatorId, this.getOperatorName(operatorId));
            t.add(operatorNode);
            for (Integer pid : new TreeSet<Integer>(operatorsInPid.keySet())) {
                OperatorFastscan operatorFastscan = operatorsInPid.get(pid);
                operatorNode.add(operatorFastscan.getJTreeNode(modus));
            }
        }
        return t;
    }

    public TableModel getTableModelOnt() {
        FlexTableModel<ONTSection, ONTSection.OperatorBrand> tableModel = new FlexTableModel<ONTSection, ONTSection.OperatorBrand>(ONTSection.buildOntTableHeader());
        for (ONTSection ontSection : this.ontSections) {
            if (ontSection == null) continue;
            tableModel.addData(ontSection, ontSection.getOperatorBrandList());
        }
        tableModel.process();
        return tableModel;
    }

    public Map<Integer, Map<Integer, OperatorFastscan>> getOperators() {
        return this.operators;
    }

    public ONTSection[] getOntSections() {
        return this.ontSections;
    }
}

