/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7NagraBrandIdDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorDiSEqCTDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorOptionsDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorPreferencesDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OperatorSublistNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.m7fastscan.M7OttBrandIdDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class ONTSection
extends TableSectionExtendedSyntax {
    private static final Logger logger = Logger.getLogger(ONTSection.class.getName());
    private final int bouquet_descriptors_loop_length;
    private final List<Descriptor> bouquetDescriptorList;
    private final int operator_brands_loop_length;
    private final List<OperatorBrand> operatorBrandList;

    public ONTSection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.bouquet_descriptors_loop_length = Utils.getInt(raw_data.getData(), 8, 2, 4095);
        this.bouquetDescriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 10, this.bouquet_descriptors_loop_length, this);
        this.operator_brands_loop_length = Utils.getInt(raw_data.getData(), 10 + this.bouquet_descriptors_loop_length, 2, 4095);
        this.operatorBrandList = this.buildOperatorBrandList(raw_data.getData(), 12 + this.bouquet_descriptors_loop_length, this.operator_brands_loop_length);
    }

    private List<OperatorBrand> buildOperatorBrandList(byte[] data, int i, int operator_brands_loop_length2) {
        ArrayList<OperatorBrand> r = new ArrayList<OperatorBrand>();
        try {
            int operator_descriptors_length;
            for (int t = 0; t < operator_brands_loop_length2; t += 5 + operator_descriptors_length) {
                int operatorNetworkId = Utils.getInt(data, i + t, 2, 65535);
                int operatorSublistId = Utils.getInt(data, i + t + 2, 1, 255);
                int reservedFutureUse = Utils.getInt(data, i + t + 3, 1, 240) >>> 4;
                operator_descriptors_length = Utils.getInt(data, i + t + 3, 2, 4095);
                List<Descriptor> descriptorList = DescriptorFactory.buildDescriptorList(data, i + t + 5, operator_descriptors_length, this);
                OperatorBrand operatorBrand = new OperatorBrand(operatorNetworkId, operatorSublistId, reservedFutureUse, operator_descriptors_length, descriptorList);
                r.add(operatorBrand);
            }
        }
        catch (RuntimeException re) {
            logger.info("RuntimeException in buildOperatorBrandList;" + String.valueOf(re));
        }
        return r;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP kvp = (KVP)super.getJTreeNode(modus);
        kvp.addTableSource(this::getTableModel, "ONT Section");
        kvp.add(new KVP("bouquet_descriptors_loop_length", this.bouquet_descriptors_loop_length));
        kvp.addList(this.bouquetDescriptorList, modus, "bouquet_descriptors");
        kvp.add(new KVP("operator_brands_loop_length", this.operator_brands_loop_length));
        kvp.addList(this.operatorBrandList, modus, "operator_brands_loop");
        return kvp;
    }

    public String getOperatorName(int operator_network_id) {
        for (OperatorBrand operatorBrand : this.operatorBrandList) {
            List<M7OperatorNameDescriptor> operatorNameDescriptors;
            if (operatorBrand.operator_network_id() != operator_network_id || (operatorNameDescriptors = Descriptor.findGenericDescriptorsInList(operatorBrand.descriptorList(), M7OperatorNameDescriptor.class)).isEmpty()) continue;
            return operatorNameDescriptors.getFirst().getOperatorName().toString();
        }
        return null;
    }

    public String getOperatorSublistName(int operator_network_id, int operator_sublist_id) {
        for (OperatorBrand operatorBrand : this.operatorBrandList) {
            List<M7OperatorSublistNameDescriptor> operatorSublistNameDescriptors;
            if (operatorBrand.operator_network_id() != operator_network_id || operatorBrand.operator_sublist_id() != operator_sublist_id || (operatorSublistNameDescriptors = Descriptor.findGenericDescriptorsInList(operatorBrand.descriptorList(), M7OperatorSublistNameDescriptor.class)).isEmpty()) continue;
            return operatorSublistNameDescriptors.getFirst().getOperatorSublistName().toString();
        }
        return null;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "bouquet_id";
    }

    public TableModel getTableModel() {
        FlexTableModel<ONTSection, OperatorBrand> tableModel = new FlexTableModel<ONTSection, OperatorBrand>(ONTSection.buildOntTableHeader());
        tableModel.addData(this, this.operatorBrandList);
        tableModel.process();
        return tableModel;
    }

    static TableHeader<ONTSection, OperatorBrand> buildOntTableHeader() {
        return new TableHeaderBuilder().addRequiredRowColumn("operator network id", OperatorBrand::operator_network_id, Integer.class).addRequiredRowColumn("operator_sublist_id", OperatorBrand::operator_sublist_id, Integer.class).addOptionalRowColumn("operator name", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorNameDescriptor.class, ond -> ond.getOperatorName().toString()), String.class).addOptionalRowColumn("operator sublist name", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorSublistNameDescriptor.class, osnd -> osnd.getOperatorSublistName().toString()), String.class).addOptionalRowColumn("nagra brand id", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7NagraBrandIdDescriptor.class, nbid -> nbid.getNagra_brand_id()), Integer.class).addOptionalRowColumn("nagra ca system id", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7NagraBrandIdDescriptor.class, nbid -> nbid.getCa_system_ID()), Integer.class).addOptionalRowColumn("ott brand id", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OttBrandIdDescriptor.class, obid -> obid.getOtt_brand_id().toString()), String.class).addOptionalRowColumn("country code", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorPreferencesDescriptor.class, M7OperatorPreferencesDescriptor::getCountry_code), String.class).addOptionalRowColumn("menu osd", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorPreferencesDescriptor.class, M7OperatorPreferencesDescriptor::getMenu_ISO_639_language_code), String.class).addOptionalRowColumn("audio 1", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorPreferencesDescriptor.class, M7OperatorPreferencesDescriptor::getAudio1_ISO_639_language_code), String.class).addOptionalRowColumn("audio 2", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorPreferencesDescriptor.class, M7OperatorPreferencesDescriptor::getAudio2_ISO_639_language_code), String.class).addOptionalRowColumn("subs lang", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorPreferencesDescriptor.class, M7OperatorPreferencesDescriptor::getSubs_ISO_639_language_code), String.class).addOptionalRowColumn("subs usage", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorOptionsDescriptor.class, M7OperatorOptionsDescriptor::getSubtitles_enabled), Integer.class).addOptionalRowColumn("parental control", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorOptionsDescriptor.class, M7OperatorOptionsDescriptor::getParentalControlString), String.class).addOptionalRowColumn("FST char set", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorOptionsDescriptor.class, M7OperatorOptionsDescriptor::getEncodingTypeString), String.class).addOptionalRowColumn("region", operator -> Descriptor.findDescriptorApplyFunc(operator.descriptorList(), M7OperatorOptionsDescriptor.class, M7OperatorOptionsDescriptor::getSpecial_regions_setup), Integer.class).addOptionalRepeatingRowColumn("DiSeq Pos", operator -> Descriptor.findDescriptorApplyListFunc(operator.descriptorList(), M7OperatorDiSEqCTDescriptor.class, odd -> odd.getDiSEqCList().stream().map(M7OperatorDiSEqCTDescriptor.DiSEqC::getTotalPositionString).collect(Collectors.toList())), String.class).build();
    }

    public List<OperatorBrand> getOperatorBrandList() {
        return this.operatorBrandList;
    }

    public record OperatorBrand(int operator_network_id, int operator_sublist_id, int reserved_future_use, int operator_descriptors_length, List<Descriptor> descriptorList) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP t = new KVP("operator_brand", this.operator_network_id + "-" + this.operator_sublist_id);
            t.add(new KVP("operator_network_id", this.operator_network_id));
            t.add(new KVP("operator_sublist_id", this.operator_sublist_id));
            t.add(new KVP("reserved_future_use", this.reserved_future_use));
            t.add(new KVP("operator_descriptors_length", this.operator_descriptors_length));
            Utils.addListJTree(t, this.descriptorList, modus, "operator_descriptors");
            return t;
        }
    }
}

