/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi.ses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ServiceDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses.BouquetListDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses.ServiceListNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.privatedescriptors.ses.VirtualServiceIDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.ses.SGTsection;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class SGT
extends AbstractPSITabel {
    private final Map<Integer, HashMap<Integer, SGTsection[]>> service_guides = new HashMap<Integer, HashMap<Integer, SGTsection[]>>();

    public void update(SGTsection section) {
        int key;
        int pid = section.getParentPID().getPid();
        HashMap l = this.service_guides.computeIfAbsent(pid, HashMap::new);
        SGTsection[] sections = l.computeIfAbsent(key = section.getServiceListId(), k -> new SGTsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            SGTsection last = sections[section.getSectionNumber()];
            SGT.updateSectionVersion(section, last);
        }
    }

    public SGT(PSI parentPSI) {
        super(parentPSI);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("SGT (Astra Service Guide Table)");
        for (Map.Entry<Integer, HashMap<Integer, SGTsection[]>> guide : this.service_guides.entrySet()) {
            int pid = guide.getKey();
            KVP pidKvp = new KVP("pid", pid).addTableSource(() -> this.getTableForPid(pid), "SGT pid: " + pid);
            t.add(pidKvp);
            for (int service_list_id : new TreeSet<Integer>(guide.getValue().keySet())) {
                KVP serviceListIdKvp = new KVP("service_list_id", service_list_id);
                serviceListIdKvp.addTableSource(() -> this.getTableForServiceListID(pid, service_list_id), "SGT service_list_id: " + service_list_id);
                for (SGTsection tsection : guide.getValue().get(service_list_id)) {
                    if (tsection == null) continue;
                    serviceListIdKvp.add(tsection.getJTreeNode(modus));
                }
                pidKvp.add(serviceListIdKvp);
            }
        }
        return t;
    }

    static TableHeader<SGTsection, SGTsection.Service> buildSgtTableHeader() {
        Function<SGTsection, List> findServiceListNames = component -> Descriptor.findGenericDescriptorsInList(component.getServiceListDescriptorsList(), ServiceListNameDescriptor.class).stream().map(serviceListNameDescriptor -> serviceListNameDescriptor.getService_list_name().toString()).collect(Collectors.toList());
        Function<SGTsection.Service, Object> findServiceName = service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), ServiceDescriptor.class, sd -> sd.getServiceName().toString());
        Function<SGTsection.Service, Object> findServiceProviderName = service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), ServiceDescriptor.class, sd -> sd.getServiceProviderName().toString());
        Function<SGTsection.Service, List> findBouquetNames = component -> Descriptor.findDescriptorApplyListFunc(component.getDescriptorList(), BouquetListDescriptor.class, bouquetListDescriptor -> new ArrayList(bouquetListDescriptor.getBouquet_names().stream().map(a -> a.name().toString()).collect(Collectors.toList())));
        Function<SGTsection.Service, Object> findServiceId = service -> Descriptor.findDescriptorApplyFunc(service.getDescriptorList(), VirtualServiceIDDescriptor.class, VirtualServiceIDDescriptor::getVirtual_service_id);
        return new TableHeaderBuilder().addRequiredBaseColumn("service_list_id", SGTsection::getServiceListId, Integer.class).addOptionalRepeatingBaseColumn("bouquet_name", findServiceListNames, String.class).addOptionalRowColumn("service_id", SGTsection.Service::getService_id, Integer.class).addOptionalRowColumn("transport_stream_id", SGTsection.Service::getTransport_stream_id, Integer.class).addOptionalRowColumn("original_network_id", SGTsection.Service::getOriginal_network_id, Integer.class).addOptionalRowColumn("logical_channel_number", SGTsection.Service::getLogical_channel_number, Integer.class).addOptionalRowColumn("visible_service_flag", SGTsection.Service::getVisible_service_flag, Integer.class).addOptionalRowColumn("new_service_flag", SGTsection.Service::getNew_service_flag, Integer.class).addOptionalRowColumn("genre_code", SGTsection.Service::getGenre_code, Integer.class).addOptionalRowColumn("service_name", findServiceName, String.class).addOptionalRowColumn("provider_name", findServiceProviderName, String.class).addOptionalRepeatingRowColumn("bouquet_name ", findBouquetNames, String.class).addOptionalRowColumn("virtual_service_id", findServiceId, Integer.class).build();
    }

    private TableModel getTableForServiceListID(int pid, int slid) {
        FlexTableModel<SGTsection, SGTsection.Service> tableModel = new FlexTableModel<SGTsection, SGTsection.Service>(SGT.buildSgtTableHeader());
        SGTsection[] sections = this.service_guides.get(pid).get(slid);
        SGT.fillTableForServiceListId(tableModel, sections);
        tableModel.process();
        return tableModel;
    }

    private TableModel getTableForPid(int pid) {
        FlexTableModel<SGTsection, SGTsection.Service> tableModel = new FlexTableModel<SGTsection, SGTsection.Service>(SGT.buildSgtTableHeader());
        HashMap<Integer, SGTsection[]> pidSGT = this.service_guides.get(pid);
        SGT.fillTableForPid(tableModel, pidSGT);
        tableModel.process();
        return tableModel;
    }

    private static void fillTableForPid(FlexTableModel<SGTsection, SGTsection.Service> tableModel, Map<Integer, SGTsection[]> networkSDT) {
        networkSDT.values().forEach(s -> SGT.fillTableForServiceListId(tableModel, s));
    }

    private static void fillTableForServiceListId(FlexTableModel<SGTsection, SGTsection.Service> tableModel, SGTsection[] tsSDT) {
        for (SGTsection tsection : tsSDT) {
            if (tsection == null) continue;
            tableModel.addData(tsection, tsection.getServiceList());
        }
    }
}

