/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import javax.swing.JMenuItem;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.BarChartExportAction;
import nl.digitalekabeltelevisie.gui.BitRateChart;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtils;

public class BarChart
extends ChartPanel
implements TransportStreamView {
    private JFreeChart freeChart;
    private CategoryDataset dataSet;

    public BarChart(TransportStream transportStream, ViewContext viewContext) {
        super(null, false);
        this.setTransportStream(transportStream, viewContext);
        JMenuItem export = new JMenuItem(new BarChartExportAction("export as .csv", this));
        this.getPopupMenu().add(export);
    }

    @Override
    public final void setTransportStream(TransportStream transportStream, ViewContext viewContext) {
        if (transportStream != null) {
            this.dataSet = BarChart.createDataSet(transportStream, viewContext);
            this.freeChart = ChartFactory.createBarChart((String)(transportStream.getFile().getName() + " - stream:" + transportStream.getStreamID()), (String)"PID", (String)"bitrate", (CategoryDataset)this.dataSet, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            this.setChart(this.freeChart);
        } else {
            this.freeChart = null;
            this.dataSet = null;
            this.setChart(GuiUtils.createTitleOnlyChart("No transportstream loaded, drag a MPEG-TS (*.ts;*.mpg;*.mpeg;*.m2ts;*.mts;*.tsa;*.tsv) file here"));
        }
    }

    private static double[][] createCbrData(TransportStream transportStream, ViewContext viewContext, short[] used_pids, int[] pidCountAvg) {
        int i;
        int steps = viewContext.getGraphSteps();
        double[][] data = new double[3][viewContext.getShown().size()];
        for (i = 0; i < used_pids.length; ++i) {
            data[0][i] = transportStream.getBitRate() != -1L ? (double)((long)pidCountAvg[used_pids[i]] * transportStream.getBitRate() / (long)(viewContext.getEndPacket() - viewContext.getStartPacket())) : (double)pidCountAvg[used_pids[i]];
        }
        for (i = 0; i < used_pids.length; ++i) {
            data[1][i] = Double.MAX_VALUE;
        }
        for (int t = 0; t < steps; ++t) {
            int[] periodpidcount = new int[8192];
            int startPacketStep = viewContext.getStartPacket() + (int)((long)t * (long)(viewContext.getEndPacket() - viewContext.getStartPacket()) / (long)steps);
            int endPacketStep = viewContext.getStartPacket() + (int)((long)(t + 1) * (long)(viewContext.getEndPacket() - viewContext.getStartPacket()) / (long)steps);
            for (int r = startPacketStep; r < endPacketStep; ++r) {
                short pid_current_packet;
                short s = pid_current_packet = transportStream.getPacket_pid(r);
                periodpidcount[s] = periodpidcount[s] + 1;
            }
            for (int i2 = 0; i2 < used_pids.length; ++i2) {
                int periodCount = periodpidcount[used_pids[i2]];
                if (transportStream.getBitRate() != -1L && endPacketStep > startPacketStep) {
                    double bitRate = (long)periodCount * transportStream.getBitRate() / (long)(endPacketStep - startPacketStep);
                    if (bitRate < data[1][i2]) {
                        data[1][i2] = bitRate;
                    }
                    if (!(bitRate > data[2][i2])) continue;
                    data[2][i2] = bitRate;
                    continue;
                }
                data[1][i2] = periodCount;
                data[2][i2] = periodCount;
            }
        }
        return data;
    }

    private static CategoryDataset createDataSet(TransportStream transportStream, ViewContext viewContext) {
        short[] usedPids = BitRateChart.createUsedPidsArray(viewContext, viewContext.getShown().size());
        Comparable[] labels = BarChart.createPidChartLabels(transportStream, viewContext, viewContext.getShown().size());
        Comparable[] avgMinMaxLabels = BarChart.createAvgMinMaxLabels();
        int[] pidCountAvg = new int[8192];
        for (int r = viewContext.getStartPacket(); r < viewContext.getEndPacket(); ++r) {
            short pid_current_packet;
            short s = pid_current_packet = transportStream.getPacket_pid(r);
            pidCountAvg[s] = pidCountAvg[s] + 1;
        }
        double[][] data = transportStream.isAVCHD() ? BarChart.createAvchdData(transportStream, viewContext, usedPids, pidCountAvg) : BarChart.createCbrData(transportStream, viewContext, usedPids, pidCountAvg);
        CategoryDataset dataSet = DatasetUtils.createCategoryDataset((Comparable[])avgMinMaxLabels, (Comparable[])labels, (double[][])data);
        return dataSet;
    }

    private static double[][] createAvchdData(TransportStream transportStream, ViewContext viewContext, short[] usedPids, int[] pidCountAvg) {
        int i;
        int steps = viewContext.getGraphSteps();
        double[][] data = new double[3][viewContext.getShown().size()];
        long startSelectionTime = transportStream.getAVCHDPacketTime(viewContext.getStartPacket());
        long endSelectionTime = transportStream.getAVCHDPacketTime(viewContext.getEndPacket() - 1);
        long selectionDuration = endSelectionTime - startSelectionTime;
        for (i = 0; i < usedPids.length; ++i) {
            data[0][i] = (double)pidCountAvg[usedPids[i]] * 2.7E7 * 8.0 * 192.0 / (double)selectionDuration;
        }
        for (i = 0; i < usedPids.length; ++i) {
            data[1][i] = Double.MAX_VALUE;
        }
        int packetIndex = viewContext.getStartPacket();
        long startStepPacketTime = startSelectionTime;
        for (int step = 0; step < steps; ++step) {
            long endStepPacketTime = startSelectionTime + selectionDuration * (long)(step + 1) / (long)steps;
            int[] periodpidcount = new int[8192];
            while (packetIndex < viewContext.getEndPacket() && transportStream.getAVCHDPacketTime(packetIndex) <= endStepPacketTime) {
                short pid_current_packet;
                short s = pid_current_packet = transportStream.getPacket_pid(packetIndex);
                periodpidcount[s] = periodpidcount[s] + 1;
                ++packetIndex;
            }
            for (int i2 = 0; i2 < usedPids.length; ++i2) {
                if (endStepPacketTime <= startStepPacketTime) continue;
                double bitRate = (double)periodpidcount[usedPids[i2]] * 2.7E7 * 8.0 * 192.0 / (double)(endStepPacketTime - startStepPacketTime);
                if (bitRate < data[1][i2]) {
                    data[1][i2] = bitRate;
                }
                if (!(bitRate > data[2][i2])) continue;
                data[2][i2] = bitRate;
            }
            startStepPacketTime = endStepPacketTime;
        }
        return data;
    }

    private static ChartLabel[] createAvgMinMaxLabels() {
        ChartLabel[] avgMinMaxLabels = new ChartLabel[]{new ChartLabel("avg", 0), new ChartLabel("min", 1), new ChartLabel("max", 2)};
        return avgMinMaxLabels;
    }

    private static ChartLabel[] createPidChartLabels(TransportStream transportStream, ViewContext viewContext, int noPIDs) {
        ChartLabel[] labels = new ChartLabel[noPIDs];
        for (int i = 0; i < noPIDs; ++i) {
            labels[i] = new ChartLabel(transportStream.getShortLabel(viewContext.getShown().get(i).getPid()), viewContext.getShown().get(i).getPid());
        }
        return labels;
    }

    public CategoryDataset getDataSet() {
        return this.dataSet;
    }
}

