/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import com.opencsv.CSVWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.gui.BarChart;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import org.jfree.data.category.CategoryDataset;

public class BarChartExportAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(BarChartExportAction.class.getName());
    BarChart barchart;

    public BarChartExportAction(String label, BarChart barchart) {
        super(label);
        this.barchart = barchart;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = GuiUtils.createFileChooser();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        File saveFile = new File("dvb_inspector_bitrates_" + df.format(new Date()) + ".csv");
        chooser.setSelectedFile(saveFile);
        int rval = chooser.showSaveDialog((Component)((Object)this.barchart));
        if (rval == 0) {
            int n;
            saveFile = chooser.getSelectedFile();
            PreferencesManager.setSaveDir(saveFile.getParent());
            boolean write = true;
            if (saveFile.exists() && (n = JOptionPane.showConfirmDialog((Component)((Object)this.barchart), "File " + String.valueOf(saveFile) + " already exists, want to overwrite?", "File already exists", 0)) == 1) {
                write = false;
            }
            if (write) {
                String content = BarChartExportAction.getCsv(this.barchart.getDataSet());
                try {
                    Files.writeString(saveFile.toPath(), (CharSequence)content, new OpenOption[0]);
                }
                catch (IOException e1) {
                    logger.warning(() -> "IOException while saving; " + String.valueOf(e1));
                }
            }
        }
    }

    public static String getCsv(CategoryDataset categoryDataset) {
        String res = "";
        try (StringWriter sw = new StringWriter();
             CSVWriter csvWriter = new CSVWriter((Writer)sw);){
            csvWriter.writeNext(BarChartExportAction.getHeaders(categoryDataset));
            for (int col = 0; col < categoryDataset.getColumnCount(); ++col) {
                String[] r = new String[5];
                ChartLabel key = (ChartLabel)categoryDataset.getColumnKey(col);
                r[0] = Short.toString(key.getPid());
                r[1] = key.getLabel();
                for (int row = 0; row < 3; ++row) {
                    r[row + 2] = Double.toString(categoryDataset.getValue(row, col).doubleValue());
                }
                csvWriter.writeNext(r);
            }
            res = sw.toString();
        }
        catch (IOException e) {
            logger.log(Level.INFO, "error building csv content", e);
        }
        return res;
    }

    private static String[] getHeaders(CategoryDataset categoryDataset) {
        String[] res = new String[5];
        res[0] = "pid";
        res[1] = "label";
        for (int row = 0; row < 3; ++row) {
            res[2 + row] = ((ChartLabel)categoryDataset.getRowKey(row)).getLabel();
        }
        return res;
    }
}

