/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.dsmcc.ServiceDSMCC;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.Audio138183Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.SubPage;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.PlpHandler;
import nl.digitalekabeltelevisie.data.mpeg.psi.handler.GeneralPsiTableHandler;
import nl.digitalekabeltelevisie.gui.DetailSource;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.gui.HtmlPanel;
import nl.digitalekabeltelevisie.gui.ImagePanel;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.SaveAble;
import nl.digitalekabeltelevisie.gui.TablePanel;
import nl.digitalekabeltelevisie.gui.TableSource;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.XMLSource;
import nl.digitalekabeltelevisie.gui.XmlPanel;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.main.DVBinspector;
import nl.digitalekabeltelevisie.util.DefaultMutableTreeNodePreorderEnumaration;
import nl.digitalekabeltelevisie.util.JTreeLazyList;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;

public class DVBtree
extends JPanel
implements HyperlinkListener,
TransportStreamView,
TreeSelectionListener,
ActionListener,
ClipboardOwner {
    public static final String STOP = "stop";
    public static final String PLAY = "play";
    public static final String EXPORT = "export";
    public static final String SAVE = "save";
    public static final String PARSE = "parse";
    public static final String T2MI = "t2mi";
    public static final String T42 = "t42";
    private static final String EXPAND = "expand";
    private static final String EXPAND_ALL = "expand_all";
    private static final String COPY = "copy";
    private static final String VIEW = "view";
    private static final String COPY_TREE = "copy_tree";
    private static final String SAVE_BYTES = "save_bytes";
    private static final int NO_DEFAULT_ELEMENTS_POP_UP_MENU = 5;
    private static final long MAX_EXPAND_ALL_TIME_MILLISECS = 500L;
    private static final long serialVersionUID = 9200238343077897328L;
    private static final Logger logger = Logger.getLogger(DVBtree.class.getName());
    private final JTree tree;
    private final JTabbedPane detailPanel;
    private final JPopupMenu popup;
    public static final int SIMPLE_MODUS = 1;
    public static final int PSI_ONLY_MODUS = 2;
    public static final int PACKET_MODUS = 4;
    public static final int COUNT_LIST_ITEMS_MODUS = 8;
    public static final int SHOW_PTS_MODUS = 16;
    public static final int SHOW_VERSION_MODUS = 32;
    private int mod;
    private TransportStream ts;
    private DefaultTreeModel model;
    private DVBinspector controller;

    public DVBtree(TransportStream transportStream, int modus, DVBinspector controller) {
        super(new GridLayout(1, 0));
        this.mod = modus;
        this.ts = transportStream;
        this.controller = controller;
        if (this.ts != null) {
            this.model = new DefaultTreeModel(this.ts.getJTreeNode(modus));
            this.tree = new JTree(this.model);
        } else {
            this.tree = new JTree(new Object[0]);
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.tree.addTreeSelectionListener(this);
        this.popup = new JPopupMenu();
        JMenuItem expandMenuItem = new JMenuItem("Expand");
        expandMenuItem.addActionListener(this);
        expandMenuItem.setActionCommand(EXPAND);
        this.popup.add(expandMenuItem);
        JMenuItem expandAllMenuItem = new JMenuItem("Expand All");
        expandAllMenuItem.addActionListener(this);
        expandAllMenuItem.setActionCommand(EXPAND_ALL);
        this.popup.add(expandAllMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy Item to clipboard");
        copyMenuItem.addActionListener(this);
        copyMenuItem.setActionCommand(COPY);
        this.popup.add(copyMenuItem);
        JMenuItem treeMenuItem = new JMenuItem("Copy Entire Sub Tree to clipboard");
        treeMenuItem.addActionListener(this);
        treeMenuItem.setActionCommand(COPY_TREE);
        this.popup.add(treeMenuItem);
        JMenuItem viewMenuItem = new JMenuItem("Copy Visible Sub Tree to clipboard");
        viewMenuItem.addActionListener(this);
        viewMenuItem.setActionCommand(VIEW);
        this.popup.add(viewMenuItem);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DVBtree.this.showContextMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DVBtree.this.showContextMenu(e);
                }
            }
        });
        JScrollPane treeView = new JScrollPane(this.tree);
        InputMap inputMap = this.tree.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(67, 128);
        inputMap.put(key, COPY);
        this.tree.getActionMap().put(COPY, new CopyAction());
        KeyStroke keyStar = KeyStroke.getKeyStroke('*');
        inputMap.put(keyStar, EXPAND_ALL);
        this.tree.getActionMap().put(EXPAND_ALL, new ExpandAllAction());
        this.detailPanel = new JTabbedPane();
        this.detailPanel.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
                if (DVBtree.this.detailPanel.getTabCount() > 1) {
                    return super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
                }
                return 0;
            }
        });
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(treeView);
        splitPane.setRightComponent(this.detailPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(12);
        Dimension minimumSize = new Dimension(300, 670);
        treeView.setMinimumSize(minimumSize);
        treeView.setPreferredSize(new Dimension(980, 670));
        splitPane.setDividerLocation(500);
        this.add(splitPane);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        MutableTreeNode node;
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && (node = this.findNodeByTrail(e.getDescription(), this.model)) != null) {
            this.showNode(node);
        }
    }

    private MutableTreeNode findNodeByTrail(String trail, DefaultTreeModel treeModel) {
        if (trail == null || !trail.startsWith("root") || this.tree == null) {
            return null;
        }
        List<String> pathList = Arrays.asList(trail.split("/"));
        return this.searchNode(pathList, (DefaultMutableTreeNode)treeModel.getRoot());
    }

    private MutableTreeNode searchNode(List<String> crumbTrail, DefaultMutableTreeNode node) {
        if (crumbTrail == null || crumbTrail.isEmpty()) {
            return null;
        }
        Object object = node.getUserObject();
        if (object instanceof KVP) {
            KVP kvp = (KVP)object;
            String crumbFound = kvp.getCrumb();
            if (crumbTrail.getFirst().equalsIgnoreCase(crumbFound)) {
                if (crumbTrail.size() == 1) {
                    return node;
                }
                List<String> subList = crumbTrail.subList(1, crumbTrail.size());
                Enumeration<TreeNode> e = node.children();
                block4: while (e.hasMoreElements()) {
                    TreeNode nextChild = e.nextElement();
                    Objects.requireNonNull(nextChild);
                    int n = 0;
                    block5: while (true) {
                        TreeNode treeNode;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultMutableTreeNode.class, JTreeLazyList.RangeNode.class}, (Object)treeNode, n)) {
                            case 0: {
                                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)treeNode;
                                MutableTreeNode res = this.searchNode(subList, dmtn);
                                if (res == null) continue block4;
                                return res;
                            }
                            case 1: {
                                JTreeLazyList.RangeNode rangeNode = (JTreeLazyList.RangeNode)treeNode;
                                if (!subList.get(0).equalsIgnoreCase(rangeNode.getLabel().trim())) {
                                    n = 2;
                                    continue block5;
                                }
                                return rangeNode.findChildForActual(Integer.parseInt(subList.get(1)));
                            }
                        }
                        break;
                    }
                }
            }
            return null;
        }
        logger.info("node.getUserObject() NOT instanceof KVP kvp");
        return null;
    }

    @Override
    public void setTransportStream(TransportStream transportStream, ViewContext viewContext) {
        this.ts = transportStream;
        if (this.ts != null) {
            this.model = new DefaultTreeModel(this.ts.getJTreeNode(this.mod));
            this.tree.setModel(this.model);
        } else {
            this.tree.setModel(null);
        }
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
    }

    public int getMod() {
        return this.mod;
    }

    public boolean toggleMod(int modus) {
        this.mod ^= modus;
        PreferencesManager.setDefaultViewModus(this.mod);
        this.refreshView();
        return (this.mod & modus) != 0;
    }

    @Override
    public void refreshView() {
        String state = "";
        if (DVBtree.isNotStructuralChange(this.mod)) {
            state = this.getExpansionState();
        }
        this.rebuildTree();
        if (DVBtree.isNotStructuralChange(this.mod)) {
            this.setExpansionState(state);
        }
    }

    private static boolean isNotStructuralChange(int modus) {
        return modus != 1 && modus != 2 && modus != 4;
    }

    private void rebuildTree() {
        if (this.ts != null) {
            this.model = new DefaultTreeModel(this.ts.getJTreeNode(this.mod));
            this.tree.setModel(this.model);
        } else {
            this.tree.setModel(null);
        }
    }

    private String getExpansionState() {
        StringBuilder sb = new StringBuilder();
        int rowCount = this.tree.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.tree.isExpanded(i)) continue;
            sb.append(i).append(",");
        }
        return sb.toString();
    }

    private void setExpansionState(String s) {
        String[] indexes;
        for (String st : indexes = s.split(",")) {
            int row = Integer.parseInt(st);
            this.tree.expandRow(row);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        MutableTreeNode node1 = (MutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.detailPanel.removeAll();
        if (node1 == null) {
            return;
        }
        if (node1 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)node1;
            Object object = node.getUserObject();
            if (object instanceof KVP) {
                KVP kvp = (KVP)object;
                List<KVP.DetailView> detailViews = kvp.getDetailViews();
                if (detailViews.isEmpty()) {
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (KVP.DetailView view : detailViews) {
                    this.createTabForView(view);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        this.detailPanel.removeAll();
    }

    private void createTabForView(KVP.DetailView view) {
        DetailSource detailSource = view.detailSource();
        String label = view.label();
        DetailSource detailSource2 = detailSource;
        Objects.requireNonNull(detailSource2);
        DetailSource detailSource3 = detailSource2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageSource.class, HTMLSource.class, XMLSource.class, TableSource.class}, (Object)detailSource3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                BufferedImage img;
                ImageSource imageSource = (ImageSource)detailSource3;
                try {
                    img = imageSource.getImage();
                }
                catch (RuntimeException e1) {
                    logger.log(Level.WARNING, "could not create image from getImageSource():", e1);
                    img = GuiUtils.getErrorImage("Ooops.\n\nSomething went wrong generating this image.\n\n" + GuiUtils.getImproveMsg());
                }
                if (img == null) break;
                ImagePanel imagePanel = new ImagePanel();
                imagePanel.setImage(img);
                this.detailPanel.addTab(label, imagePanel);
                break;
            }
            case 1: {
                HTMLSource htmlSource = (HTMLSource)detailSource3;
                HtmlPanel htmlPanel = new HtmlPanel(this.controller, this, htmlSource.getHTML());
                this.detailPanel.addTab(label, new JScrollPane(htmlPanel));
                break;
            }
            case 2: {
                XMLSource xmlSource = (XMLSource)detailSource3;
                XmlPanel xmlPanel = new XmlPanel();
                xmlPanel.setDocument(xmlPanel.getEditorKit().createDefaultDocument());
                xmlPanel.setText(xmlSource.getXML());
                xmlPanel.setCaretPosition(0);
                this.detailPanel.addTab(label, new JScrollPane(xmlPanel));
                break;
            }
            case 3: {
                TableSource tableSource = (TableSource)detailSource3;
                try {
                    TableModel tableModel = tableSource.getTableModel();
                    if (tableModel.getColumnCount() <= 0 || tableModel.getRowCount() <= 0) break;
                    TablePanel tablePanel = new TablePanel(new JTable());
                    tablePanel.setModel(tableModel);
                    this.detailPanel.addTab(label, tablePanel);
                    break;
                }
                catch (RuntimeException e2) {
                    logger.log(Level.WARNING, "could not create table:", e2);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            String actionCommand;
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            KVP kvp = (KVP)dmtn.getUserObject();
            switch (actionCommand = actionEvent.getActionCommand()) {
                case "expand": {
                    this.expandItem();
                    break;
                }
                case "expand_all": {
                    this.expandAllItems(dmtn);
                    break;
                }
                case "copy": {
                    this.copyItemToClipboard(kvp);
                    break;
                }
                case "copy_tree": {
                    this.copyEntireSubTreeToClipboard(dmtn);
                    break;
                }
                case "view": {
                    this.copyVisibleSubTreeToClipboard(dmtn, path, kvp);
                    break;
                }
                case "parse": {
                    this.parsePid(dmtn, kvp);
                    break;
                }
                case "save": {
                    this.saveDsmccFile(kvp);
                    break;
                }
                case "export": {
                    this.saveDsmccTree(kvp);
                    break;
                }
                case "play": {
                    DVBtree.playAudio138183(kvp);
                    break;
                }
                case "stop": {
                    DVBtree.stopAudio138183(kvp);
                    break;
                }
                case "t2mi": {
                    this.saveT2miTs(kvp);
                    break;
                }
                case "t42": {
                    this.saveT42File(kvp);
                    break;
                }
                case "save_bytes": {
                    this.saveBytes(kvp);
                }
            }
        }
    }

    private void expandAllItems(DefaultMutableTreeNode dmtn) {
        this.expandItem();
        long end = System.currentTimeMillis() + 500L;
        this.expandAllItemsRecursive(dmtn, end);
    }

    private void expandAllItemsRecursive(DefaultMutableTreeNode dmtn, long end) {
        if (System.currentTimeMillis() > end) {
            return;
        }
        this.tree.expandPath(new TreePath(dmtn.getPath()));
        Enumeration<TreeNode> children = dmtn.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child;
            TreeNode treeNode = children.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || (child = (DefaultMutableTreeNode)treeNode).isLeaf()) continue;
            this.expandAllItemsRecursive(child, end);
        }
    }

    private void expandItem() {
        this.tree.expandPath(this.tree.getSelectionPath());
    }

    private void saveT2miTs(KVP kvp) {
        PlpHandler plpHandler = (PlpHandler)kvp.getOwner();
        String fileName = this.ts.getFile().getName() + "_pid_" + plpHandler.getPid() + "_plp_" + plpHandler.getPlpId() + ".ts";
        this.selectFileAndSave(fileName, plpHandler);
    }

    private static void stopAudio138183(KVP kvp) {
        Audio138183Handler audioHandler = (Audio138183Handler)kvp.getOwner();
        audioHandler.stop();
    }

    private static void playAudio138183(KVP kvp) {
        Audio138183Handler audioHandler = (Audio138183Handler)kvp.getOwner();
        audioHandler.play();
    }

    private void saveDsmccTree(KVP kvp) {
        ServiceDSMCC.DSMFile dsmFile = (ServiceDSMCC.DSMFile)kvp.getOwner();
        JFileChooser chooser = GuiUtils.createFileChooser();
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            PreferencesManager.setSaveDir(file.getAbsolutePath());
            logger.info("Preparing to save as: " + file.getName() + ", path:" + file.getAbsolutePath());
            File newDir = new File(file, dsmFile.getLabel());
            this.confirmOverwriteIfExisting(newDir, dsmFile);
        } else {
            logger.info("Open command cancelled by user.");
        }
    }

    private void saveDsmccFile(KVP kvp) {
        ServiceDSMCC.DSMFile dsmFile = (ServiceDSMCC.DSMFile)kvp.getOwner();
        String fileName = dsmFile.getLabel();
        this.selectFileAndSave(fileName, dsmFile);
    }

    private void saveT42File(KVP kvp) {
        Object owner;
        Object object = owner = kvp.getOwner();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubPage.class, EBUTeletextHandler.class}, (Object)object2, n)) {
            case 0: {
                SubPage subPage = (SubPage)object2;
                String fileName = "Page" + subPage.getMagazineNo() + Utils.toHexStringUnformatted(subPage.getPageNo(), 2) + "-" + Utils.toHexStringUnformatted(subPage.getSubPageNo(), 4) + ".t42";
                this.selectFileAndSave(fileName, subPage);
                break;
            }
            case 1: {
                EBUTeletextHandler txtHandler = (EBUTeletextHandler)object2;
                this.selectFileAndSave("Txt Service.t42", txtHandler);
                break;
            }
        }
    }

    private void parsePid(DefaultMutableTreeNode dmtn, KVP kvp) {
        PID p;
        block6: {
            p = (PID)kvp.getOwner();
            int pid = p.getPid();
            GeneralPidHandler generalPidHandler = p.getPidHandler();
            if (generalPidHandler.isInitialized()) {
                return;
            }
            HashMap<Integer, GeneralPidHandler> handlerMap = new HashMap<Integer, GeneralPidHandler>();
            handlerMap.put(pid, generalPidHandler);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.ts.parsePidStreams(handlerMap);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "could not read file " + this.ts.getFile().getName() + " while parsing PES", e);
                this.setCursor(Cursor.getDefaultCursor());
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "could not parse PID " + pid + " using handler " + generalPidHandler.getClass().getName(), e);
                if (generalPidHandler.getClass() == GeneralPesHandler.class || generalPidHandler.getClass() == GeneralPsiTableHandler.class) break block6;
                logger.log(Level.WARNING, "trying again with GeneralPesHandler");
                JOptionPane.showMessageDialog(this, "Error parsing PID PES Packets for " + String.valueOf(p.getLabelMaker()) + ", falling back to general PES packets", "DVB Inspector", 2);
                p.setPidHandler(new GeneralPesHandler());
                generalPidHandler = p.getPidHandler();
                handlerMap = new HashMap();
                handlerMap.put(pid, generalPidHandler);
                try {
                    this.ts.parsePidStreams(handlerMap);
                }
                catch (IOException e1) {
                    logger.log(Level.WARNING, "could not read file " + this.ts.getFile().getName() + " while parsing PES again with general PESHandler", e1);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        DefaultMutableTreeNode node = p.getPidHandler().getJTreeNode(this.mod);
        dmtn.add(node);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(dmtn);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void copyVisibleSubTreeToClipboard(DefaultMutableTreeNode dmtn, TreePath path, KVP kvp) {
        String res = kvp.getPlainText() + System.lineSeparator() + String.valueOf(this.getViewTree(dmtn, "", path));
        StringSelection stringSelection = new StringSelection(res);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void copyEntireSubTreeToClipboard(DefaultMutableTreeNode dmtn) {
        KVP kvp = (KVP)dmtn.getUserObject();
        String treeString = kvp.getPlainText() + System.lineSeparator() + String.valueOf(DVBtree.getEntireTree(dmtn, ""));
        StringSelection stringSelection = new StringSelection(treeString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void copyItemToClipboard(KVP kvp) {
        StringSelection stringSelection = new StringSelection(kvp.getPlainText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public static StringBuilder getEntireTree(DefaultMutableTreeNode dmtn, String preFix) {
        StringBuilder res = new StringBuilder();
        Enumeration<TreeNode> children = dmtn.children();
        while (children.hasMoreElements()) {
            TreeNode next = children.nextElement();
            if (!(next instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)next;
            Object userObject = child.getUserObject();
            if (userObject instanceof KVP) {
                KVP chKVP = (KVP)userObject;
                res.append(preFix).append("+-").append(chKVP.getPlainText()).append(System.lineSeparator());
                if (child.isLeaf()) continue;
                if (child == dmtn.getLastChild()) {
                    res.append((CharSequence)DVBtree.getEntireTree(child, preFix + "  "));
                    continue;
                }
                res.append((CharSequence)DVBtree.getEntireTree(child, preFix + "| "));
                continue;
            }
            logger.log(Level.SEVERE, "Not an KVP: {}", userObject);
        }
        return res;
    }

    private StringBuilder getViewTree(DefaultMutableTreeNode dmtn, String preFix, TreePath path) {
        StringBuilder res = new StringBuilder();
        Enumeration<TreeNode> children = dmtn.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child;
            TreePath childPath;
            TreeNode next = children.nextElement();
            if (!(next instanceof DefaultMutableTreeNode) || !this.tree.isVisible(childPath = path.pathByAddingChild(child = (DefaultMutableTreeNode)next))) continue;
            KVP chKVP = (KVP)child.getUserObject();
            res.append(preFix).append("+-").append(chKVP.getPlainText()).append(System.lineSeparator());
            if (child.isLeaf()) continue;
            if (child == dmtn.getLastChild()) {
                res.append((CharSequence)this.getViewTree(child, preFix + "  ", childPath));
                continue;
            }
            res.append((CharSequence)this.getViewTree(child, preFix + "| ", childPath));
        }
        return res;
    }

    private void showContextMenu(MouseEvent e) {
        block6: {
            MenuElement[] subs;
            block7: {
                KVP kvp;
                block8: {
                    TreePath path = this.tree.getSelectionPath();
                    for (MenuElement sub : subs = this.popup.getSubElements()) {
                        JMenuItem menuElement = (JMenuItem)sub;
                        menuElement.setEnabled(path != null);
                    }
                    if (this.popup.getSubElements().length > 5) {
                        this.popup.remove(5);
                    }
                    if (path == null) break block6;
                    MenuElement[] menuElementArray = (MenuElement[])path.getLastPathComponent();
                    if (!(menuElementArray instanceof DefaultMutableTreeNode)) break block7;
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)menuElementArray;
                    kvp = (KVP)dmtn.getUserObject();
                    JMenuItem subMenu = kvp.getSubMenu();
                    if (subMenu == null) break block8;
                    Object owner = kvp.getOwner();
                    if (owner instanceof PID) {
                        PID p = (PID)owner;
                        GeneralPidHandler pesH = p.getPidHandler();
                        if (!pesH.isInitialized()) {
                            subMenu.addActionListener(this);
                            this.popup.add(subMenu);
                        }
                    } else {
                        subMenu.removeActionListener(this);
                        subMenu.addActionListener(this);
                        this.popup.add(subMenu);
                    }
                    break block6;
                }
                if (!kvp.isBytes()) break block6;
                JMenuItem bytesMenu = new JMenuItem("Save bytes as...");
                bytesMenu.setActionCommand(SAVE_BYTES);
                bytesMenu.addActionListener(this);
                this.popup.add(bytesMenu);
                break block6;
            }
            for (MenuElement sub : subs = this.popup.getSubElements()) {
                JMenuItem menuElement = (JMenuItem)sub;
                menuElement.setEnabled(false);
            }
        }
        this.popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public boolean findAndShow(String s, DefaultMutableTreeNodePreorderEnumaration enumeration) {
        DefaultMutableTreeNode node = DVBtree.searchNode(s.toLowerCase(), enumeration);
        if (node != null) {
            this.showNode(node);
            return true;
        }
        return false;
    }

    public void showRoot() {
        this.showNode((DefaultMutableTreeNode)this.model.getRoot());
    }

    private void showNode(TreeNode node) {
        Object[] nodes = this.model.getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
    }

    public DefaultMutableTreeNodePreorderEnumaration createNewDefaultMutableTreeNodePreorderEnumaration() {
        return new DefaultMutableTreeNodePreorderEnumaration((DefaultMutableTreeNode)this.model.getRoot());
    }

    private static DefaultMutableTreeNode searchNode(String targetString, DefaultMutableTreeNodePreorderEnumaration enumeration) {
        while (enumeration.hasMoreElements()) {
            String nodeString;
            DefaultMutableTreeNode node = enumeration.nextElement();
            if (node == null || !(nodeString = node.getUserObject().toString()).toLowerCase().contains(targetString)) continue;
            return node;
        }
        return null;
    }

    private void saveBytes(KVP kvp) {
        if (!kvp.isBytes()) {
            return;
        }
        SaveAble saveAble = file -> {
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(kvp.getByteValue());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "could not write file", e);
            }
        };
        this.selectFileAndSave(kvp.getLabel(), saveAble);
    }

    private void selectFileAndSave(String fileName, SaveAble saveAble) {
        JFileChooser chooser = GuiUtils.createFileChooser();
        chooser.setSelectedFile(new File(fileName));
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            PreferencesManager.setSaveDir(file.getParent());
            logger.info("Preparing to save as: " + file.getName() + ", path:" + file.getAbsolutePath());
            this.confirmOverwriteIfExisting(file, saveAble);
        } else {
            logger.info("Save cancelled by user.");
        }
    }

    private void confirmOverwriteIfExisting(File file, SaveAble saveAble) {
        boolean write = true;
        if (file.exists()) {
            logger.log(Level.INFO, "file {} already exists.", file);
            int option = JOptionPane.showConfirmDialog(this, "File " + String.valueOf(file) + " already exists, want to overwrite?", "File already exists", 0);
            if (1 == option) {
                write = false;
                logger.info("User canceled overwrite");
            } else {
                logger.info("User confirmed overwrite");
            }
        }
        if (write) {
            saveAble.save(file);
        }
    }

    public class CopyAction
    extends AbstractAction
    implements ClipboardOwner {
        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode dmtn;
            Object object;
            TreePath path = DVBtree.this.tree.getSelectionPath();
            if (path != null && (object = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (object = (dmtn = (DefaultMutableTreeNode)object).getUserObject()) instanceof KVP) {
                KVP kvp = (KVP)object;
                DVBtree.this.copyItemToClipboard(kvp);
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    public class ExpandAllAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object object;
            TreePath path = DVBtree.this.tree.getSelectionPath();
            if (path != null && (object = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)object;
                DVBtree.this.expandAllItems(dmtn);
            }
        }
    }
}

