/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.TransferHandler;
import nl.digitalekabeltelevisie.gui.TSLoader;
import nl.digitalekabeltelevisie.main.DVBinspector;

public class FileDropHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(FileDropHandler.class.getName());
    private DVBinspector controller = null;

    public FileDropHandler(DVBinspector controller) {
        this.controller = controller;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List files;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            logger.log(Level.WARNING, "File drophandler error, should never happen (or JDK is buggy)", ex);
            return false;
        }
        if (!files.isEmpty()) {
            File file = (File)files.get(0);
            logger.info("file dropped: " + file.getName());
            if (file.isFile()) {
                TSLoader tsLoader = new TSLoader(file, this.controller);
                tsLoader.execute();
            }
        }
        return true;
    }
}

