/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.digitalekabeltelevisie.gui.TSLoader;
import nl.digitalekabeltelevisie.main.DVBinspector;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public class FileOpenAction
extends AbstractAction {
    private final FileNameExtensionFilter tsFilter = new FileNameExtensionFilter("MPEG-TS (*.ts;*.mpg;*.mpeg;*.m2ts;*.mts;*.tsa;*.tsv;*.trp)", "ts", "mpg", "mpeg", "m2ts", "mts", "tsa", "tsv", "trp");
    private final JFileChooser fileChooser = new JFileChooser();
    private final DVBinspector contr;

    public FileOpenAction(DVBinspector controller) {
        super("Open");
        this.fileChooser.addChoosableFileFilter(this.tsFilter);
        this.contr = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String defaultDir = PreferencesManager.getLastUsedDir();
        if (defaultDir != null) {
            File defDir = new File(defaultDir);
            this.fileChooser.setCurrentDirectory(defDir);
        }
        if (PreferencesManager.getSelectMpegFileFilter()) {
            this.fileChooser.setFileFilter(this.tsFilter);
        } else {
            this.fileChooser.setFileFilter(this.fileChooser.getAcceptAllFileFilter());
        }
        int returnVal = this.fileChooser.showOpenDialog(this.contr.getFrame());
        if (returnVal == 0) {
            this.contr.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            File file = this.fileChooser.getSelectedFile();
            PreferencesManager.setSelectMpegFileFilter(this.fileChooser.getFileFilter() == this.tsFilter);
            TSLoader tsLoader = new TSLoader(file, this.contr);
            tsLoader.execute();
        }
    }
}

