/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import nl.digitalekabeltelevisie.main.DVBinspector;
import nl.digitalekabeltelevisie.util.DefaultMutableTreeNodePreorderEnumaration;

class FindDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private String searchText = null;
    private JTextField textField;
    private JOptionPane optionPane;
    DVBinspector controller;
    private String buttonString1 = "Search";
    private String buttonString2 = "Cancel";
    private DefaultMutableTreeNodePreorderEnumaration enummeration;

    public FindDialog(DVBinspector controller) {
        super((Frame)controller.getFrame(), true);
        this.controller = controller;
        this.enummeration = controller.getTreeView().createNewDefaultMutableTreeNodePreorderEnumaration();
        controller.setSearchEnumeration(this.enummeration);
        controller.setSearchString(null);
        this.setTitle("Search");
        this.textField = new JTextField();
        String msgString1 = "Find";
        Object[] array = new Object[]{msgString1, this.textField};
        Object[] options = new Object[]{this.buttonString1, this.buttonString2};
        this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                FindDialog.this.textField.requestFocusInWindow();
            }
        });
        this.textField.addActionListener(this);
        this.optionPane.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.optionPane.setValue(this.buttonString1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (this.buttonString1.equals(value)) {
                this.searchText = this.textField.getText();
                this.controller.setSearchString(this.searchText);
                boolean found = this.controller.getTreeView().findAndShow(this.searchText, this.enummeration);
                if (!found) {
                    this.setTitle("No (more) instances of '" + this.searchText + "' found");
                    this.controller.setSearchEnumeration(null);
                    this.controller.setSearchString(null);
                    this.textField.setEnabled(false);
                    this.optionPane.getRootPane().getDefaultButton().setEnabled(false);
                } else {
                    this.optionPane.getRootPane().getDefaultButton().setText("Next");
                    this.textField.setEnabled(false);
                }
            } else {
                this.searchText = null;
                this.clearAndHide();
            }
        }
    }

    public void clearAndHide() {
        this.textField.setText(null);
        this.setVisible(false);
    }
}

