/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.TextHTMLTransferable;
import nl.digitalekabeltelevisie.util.Utils;

public class Grid
extends JPanel
implements ComponentListener,
Scrollable {
    private static final float[] DASH1 = new float[]{3.0f};
    private static final BasicStroke DASHED = new BasicStroke(2.0f, 0, 0, 3.0f, DASH1, 0.0f);
    private static final long serialVersionUID = 7881015434582215246L;
    private int blockW = 20;
    private int blockH = 20;
    private int gridLines = 0;
    private int blocksPerRow = 100;
    private int lines = 0;
    private TransportStream stream;
    private Map<Short, Paint> colors;
    private int startPacket;
    private int noPacketsInView;
    private boolean showAdaptationField = false;
    private boolean showPayloadStart = false;
    private boolean showErrorIndicator = false;

    public Grid(TransportStream stream, ViewContext viewContext) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Grid.this.requestFocus();
            }
        });
        this.addComponentListener(this);
        this.setTransportStream(stream, viewContext);
    }

    public final void setTransportStream(TransportStream stream, ViewContext viewContext) {
        this.stream = stream;
        this.colors = new HashMap<Short, Paint>();
        if (stream != null) {
            this.startPacket = viewContext.getStartPacket();
            int endPacket = viewContext.getEndPacket();
            this.noPacketsInView = endPacket - this.startPacket;
            this.lines = this.noPacketsInView / this.blocksPerRow;
            if (this.noPacketsInView % this.blocksPerRow != 0) {
                ++this.lines;
            }
            for (ChartLabel l : viewContext.getShown()) {
                this.colors.put(l.getPid(), l.getColor());
            }
        }
        this.setToolTipText("Test");
        GridCopyAction copyAction = new GridCopyAction();
        KeyStroke copyKey = KeyStroke.getKeyStroke(67, 128);
        this.getInputMap().put(copyKey, "copy");
        this.getActionMap().put("copy", copyAction);
        this.revalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D graphics2d = (Graphics2D)g;
        graphics2d.setStroke(DASHED);
        this.setBackground(Color.WHITE);
        super.paintComponent(graphics2d);
        if (this.stream != null) {
            int startline = graphics2d.getClipBounds().y / this.blockH;
            int endLine = startline + 1 + graphics2d.getClipBounds().height / this.blockH;
            for (int row = startline; row <= endLine; ++row) {
                for (int column = 0; column < this.blocksPerRow; ++column) {
                    this.paintPacket(graphics2d, row, column);
                }
            }
        }
    }

    private void paintPacket(Graphics2D graphics2d, int row, int column) {
        int packetNo = row * this.blocksPerRow + column;
        if (packetNo < this.noPacketsInView) {
            short pidFlags = this.stream.getPacketPidFlags(packetNo + this.startPacket);
            short pid = (short)(pidFlags & 0x1FFF);
            Color packetPidColor = (Color)this.colors.get(pid);
            if (packetPidColor == null) {
                this.paintGridLines(graphics2d, row, column, Color.WHITE);
            } else {
                graphics2d.setColor(packetPidColor);
                graphics2d.fillRect(column * this.blockW, row * this.blockH, this.blockW, this.blockH);
                this.paintAdaptationFieldMarker(graphics2d, row, column, pidFlags, packetPidColor);
                this.paintPayloadStartMarker(graphics2d, row, column, pidFlags, packetPidColor);
                this.paintErrorFlagMarker(graphics2d, row, column, pidFlags, packetPidColor);
                this.paintGridLines(graphics2d, row, column, packetPidColor);
            }
        }
    }

    private void paintGridLines(Graphics2D g2, int row, int column, Color packetPidColor) {
        if (this.gridLines != 0) {
            if (column % this.gridLines == 0 && column != 0) {
                g2.setColor(Grid.getContrastingColor(packetPidColor));
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawLine(column * this.blockW, row * this.blockH + 1, column * this.blockW, (row + 1) * this.blockH - 1);
            }
            if (row % this.gridLines == 0 && row != 0) {
                g2.setColor(Grid.getContrastingColor(packetPidColor));
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawLine(column * this.blockW, row * this.blockH, (column + 1) * this.blockW - 1, row * this.blockH);
            }
        }
    }

    private void paintErrorFlagMarker(Graphics2D g2, int row, int column, short pidFlags, Color packetPidColor) {
        short errorFlag = (short)(pidFlags & 0x8000);
        if (this.showErrorIndicator && errorFlag != 0) {
            g2.setColor(Grid.getContrastingColor(packetPidColor));
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(column * this.blockW + 1, row * this.blockH + 1, (column + 1) * this.blockW - 1, (row + 1) * this.blockH - 1);
            g2.drawLine(column * this.blockW + 1, (row + 1) * this.blockH - 1, (column + 1) * this.blockW - 1, row * this.blockH + 1);
        }
    }

    private void paintPayloadStartMarker(Graphics2D g2, int row, int column, short pidFlags, Color packetPidColor) {
        short payloadStartFlag = (short)(pidFlags & 0x4000);
        if (this.showPayloadStart && payloadStartFlag != 0) {
            g2.setColor(Grid.getContrastingColor(packetPidColor));
            g2.setStroke(DASHED);
            g2.drawRect(column * this.blockW + 1, row * this.blockH + 1, this.blockW - 2, this.blockH - 2);
        }
    }

    private void paintAdaptationFieldMarker(Graphics2D g, int row, int column, short pidFlags, Color packetPidColor) {
        short adaptationFlag = (short)(pidFlags & 0x2000);
        if (this.showAdaptationField && adaptationFlag != 0) {
            g.setColor(Grid.getContrastingColor(packetPidColor));
            g.fillRect(column * this.blockW + 2, row * this.blockH + 2, this.blockW / 2, this.blockH / 2);
        }
    }

    private static Color getContrastingColor(Color c) {
        if (c.getGreen() + c.getRed() + c.getBlue() < 384) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.stream == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.blocksPerRow * this.blockW, this.lines * this.blockH);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        short pid;
        int y;
        int x;
        int realPacketNo;
        if (this.stream != null && (realPacketNo = this.getPacketNumber(x = e.getX(), y = e.getY())) >= 0 && this.colors.containsKey(pid = this.stream.getPacket_pid(realPacketNo))) {
            return this.getPacketHTML(realPacketNo);
        }
        return "";
    }

    private int getPacketNumber(int x, int y) {
        int packetNo;
        if (x >= 0 && y >= 0 && x / this.blockW < this.blocksPerRow && (packetNo = y / this.blockH * this.blocksPerRow + x / this.blockW) < this.noPacketsInView) {
            return packetNo + this.startPacket;
        }
        return -1;
    }

    private String getPacketHTML(int realPacketNo) {
        StringBuilder r = new StringBuilder();
        TSPacket packet = this.stream.getTSPacket(realPacketNo);
        r.append("<html>");
        if (packet == null) {
            short pid = this.stream.getPacket_pid(realPacketNo);
            r.append("Packet: ").append(realPacketNo);
            r.append("<br>PID: ").append(pid);
            r.append("<br>Time: ").append(this.stream.getPacketTime(realPacketNo));
            r.append("<br>").append(Utils.escapeHtmlBreakLines(this.stream.getShortLabel(pid)));
        } else {
            r.append(packet.getHTML());
        }
        r.append("</html>");
        return r.toString();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int wid = (int)this.getVisibleRect().getWidth();
        this.blocksPerRow = wid / this.blockW;
        if (this.stream != null) {
            this.lines = this.noPacketsInView / this.blocksPerRow;
            if (this.noPacketsInView % this.blocksPerRow != 0) {
                ++this.lines;
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.repaint();
    }

    public void setShowAdaptationField(boolean b) {
        this.showAdaptationField = b;
        this.repaint();
    }

    public void setShowPayloadStart(boolean b) {
        this.showPayloadStart = b;
        this.repaint();
    }

    public void setShowErrorIndicator(boolean b) {
        this.showErrorIndicator = b;
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.blockW;
        }
        return this.blockH;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.blockW;
        }
        int h = (int)this.getVisibleRect().getHeight();
        return h - h % this.blockH;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setBlockSize(int s) {
        this.blockW = s;
        this.blockH = s;
        this.componentResized(null);
    }

    public int getGridLines() {
        return this.gridLines;
    }

    public void setGridLines(int gridLines) {
        this.gridLines = gridLines;
        this.repaint();
    }

    class GridCopyAction
    extends AbstractAction {
        GridCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            short pid;
            Point windowLocation = Grid.this.getLocationOnScreen();
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            int x = mouseLocation.x - windowLocation.x;
            int y = mouseLocation.y - windowLocation.y;
            int realPacketNo = Grid.this.getPacketNumber(x, y);
            if (realPacketNo >= 0 && Grid.this.colors.containsKey(pid = Grid.this.stream.getPacket_pid(realPacketNo))) {
                String htmlString = Grid.this.getPacketHTML(realPacketNo);
                String plainData = Utils.extractTextFromHTML(htmlString);
                TextHTMLTransferable transferable = new TextHTMLTransferable(plainData, htmlString);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(transferable, null);
            }
        }
    }
}

