/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.Grid;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.utils.WrapLayout;
import nl.digitalekabeltelevisie.util.Utils;

public class GridView
extends JPanel
implements TransportStreamView {
    private final Grid grid;
    private final JPanel buttonPanel = new JPanel(new WrapLayout());

    public GridView(TransportStream transportStream, ViewContext viewContext) {
        super(new BorderLayout());
        this.addPacketCheckBoxes();
        this.buttonPanel.add(Box.createHorizontalStrut(20));
        this.addZoomRadioButtons();
        this.buttonPanel.add(Box.createHorizontalStrut(20));
        this.addGridLinesRadioButtons();
        this.add((Component)this.buttonPanel, "First");
        this.grid = new Grid(transportStream, viewContext);
        JScrollPane scrollGrid = new JScrollPane(this.grid);
        scrollGrid.setVerticalScrollBarPolicy(22);
        scrollGrid.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollGrid, "Center");
    }

    private void addPacketCheckBoxes() {
        Image adImg = Utils.readIconImage("adaptation.bmp");
        Image payloadImg = Utils.readIconImage("payloadstart.bmp");
        Image errorImg = Utils.readIconImage("errorindicator.bmp");
        ImageIcon adaptationIcon = new ImageIcon(adImg);
        ImageIcon payloadIcon = new ImageIcon(payloadImg);
        ImageIcon errorIcon = new ImageIcon(errorImg);
        JLabel adaptationLabel = new JLabel(adaptationIcon);
        this.buttonPanel.add(adaptationLabel);
        JCheckBox adaptationFieldButton = new JCheckBox("Show Adaptation Field");
        adaptationFieldButton.addItemListener(e -> this.grid.setShowAdaptationField(e.getStateChange() == 1));
        this.buttonPanel.add(adaptationFieldButton);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        JLabel payLoadStartLabel = new JLabel(payloadIcon);
        this.buttonPanel.add(payLoadStartLabel);
        JCheckBox payLoadStartButton = new JCheckBox("Show Payload Start");
        payLoadStartButton.addItemListener(e -> this.grid.setShowPayloadStart(e.getStateChange() == 1));
        this.buttonPanel.add(payLoadStartButton);
        JLabel errorLabel = new JLabel(errorIcon);
        this.buttonPanel.add(errorLabel);
        JCheckBox errorButton = new JCheckBox("Show Error Indicator");
        errorButton.addItemListener(e -> this.grid.setShowErrorIndicator(e.getStateChange() == 1));
        this.buttonPanel.add(errorButton);
    }

    @Override
    public void setTransportStream(TransportStream transportStream, ViewContext viewContext) {
        this.grid.setTransportStream(transportStream, viewContext);
        this.validate();
        this.repaint();
    }

    private void addZoomRadioButtons() {
        JLabel typeLabel = new JLabel("Zoom:");
        this.buttonPanel.add(typeLabel);
        int zoomLevels = 7;
        JRadioButton[] zoomButtons = new JRadioButton[zoomLevels];
        int size = 1;
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < zoomButtons.length; ++i) {
            int s = size;
            zoomButtons[i] = new JRadioButton("" + (i + 1));
            zoomButtons[i].addActionListener(e -> this.grid.setBlockSize(s));
            size *= 2;
            group.add(zoomButtons[i]);
            this.buttonPanel.add(zoomButtons[i]);
        }
        zoomButtons[Math.min(zoomLevels - 1, 4)].setSelected(true);
    }

    private void addGridLinesRadioButtons() {
        JLabel typeLabel = new JLabel("Grid Lines:");
        this.buttonPanel.add(typeLabel);
        ButtonGroup group = new ButtonGroup();
        this.addGridRadioButton(group, "Off", 0, true);
        this.addGridRadioButton(group, "1", 1, false);
        this.addGridRadioButton(group, "5", 5, false);
        this.addGridRadioButton(group, "10", 10, false);
        this.addGridRadioButton(group, "20", 20, false);
    }

    private void addGridRadioButton(ButtonGroup group, String label, int value, boolean selected) {
        JRadioButton button = new JRadioButton(label);
        button.addActionListener(e -> this.grid.setGridLines(value));
        group.add(button);
        this.buttonPanel.add(button);
        button.setSelected(selected);
    }
}

